/*
 * Decompiled with CFR 0.152.
 */
package de.superx.stat.pl;

import com.google.common.base.Joiner;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.MaterialDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.SatzFilter;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.pleditor.generator.runtime.plausi.WertNichtTypgerechtException;
import de.statspez.pleditor.generator.runtime.refdat.csv.CSVReferenzDateiVerwaltung;
import de.statspez.pleditor.generator.runtime.refdat.csv.EinfacherEFSatz;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuperxReferenzDateiZugriff
extends CSVReferenzDateiVerwaltung {
    private static Logger logger = LoggerFactory.getLogger(SuperxReferenzDateiZugriff.class);
    private Map<String, List<EinfacherEFSatz>> referenzDateiFilterCache = new HashMap<String, List<EinfacherEFSatz>>();

    public SuperxReferenzDateiZugriff(String dir) {
        super(dir);
        this.refdatFileExtension = ".csv";
    }

    public String getAktuelleVersion(String refDatName) {
        String version = super.getAktuelleVersion(refDatName);
        logger.debug("Get aktuelle Version: {} = {}", (Object)refDatName, (Object)version);
        return version;
    }

    public String[] getReferenzdateien() {
        Object[] refDateien = super.getReferenzdateien();
        logger.debug("Get Referenzdateien: {}", (Object)Joiner.on((char)',').join(refDateien));
        return refDateien;
    }

    public SatzInterface[] gibSaetzeGefiltert(FeldDeskriptorInterface[] felder, SatzFilter filter, MaterialDeskriptorInterface material) throws NoSuchFieldException {
        String cacheKey = this.getCacheKeyFor(material, filter);
        if (this.referenzDateiFilterCache.containsKey(cacheKey)) {
            return (SatzInterface[])this.referenzDateiFilterCache.get(cacheKey).toArray(new EinfacherEFSatz[0]);
        }
        Vector<EinfacherEFSatz> referenzDatei = this.getReferenzDatei(material);
        Vector<EinfacherEFSatz> saetzeGefiltert = null;
        if (filter != null && filter.getFilterBedingungen() != null && filter.getFilterBedingungen().length != 0) {
            saetzeGefiltert = new Vector<EinfacherEFSatz>();
            logger.info("Material {}", (Object)(material.getMaterialName() + " (" + material.getMaterialDSBName() + ") "));
            for (int i = 0; i < referenzDatei.size(); ++i) {
                EinfacherEFSatz satz = (EinfacherEFSatz)referenzDatei.get(i);
                boolean aufnehmen = true;
                SatzFilter.FilterBedingung[] bedingungen = null;
                if (filter != null) {
                    bedingungen = filter.getFilterBedingungen();
                }
                if (bedingungen != null && bedingungen.length > 0) {
                    block9: for (int j = 0; j < bedingungen.length && aufnehmen; ++j) {
                        if (!(bedingungen[j].feld instanceof FeldDeskriptorImpl)) {
                            throw new NoSuchFieldException("Felddeskriptor f\u00fcr Referenzdateifeld \"" + bedingungen[j].feld.getFeldNameTB() + "\" nicht FeldDeskriptorImpl.");
                        }
                        FeldDeskriptorImpl refdatFeldDeskriptor = (FeldDeskriptorImpl)bedingungen[j].feld;
                        Value refdatWert = refdatFeldDeskriptor.getValueFrom((SatzInterface)satz);
                        Value vergleichsWert = bedingungen[j].vergleichsWert;
                        switch (bedingungen[j].operator) {
                            case 1: {
                                aufnehmen = refdatWert.eq(vergleichsWert);
                                continue block9;
                            }
                            case 2: {
                                aufnehmen = refdatWert.lt(vergleichsWert);
                                continue block9;
                            }
                            case 3: {
                                aufnehmen = refdatWert.gt(vergleichsWert);
                                continue block9;
                            }
                            case 4: {
                                aufnehmen = refdatWert.ne(vergleichsWert);
                                continue block9;
                            }
                            case 5: {
                                aufnehmen = refdatWert.le(vergleichsWert);
                                continue block9;
                            }
                            case 6: {
                                aufnehmen = refdatWert.ge(vergleichsWert);
                            }
                        }
                    }
                }
                if (!aufnehmen) continue;
                saetzeGefiltert.addElement(satz);
            }
        } else {
            saetzeGefiltert = referenzDatei;
        }
        this.referenzDateiFilterCache.put(cacheKey, (List<EinfacherEFSatz>)saetzeGefiltert);
        return saetzeGefiltert.toArray(new EinfacherEFSatz[0]);
    }

    private String getCacheKeyFor(MaterialDeskriptorInterface material, SatzFilter filter) {
        StringBuilder key = new StringBuilder(material.getMaterialDSBName()).append(":");
        for (SatzFilter.FilterBedingung bedingung : filter.getFilterBedingungen()) {
            key.append(bedingung.feld.getFeldNameDSB()).append("/").append(bedingung.operator + bedingung.vergleichsWert.asString() + "|");
        }
        return key.toString();
    }

    public boolean liefertDenZugriffAuf(MaterialDeskriptorInterface material) {
        boolean liefert = true;
        return liefert;
    }

    protected String getMaterialBezeichner(MaterialDeskriptorInterface material) {
        String retVal = material.getMaterialName().substring(0, material.getMaterialName().lastIndexOf(95));
        return retVal;
    }

    private Vector getReferenzDatei(MaterialDeskriptorInterface material) throws NoSuchFieldException {
        Vector<EinfacherEFSatz> referenzDatei = (Vector<EinfacherEFSatz>)this.referenzDateiHashMap.get(this.getMaterialBezeichner(material));
        if (referenzDatei == null) {
            referenzDatei = new Vector<EinfacherEFSatz>();
            try {
                File referenceFile = new File(String.join((CharSequence)"/", this.resourcePath, this.getMaterialBezeichner(material) + this.refdatFileExtension));
                BufferedReader bufferedReader = new BufferedReader(new FileReader(referenceFile));
                String line = null;
                boolean delimiterChecked = false;
                while ((line = bufferedReader.readLine()) != null) {
                    String[] werte;
                    if (!delimiterChecked) {
                        logger.info("checking file for delimiter '{}'", (Object)referenceFile.getName());
                        int commaCount = 0;
                        int semicolonCount = 0;
                        String tmpLine = line.replaceAll("\\w", "").trim();
                        for (char c : tmpLine.toCharArray()) {
                            if (c == ',') {
                                ++commaCount;
                            }
                            if (c != ';') continue;
                            ++semicolonCount;
                        }
                        if (commaCount > semicolonCount) {
                            this.csvSplitString = ",";
                        }
                        if (semicolonCount > commaCount) {
                            this.csvSplitString = ";";
                        }
                        delimiterChecked = true;
                    }
                    if ((werte = line.split(this.csvSplitString)) == null || werte.length <= 0 || werte[0] == null || werte[0].length() <= 0) continue;
                    referenzDatei.addElement(new EinfacherEFSatz(werte));
                }
                bufferedReader.close();
            }
            catch (Exception e) {
                logger.error("Referenzdatei \"" + this.getMaterialBezeichner(material) + "\" konnte im Ressource-Pfad " + this.resourcePath + " nicht gelesen werden: " + e.getMessage());
            }
            this.referenzDateiHashMap.put(this.getMaterialBezeichner(material), referenzDatei);
        }
        return referenzDatei;
    }

    private HashSet getAlleFeldwerte(MaterialDeskriptorInterface material, FeldDeskriptorInterface feld) throws NoSuchFieldException {
        HashSet<String> referenzDateiFeldwerte;
        HashMap referenzDateiWerte = (HashMap)this.referenzDateiFeldwerteHashMap.get(this.getMaterialBezeichner(material));
        if (referenzDateiWerte == null) {
            referenzDateiWerte = new HashMap();
            this.referenzDateiFeldwerteHashMap.put(this.getMaterialBezeichner(material), referenzDateiWerte);
        }
        if ((referenzDateiFeldwerte = (HashSet<String>)referenzDateiWerte.get(feld.getFeldNameTB())) == null) {
            referenzDateiFeldwerte = new HashSet<String>();
            Vector referenzDatei = this.getReferenzDatei(material);
            if (referenzDatei != null) {
                for (int i = 0; i < referenzDatei.size(); ++i) {
                    EinfacherEFSatz satz = (EinfacherEFSatz)referenzDatei.get(i);
                    try {
                        String wert = satz.getString(feld);
                        if (wert == null || referenzDateiFeldwerte.contains(wert)) continue;
                        referenzDateiFeldwerte.add(wert);
                        continue;
                    }
                    catch (WertNichtTypgerechtException e) {
                        e.printStackTrace();
                    }
                }
            }
            referenzDateiWerte.put(feld.getFeldNameTB(), referenzDateiFeldwerte);
        }
        return referenzDateiFeldwerte;
    }

    /*
     * WARNING - void declaration
     */
    public boolean wertKombinationGueltig(Value[] werte, FeldDeskriptorInterface[] felder, SatzFilter filter, MaterialDeskriptorInterface material) throws NoSuchFieldException {
        logger.debug("=== Wertkombination g\u00fcltig? ===");
        for (Value value : werte) {
            logger.debug("Value: {}", (Object)value);
        }
        for (Value value : felder) {
            logger.debug("Felddeskriptor: {}", (Object)value.getFeldNameDSB());
        }
        SatzFilter.FilterBedingung[] filterBedingungen = filter.getFilterBedingungen();
        if (filterBedingungen.length == 0) {
            logger.debug("Ohne Filter");
        } else {
            void var8_16;
            logger.debug("Filter:");
            SatzFilter.FilterBedingung[] filterBedingungArray = filterBedingungen;
            int n = filterBedingungArray.length;
            boolean bl = false;
            while (var8_16 < n) {
                SatzFilter.FilterBedingung filterBedingung = filterBedingungArray[var8_16];
                logger.debug("Satzfilter: Feld {} op {} Wert {}", new Object[]{filterBedingung.feld.getFeldNameDSB(), filterBedingung.operator, filterBedingung.vergleichsWert.asString()});
                ++var8_16;
            }
        }
        logger.debug("MaterialDeskriptor: {}", (Object)material.getMaterialDSBName());
        boolean wertKombinationGueltig = false;
        if (this.pr\u00fcfeParameterWertKombinationGueltig(werte, felder, filter, material)) {
            if (werte.length == 1 && (filter == null || filter.getFilterBedingungen() == null || filter.getFilterBedingungen().length == 0)) {
                HashSet referenzDateiFeldwerte = this.getAlleFeldwerte(material, felder[0]);
                String string = werte[0].asString();
                wertKombinationGueltig = referenzDateiFeldwerte != null && referenzDateiFeldwerte.contains(string);
            } else {
                void var8_19;
                EinfacherEFSatz[] saetzeGefiltert = (EinfacherEFSatz[])this.gibSaetzeGefiltert(felder, filter, material);
                boolean bl = false;
                while (var8_19 < saetzeGefiltert.length) {
                    boolean wertKombinationGefunden = true;
                    EinfacherEFSatz satz = saetzeGefiltert[var8_19];
                    for (int j = 0; j < felder.length; ++j) {
                        if (felder[j] instanceof FeldDeskriptorImpl) {
                            Value vergleichsWert;
                            FeldDeskriptorImpl refdatFeldDeskriptor = (FeldDeskriptorImpl)felder[j];
                            Value refdatWert = refdatFeldDeskriptor.getValueFrom((SatzInterface)satz);
                            if (!refdatWert.ne(vergleichsWert = werte[j])) continue;
                            wertKombinationGefunden = false;
                            break;
                        }
                        throw new NoSuchFieldException("Felddeskriptor f\u00fcr Feld \"" + felder[j].getFeldNameTB() + "\" nicht FeldDeskriptorImpl.");
                    }
                    if (wertKombinationGefunden) {
                        wertKombinationGueltig = true;
                        break;
                    }
                    ++var8_19;
                }
            }
        }
        logger.debug("=== G\u00fcltig: {} ===", (Object)wertKombinationGueltig);
        return wertKombinationGueltig;
    }
}

