/*
 * Decompiled with CFR 0.152.
 */
package de.superx.stat;

import com.google.common.base.CharMatcher;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.meterware.httpunit.UnsupportedActionException;
import de.destatis.core.generator.AbstractDescriptor;
import de.destatis.core.generator.DataProvider;
import de.destatis.core.generator.Descriptor;
import de.destatis.core.generator.FieldDescriptor;
import de.destatis.core.generator.StructureDescriptor;
import de.destatis.core.generator.SurveyDataDocumentGenerator;
import de.destatis.core.generator.SurveyDataDocumentGeneratorException;
import de.destatis.core.inspector.InspectionProblem;
import de.destatis.core.inspector.InspectionReport;
import de.destatis.core.inspector.Inspector;
import de.destatis.core.inspector.ProblemPosition;
import de.destatis.core.resource.DatmlSdfSource;
import de.destatis.core.resource.NoResourceFoundException;
import de.destatis.core.resource.ResourceConfig;
import de.destatis.core.resource.ResourceException;
import de.destatis.core.resource.SurveyResource;
import de.destatis.core.resource.SurveyResourceProvider;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFactory;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFehler;
import de.statspez.pleditor.generator.runtime.plausi.PlausiInterface;
import de.statspez.pleditor.generator.runtime.plausi.PlausiKontext;
import de.statspez.pleditor.generator.runtime.plausi.ReferenzDateiInterface;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.pleditor.generator.runtime.refdat.ReferenzDateiVerwalter;
import de.statspez.pleditor.generator.runtime.refdat.ReferenzDateiZugriffInterface;
import de.statspez.sdf.generator.meta.generated.MetaErhebungsbeschreibung;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmal;
import de.superx.jdbc.entity.Hochschulinfo;
import de.superx.jdbc.mapper.HochschulinfoMapper;
import de.superx.stat.DistributionType;
import de.superx.stat.ExaminationStatistics2016;
import de.superx.stat.ExaminationStatistics2016Short;
import de.superx.stat.StatisticsBase;
import de.superx.stat.pl.SuperxPlausiFehler;
import de.superx.stat.pl.SuperxReferenzDateiZugriff;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.rowset.ResultSetWrappingSqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.xml.sax.InputSource;

public class StatisticExport
implements DataProvider,
SurveyResourceProvider {
    private static final String SELECT_BUNDESLAND_NR = "SELECT apnr FROM cif WHERE key=659";
    private static final String DAT_ML_RAW_D_VERSION = "2.1";
    private static final String SURVEY_PROPERTIES_FILE = "survey.properties";
    static Logger logger = LoggerFactory.getLogger(StatisticExport.class);
    private static final int BATCH_ROWS_PLAUSI = 100;
    private static final int MAX_ROWS_PLAUSI = System.getProperty("ASTAT_PLAUSI_MAX_ROWS") != null ? Integer.parseInt(System.getProperty("ASTAT_PLAUSI_MAX_ROWS")) : 10000;
    JdbcTemplate jt;
    DataSource dataSource;
    SqlRowSet rs;
    String sql;
    Map<String, String> currentRow;
    int currentIndex = -1;
    int endIndex = -1;
    int startIndex = -1;
    String[] columnNames;
    SurveyDataDocumentGenerator generator;
    Properties metaData = new Properties();
    String configDir;
    short sdfValidationMode = (short)10;
    short sdfMetaValidationMode = (short)10;
    MetaErhebungsbeschreibung meta;
    Map<String, MetaSDFMerkmal> merkmale;
    DistributionType distributionType;
    String plausiTable;
    int columnNumberInPlausiTab;
    private static final int COLUMN_NUMBER_PLAUSI_STU = 6;
    private static final int COLUMN_NUMBER_PLAUSI_PROM = 5;
    private static final String PLAUSI_MUSS_MASK = "2";
    private static final String PLAUSI_KANN_MUSS_MASK = "3";
    private static final String PLAUSI_MUSS_DB = "MUSS";
    private String melderVorname;
    private String melderName;
    private String kennung;

    public void setMelderVorname(String melderVorname) {
        this.melderVorname = melderVorname;
    }

    public void setMelderName(String melderName) {
        this.melderName = melderName;
    }

    public StatisticExport(DistributionType distributionType, String configDir, String sqlFilterClause) {
        this.distributionType = distributionType;
        this.plausiTable = distributionType.getPlausiTable();
        this.columnNumberInPlausiTab = !"astat_plausi".equals(this.plausiTable) ? 5 : 6;
        InputStream surveyPropertiesStream = this.getClass().getResourceAsStream(SURVEY_PROPERTIES_FILE);
        if (surveyPropertiesStream != null) {
            try {
                this.metaData.load(surveyPropertiesStream);
            }
            catch (Exception e) {
                throw new RuntimeException("Problem reading survey.properties", e);
            }
        } else {
            logger.warn("survey.properties not found.");
        }
        this.metaData.setProperty("Nachricht[0].ErhebungsID", distributionType.getErhebungsId());
        this.sql = distributionType.getSelectionSql();
        if (sqlFilterClause != null) {
            this.sql = this.sql + " where " + sqlFilterClause;
        }
        this.sql = this.sql + " order by " + distributionType.getOrderBy();
        this.configDir = configDir;
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.setSdfMetaDir(configDir + File.separator + "sdfmeta");
        resourceConfig.setSurveyDir(configDir + File.separator + "sdf");
        this.generator = new SurveyDataDocumentGenerator(resourceConfig);
        this.generator.setSurveyResourceProvider((SurveyResourceProvider)this);
        this.generator.setSDFValidationMode(this.sdfValidationMode);
        this.generator.setSDFMetaValidationMode(this.sdfMetaValidationMode);
    }

    public void generate(OutputStream out) throws SurveyDataDocumentGeneratorException {
        this.metaData.putAll((Map<?, ?>)this.getHochschulProperties());
        String berichtszeitraum = (String)this.jt.queryForObject(this.distributionType.getBerichtszeitraumSql(), String.class);
        this.metaData.setProperty("Nachricht[0].Berichtszeitraum", berichtszeitraum);
        String bundesland = (String)this.jt.queryForObject(SELECT_BUNDESLAND_NR, String.class);
        this.metaData.setProperty("Nachricht[0].Berichtsempfaenger", bundesland != null ? StringUtils.leftPad((String)bundesland, (int)2, (char)'0') : "00");
        try {
            this.generator.generate((DataProvider)this, out, DAT_ML_RAW_D_VERSION);
        }
        catch (SurveyDataDocumentGeneratorException sdde) {
            Object message;
            if (this.currentIndex != -1) {
                String nr = StringUtils.stripStart((String)this.currentRow.get(this.distributionType.getOrderBy()), (String)"0");
                message = "Fehler bei der SDF-Erzeugung f\u00fcr Datensatz Nr. " + (this.currentIndex + 1);
                message = (String)message + "\n<br>(" + sdde.getMessage() + ")";
                message = (String)message + "\n<br><b>Bitte korrigieren Sie die Plausifehler f\u00fcr den Datensatz mit Matrikelnr. " + nr + "</b>";
            } else {
                message = "Fehler bei der SDF-Erzeugung: Datens\u00e4tze f\u00fcr Export sind nicht vorhanden! ";
                message = (String)message + "\n<br>(" + sdde.getMessage() + ")";
            }
            SurveyDataDocumentGeneratorException sddem = new SurveyDataDocumentGeneratorException((String)message);
            throw sddem;
        }
    }

    public StringBuffer generateFixedSizeRecord(StatisticsBase record) {
        if (!record.hasFieldLengths() && this.merkmale == null) {
            logger.warn("Field length unknown. Cannot generate fixed size record.");
            return new StringBuffer();
        }
        StrBuilder result = new StrBuilder();
        int fieldIndex = 0;
        for (String columnName : this.columnNames) {
            String merkmalName = StatisticsBase.translateFieldNameToOrig(columnName);
            MetaSDFMerkmal m = this.merkmale != null ? this.merkmale.get(merkmalName) : null;
            int fieldLength = (int)(record.hasFieldLengths() ? (long)record.getFieldLength(fieldIndex) : m.getLaenge());
            logger.debug("Merkmal: {}, L\u00e4nge: {}", (Object)columnName, (Object)fieldLength);
            String value = record.getString(merkmalName);
            result.appendFixedWidthPadLeft((Object)value, fieldLength, ' ');
            ++fieldIndex;
        }
        return result.toStringBuffer();
    }

    private StringBuffer generateCsvRecord(StatisticsBase record, String sep) {
        StrBuilder result = new StrBuilder();
        for (int i = 0; i < this.columnNames.length; ++i) {
            String merkmalName = StatisticsBase.translateFieldNameToOrig(this.columnNames[i]);
            result.append(record.getString(merkmalName));
            result.append(sep);
        }
        return result.toStringBuffer();
    }

    public void getFixedSizeData(OutputStream out) {
        this.doQuery();
        StatisticsBase record = this.next();
        try {
            while (record != null) {
                if (this.distributionType.skipEmptyExaminationData(record)) {
                    logger.info("Skipping student without examination data");
                    record = this.next();
                    continue;
                }
                StringBuffer line = this.generateFixedSizeRecord(record);
                out.write(line.toString().getBytes());
                out.write(10);
                out.flush();
                record = this.next();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't write fixed size data", e);
        }
    }

    public void getCsvData(OutputStream out) {
        this.doQuery();
        StatisticsBase record = this.next();
        try {
            while (record != null) {
                if (this.distributionType.skipEmptyExaminationData(record)) {
                    logger.info("Skipping student without examination data");
                    record = this.next();
                    continue;
                }
                StringBuffer line = this.generateCsvRecord(record, ";");
                out.write(line.toString().getBytes());
                out.write(10);
                out.flush();
                record = this.next();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't write csv data", e);
        }
    }

    public void getOutput(String mimeType, OutputStream out) throws SurveyDataDocumentGeneratorException {
        switch (mimeType) {
            case "text/xml": {
                this.generate(out);
                break;
            }
            case "text/csv": {
                this.getCsvData(out);
                break;
            }
            case "text/plain": {
                this.getFixedSizeData(out);
                break;
            }
            default: {
                throw new RuntimeException("Unknown mime-type: " + mimeType);
            }
        }
    }

    public InspectionReport getInspectionReport(InputStream inputStream, int inspectionLevel) {
        Inspector inspector = new Inspector();
        inspector.setSurveyResourceProvider((SurveyResourceProvider)this);
        inspector.setInspectionLevel(inspectionLevel);
        InputSource inputSource = null;
        InspectionReport report = null;
        try {
            inputSource = new InputSource(inputStream);
            report = inspector.inspect(inputSource);
        }
        catch (Exception e) {
            logger.error("Problem reading DatML/RAW", (Throwable)e);
        }
        return report;
    }

    public OutputStream getDatMlRaw() throws SurveyDataDocumentGeneratorException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.generate((OutputStream)out);
        return out;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jt = new JdbcTemplate(dataSource);
        this.doQuery();
    }

    public void setSdfValidationMode(short sdfValidationMode) {
        this.generator.setSDFValidationMode(sdfValidationMode);
        this.sdfValidationMode = sdfValidationMode;
    }

    public void setSdfMetaValidationMode(short sdfMetaValidationMode) {
        this.generator.setSDFMetaValidationMode(sdfMetaValidationMode);
        this.sdfMetaValidationMode = sdfMetaValidationMode;
    }

    public static void main(String[] args) {
        String[] refDats;
        FileSystemXmlApplicationContext ctx = new FileSystemXmlApplicationContext("test/spring/testApplicationContextPg.xml");
        StatisticExport stex = new StatisticExport(DistributionType.STUDENTS2016, "test/spring", null);
        stex.setDataSource((DataSource)ctx.getBean("dataSource"));
        try (FileOutputStream out = new FileOutputStream(stex.getConfigDir() + File.separator + "daten_02060810019999000002.xml");){
            stex.generate(out);
        }
        catch (Exception e) {
            logger.error("Couldn't generate DatML/RAW", (Throwable)e);
        }
        logger.debug("Successfully created DatML/RAW.");
        try (FileInputStream in = new FileInputStream(stex.getConfigDir() + File.separator + "daten_02060810019999000002.xml");){
            InspectionReport report = stex.getInspectionReport(in, 4);
            List problems = report.getProblemList();
            Integer numProblems = report.getNumOfProblems();
            Integer numDecls = report.getNumOfDeclarations();
            Integer numMsgs = report.getNumOfMessages();
            logger.warn("Probleme: {}, Nachrichten: {}, Deklarationen: {}, Probleme im Report: {}", new Object[]{numProblems, numMsgs, numDecls, "" + problems.size()});
            for (InspectionProblem problem : problems) {
                ProblemPosition problemPosition = problem.getPosition();
            }
        }
        catch (Exception e) {
            logger.error("Couldn't inspect DatML/RAW", (Throwable)e);
        }
        List<StatisticsBase> ses = stex.getData();
        logger.debug("Anzahl Datens\u00e4tze: {}", (Object)ses.size());
        try (FileOutputStream out = new FileOutputStream(stex.getConfigDir() + File.separator + "daten_02060810019999000002.txt");){
            stex.getFixedSizeData(out);
        }
        catch (Exception e) {
            logger.error("Couldn't generate fixed size data", (Throwable)e);
        }
        stex.jt.execute("delete from astat_stat_plausi");
        PlausiFactory factory = new PlausiFactory();
        PlausiInterface plausi = factory.createPlausi("ERHEBUNG_STUDENTEN_PRUEFUNGEN_AB_2017");
        ReferenzDateiVerwalter dateiVerwalter = new ReferenzDateiVerwalter();
        SuperxReferenzDateiZugriff csvRefVerw = new SuperxReferenzDateiZugriff(stex.getConfigDir() + File.separator + "astat" + File.separator + "csv");
        dateiVerwalter.registriereReferenzdateiZugriff((ReferenzDateiZugriffInterface)csvRefVerw);
        for (String refDat : refDats = csvRefVerw.getReferenzdateien()) {
            logger.debug("Referenzdatei: " + refDat);
        }
        PlausiKontext pctx = new PlausiKontext();
        pctx.setPlausiAblauf(DistributionType.STUDENTS2016.getPlausiAblauf());
        pctx.setReferenzDateien((ReferenzDateiInterface)csvRefVerw);
        pctx.setMerkmalsPruefungWertAbfrageStrategie(2);
        String plausiKannMuss = PLAUSI_KANN_MUSS_MASK;
        for (StatisticsBase se : ses) {
            List<SuperxPlausiFehler> errors = stex.plausi(pctx, se, plausi, plausiKannMuss);
            stex.savePlausiToDb(errors);
        }
    }

    public void doQuery() {
        this.currentIndex = -1;
        this.currentRow = null;
        logger.info("Execute query: {}", (Object)this.sql);
        this.rs = this.jt.queryForRowSet(this.sql);
        SqlRowSetMetaData srsmt = this.rs.getMetaData();
        this.columnNames = srsmt.getColumnNames();
        while (this.currentIndex < this.startIndex - 1 && this.getNextRow()) {
            logger.debug("Skipping " + this.currentIndex);
        }
    }

    public StatisticsBase next() {
        if (this.getNextRow()) {
            StatisticsBase s = this.distributionType.getStatisticsRecord();
            s.setData(this.currentRow);
            return s;
        }
        return null;
    }

    public void doPlausi(String maskPlausi) {
        if (this.distributionType.getPlausi() == null) {
            throw new UnsupportedActionException("Plausi not available for " + this.distributionType.getDescription());
        }
        PlausiFactory factory = new PlausiFactory();
        PlausiInterface plausi = factory.createPlausi(this.distributionType.getPlausi());
        if (plausi != null) {
            ReferenzDateiVerwalter dateiVerwalter = new ReferenzDateiVerwalter();
            String refDir = this.configDir.substring(0, this.configDir.indexOf("WEB-INF") + 8) + File.separator + "classes" + File.separator + "de" + File.separator + "statspez" + File.separator + "plausi" + File.separator + "astat" + File.separator + "csv";
            logger.debug("Referenzdatei dir: " + refDir);
            SuperxReferenzDateiZugriff csvRefVerw = new SuperxReferenzDateiZugriff(refDir);
            dateiVerwalter.registriereReferenzdateiZugriff((ReferenzDateiZugriffInterface)csvRefVerw);
            this.jt.execute("delete from " + this.distributionType.getPlausiTable());
            int count = 0;
            int countPlausi = 0;
            ArrayList<SuperxPlausiFehler> batchErrors = new ArrayList<SuperxPlausiFehler>();
            this.doQuery();
            PlausiKontext ctx = new PlausiKontext();
            ctx.setPlausiAblauf(this.distributionType.getPlausiAblauf());
            ctx.setReferenzDateien((ReferenzDateiInterface)dateiVerwalter);
            ctx.setMerkmalsPruefungWertAbfrageStrategie(2);
            while (countPlausi < MAX_ROWS_PLAUSI && this.getNextRow()) {
                StatisticsBase s = this.distributionType.getStatisticsRecord();
                s.setData(this.currentRow);
                if (this.distributionType == DistributionType.EXAMINATIONS2016 && !((ExaminationStatistics2016)s).hasExaminationData() || this.distributionType == DistributionType.EXAMINATIONS2016_SHORT && !((ExaminationStatistics2016Short)s).hasExaminationData()) continue;
                ++count;
                List<SuperxPlausiFehler> errors = this.plausi(ctx, s, plausi, maskPlausi);
                batchErrors.addAll(errors);
                countPlausi += errors.size();
                if (batchErrors.size() <= 100) continue;
                this.savePlausiToDb(batchErrors);
                batchErrors = new ArrayList();
            }
            this.savePlausiToDb(batchErrors);
            logger.debug("{} rows checked with {} plausi errors found", (Object)count, (Object)countPlausi);
        } else {
            logger.error("Couldn't get PlausiInterface");
        }
    }

    public void savePlausiToDb(final List<SuperxPlausiFehler> errors) {
        Object sInsert = "";
        sInsert = !"astat_plausi".equals(this.plausiTable) ? "INSERT into " + this.distributionType.getPlausiTable() + " (key,fehlerid,fehlertext,korrekturhinweis,einzelfelder) VALUES (?,?,?,?,?)" : "INSERT into " + this.distributionType.getPlausiTable() + " (key,fehlerid,fehlertext,korrekturhinweis,einzelfelder,kategorie) values (?,?,?,?,?,?)";
        try {
            this.jt.batchUpdate((String)sInsert, new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    String fehlertext;
                    SuperxPlausiFehler error = (SuperxPlausiFehler)errors.get(i);
                    String fehlertextLang = error.getFehlertextLang();
                    if (fehlertextLang == null) {
                        fehlertext = error.getFehlertextKurz();
                        if (fehlertext == null) {
                            fehlertext = "Keine Fehlerbeschreibung in aStat-Plausi-Klassen vorhanden.";
                        }
                    } else {
                        String string = fehlertext = fehlertextLang.isEmpty() ? error.getFehlertextKurz() : fehlertextLang;
                    }
                    if (fehlertext == null || fehlertext.isEmpty()) {
                        fehlertext = "Keine Fehlerbeschreibung in aStat-Plausi-Klassen vorhanden.";
                    }
                    ps.setString(1, error.getKey());
                    ps.setString(2, error.getFehlerId());
                    ps.setString(3, fehlertext);
                    ps.setString(4, error.getFehlerKorrekturhinweis());
                    String ref = error.getReferenz();
                    ps.setString(5, ref);
                    if (StatisticExport.this.columnNumberInPlausiTab == 6) {
                        ps.setString(6, error.getFehlerArtFuerDBExport());
                    }
                }

                public int getBatchSize() {
                    return errors.size();
                }
            });
        }
        catch (DataAccessException e) {
            logger.error("Couldn't execute insert-Statment in astat_plausi", (Throwable)e);
        }
    }

    public void readPlausiFromDb(String plausiKategorie, OutputStream out) {
        Object sSelect = "";
        if (!"astat_plausi".equals(this.plausiTable)) {
            sSelect = "SELECT key AS " + this.distributionType.getKey() + ", fehlerid, fehlertext, korrekturhinweis, einzelfelder FROM " + this.plausiTable;
        } else {
            sSelect = "SELECT key AS " + this.distributionType.getKey() + ", fehlerid, fehlertext, korrekturhinweis, einzelfelder, kategorie FROM " + this.plausiTable;
            if (PLAUSI_MUSS_MASK.equals(plausiKategorie)) {
                sSelect = (String)sSelect + " WHERE kategorie = '";
                sSelect = (String)sSelect + PLAUSI_MUSS_DB;
                sSelect = (String)sSelect + "'";
            }
        }
        try {
            SqlRowSet plausiRowSet = this.jt.queryForRowSet((String)sSelect);
            ResultSet plausiRs = ((ResultSetWrappingSqlRowSet)plausiRowSet).getResultSet();
            CSVPrinter csvPrinter = CSVFormat.EXCEL.withDelimiter(';').withHeader(plausiRs).print((Appendable)new OutputStreamWriter(out));
            csvPrinter.printRecords(plausiRs);
            csvPrinter.close(true);
        }
        catch (DataAccessException e) {
            logger.error("Couldn't execute select-Statment in astat_plausi for output stream", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Couldn't create OutputStreamWriter", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("Problem reading Plausis", (Throwable)e);
        }
    }

    public void setEndIndex(int index) {
        this.endIndex = index;
    }

    public void setStartIndex(int index) {
        this.startIndex = index;
    }

    public List<StatisticsBase> getData(int maxRows) {
        this.doQuery();
        ArrayList<StatisticsBase> ses = new ArrayList<StatisticsBase>();
        for (int rows = 0; this.getNextRow() && (maxRows == -1 || rows < maxRows); ++rows) {
            StatisticsBase s = this.distributionType.getStatisticsRecord();
            s.setData(this.currentRow);
            ses.add(s);
        }
        return ses;
    }

    public List<StatisticsBase> getData() {
        return this.getData(-1);
    }

    public List<SuperxPlausiFehler> plausi(PlausiKontext ctx, SatzInterface record, PlausiInterface plausi, String maskPlausi) {
        ArrayList<SuperxPlausiFehler> plausiErrors = new ArrayList<SuperxPlausiFehler>();
        ctx.init();
        try {
            plausi.gesamtPlausi(record, ctx);
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage());
        }
        int res = ctx.getPlausiErgebnis();
        String plausiErgebnis = "Ergebnis der AStat Validierung: " + (res == 0 ? "Keine Fehler" : (res == 1 ? "Muss-Fehler oder fehlende Merkmale" : (res == 2 ? "Kann-Fehler" : (res == 3 ? "Automatische Korrektur oder L\u00e4ngen Fehler" : (res == 4 ? "Fehler Wertebereich" : "Unbekanntes Ergebnis")))));
        logger.debug(plausiErgebnis);
        for (int i = 0; i < ctx.getAnzahlFehler(); ++i) {
            String key;
            SuperxPlausiFehler sxPlFehler;
            PlausiFehler fehler = ctx.getFehler(i);
            if (maskPlausi.equals(PLAUSI_MUSS_MASK)) {
                if (fehler.getFehlerArt() != 1) continue;
                sxPlFehler = new SuperxPlausiFehler(fehler);
                key = ((StatisticsBase)record).getString(this.distributionType.getKey());
                if (key == null) {
                    logger.error("{} key ({}) null not allowed: {}. Setting to \"key missing!\"", new Object[]{this.distributionType, this.distributionType.getKey(), sxPlFehler.getFehlerId()});
                    key = "key missing!";
                }
                sxPlFehler.setKey(key);
                plausiErrors.add(sxPlFehler);
                continue;
            }
            if (maskPlausi.equals(PLAUSI_KANN_MUSS_MASK)) {
                if (fehler.getFehlerArt() != 1 && fehler.getFehlerArt() != 2) continue;
                sxPlFehler = new SuperxPlausiFehler(fehler);
                key = ((StatisticsBase)record).getString(this.distributionType.getKey());
                if (key == null) {
                    logger.error("{} key ({}) null not allowed: {}. Setting to \"key missing!\"", new Object[]{this.distributionType, this.distributionType.getKey(), sxPlFehler.getFehlerId()});
                    key = "key missing!";
                }
                sxPlFehler.setKey(key);
                plausiErrors.add(sxPlFehler);
                continue;
            }
            logger.debug("Plausibilisierung in der Maske enth\u00e4lt ung\u00fcltigen Wert: {}", (Object)maskPlausi);
        }
        return plausiErrors;
    }

    public void close() {
    }

    public DataProvider getDataProvider(StructureDescriptor structure) {
        String path = AbstractDescriptor.getCustomNamesPathString((Descriptor)structure);
        if (path.equals("Nachricht[1]")) {
            return null;
        }
        logger.debug("getDataProvider: {}", (Object)path);
        if (structure.getType() == 2) {
            int index;
            logger.debug("RECORD {}", (Object)structure.getIndex());
            int n = index = structure.getIndex() != null ? structure.getIndex() : 0;
            if (this.startIndex != -1) {
                index += this.startIndex;
            }
            if (index > this.currentIndex && !this.getNextRow()) {
                return null;
            }
        }
        return this;
    }

    public String getFieldValue(FieldDescriptor field) {
        String path = AbstractDescriptor.getCustomNamesPathString((Descriptor)field);
        logger.debug("getFieldValue: {}", (Object)path);
        if (field.getType() == 2) {
            logger.debug("Type: Metadata Value: {}", (Object)this.metaData.getProperty(path));
            return this.metaData.getProperty(path);
        }
        int endPos = path.lastIndexOf(46);
        String parentPath = "";
        if (endPos > 0) {
            parentPath = path.substring(0, endPos);
        }
        String fieldName = path.substring(endPos + 1);
        fieldName = this.distributionType.translateFieldNameToDatabaseField(fieldName);
        return this.getFromRow(parentPath, fieldName);
    }

    public SurveyResource getSurveyResource(String statId, String reportingPeriod, String collector) throws NoResourceFoundException {
        logger.debug("statId: {}", (Object)statId);
        logger.debug("reportingPeriod: {}", (Object)reportingPeriod);
        logger.debug("collector: {}", (Object)collector);
        String sdfDir = this.configDir + File.separator + "sdf";
        DatmlSdfSource res = null;
        try {
            File[] files = FileUtils.listFiles((File)new File(sdfDir), (IOFileFilter)new RegexFileFilter(statId + "\\d+\\.xml"), null).toArray(new File[0]);
            if (files.length == 0) {
                throw new IOException("No SDF file found in " + sdfDir);
            }
            Arrays.sort(files, NameFileComparator.NAME_REVERSE);
            File sdfFile = files[0];
            String resourceId = "1" + sdfFile.getName().substring(0, sdfFile.getName().length() - 4);
            ByteSource bs = Files.asByteSource((File)sdfFile);
            res = new DatmlSdfSource(resourceId, bs.read());
            this.meta = res.getErhebungsbeschreibung();
            Iterator it = this.meta.getMerkmale();
            this.merkmale = new HashMap<String, MetaSDFMerkmal>();
            while (it.hasNext()) {
                MetaSDFMerkmal m = (MetaSDFMerkmal)it.next();
                logger.debug("Merkmal: {}", (Object)m.getName());
                this.merkmale.put(m.getName(), m);
            }
        }
        catch (IOException e) {
            logger.error("Problem reading sdf", (Throwable)e);
        }
        catch (ResourceException e) {
            logger.error("Problem getting MetaErhebungsBeschreibung", (Throwable)e);
        }
        return res;
    }

    private String getFromRow(String path, String fieldName) {
        int endPos = path.lastIndexOf(46);
        String satz = path.substring(endPos + 1);
        int index = Integer.parseInt(CharMatcher.inRange((char)'0', (char)'9').retainFrom((CharSequence)satz));
        if (this.startIndex != -1) {
            index += this.startIndex;
        }
        if (index > this.currentIndex && !this.getNextRow()) {
            logger.debug("End of data reached at line {}", (Object)index);
            if (Integer.valueOf(index) == Integer.valueOf(0)) {
                throw new RuntimeException("Keine Daten f\u00fcr den Export vorhanden");
            }
            return null;
        }
        logger.debug("Getting data line {} field {}", (Object)index, (Object)fieldName);
        return this.currentRow.get(fieldName);
    }

    private boolean getNextRow() {
        if (this.rs == null || this.rs.isLast() || this.endIndex != -1 && this.currentIndex == this.endIndex) {
            logger.debug("END OF DATA for index " + this.currentIndex);
            return false;
        }
        HashMap<String, String> row = new HashMap<String, String>();
        if (this.rs.next()) {
            for (String columnName : this.columnNames) {
                String value = this.rs.getString(columnName);
                row.put(columnName.trim(), value);
            }
            this.currentRow = row;
            ++this.currentIndex;
            logger.debug("DATA LINE #" + this.currentIndex);
            return true;
        }
        this.currentRow = null;
        return false;
    }

    private String getConfigDir() {
        return this.configDir;
    }

    private Properties getHochschulProperties() {
        Properties hsProperties = new Properties();
        Hochschulinfo hsInfo = (Hochschulinfo)this.jt.queryForObject("SELECT * FROM hochschulinfo", (RowMapper)new HochschulinfoMapper());
        hsInfo.setMelderName(this.melderName);
        hsInfo.setMelderVorname(this.melderVorname);
        ArrayList<String> propertyPrefixes = new ArrayList<String>(Arrays.asList("Absender", "Absender.Kontakt", "Absender.Korrektur", "Absender.Korrektur.Kontakt", "Nachricht[0].Berichtspflichtiger", "Nachricht[0].Berichtspflichtiger.Kontakt", "Nachricht[0].Berichtspflichtiger.Korrektur", "Nachricht[0].Berichtspflichtiger.Korrektur.Kontakt"));
        for (String prefix : propertyPrefixes) {
            hsProperties.setProperty(prefix + ".Organisation.Name", hsInfo.getName());
            hsProperties.setProperty(prefix + ".Adresse.Strasse", hsInfo.getStrasse());
            hsProperties.setProperty(prefix + ".Adresse.Hausnummer", hsInfo.getStrasseNr());
            hsProperties.setProperty(prefix + ".Adresse.Postleitzahl", hsInfo.getPlz());
            hsProperties.setProperty(prefix + ".Adresse.Ort", hsInfo.getOrt());
            hsProperties.setProperty(prefix + ".Person.Nachname", hsInfo.getMelderName());
            hsProperties.setProperty(prefix + ".Person.Vorname", hsInfo.getMelderVorname());
        }
        if (this.kennung != null) {
            hsProperties.setProperty("Absender.Kennung", this.kennung);
        }
        return hsProperties;
    }

    public void setKennung(String kennung) {
        this.kennung = kennung;
    }

    public static enum ExportFormat {
        XML("text/xml", "text/xml", "xml"),
        CSV("text/csv", "text/comma-separated-values", "csv"),
        TXT("text/plain", "text/plain", "txt"),
        ZIP("application/zip", "application/zip", "zip"),
        UNKNOWN("", "", "");

        private String mime;
        private String content;
        private String extension;

        private ExportFormat(String mime, String content, String extension) {
            this.mime = mime;
            this.content = content;
            this.extension = extension;
        }

        public String getMimeType() {
            return this.mime;
        }

        public String getContentType() {
            return this.content;
        }

        public String getExtension() {
            return this.extension;
        }

        public static ExportFormat getForMimeType(String mimeType) {
            if (mimeType.endsWith(" kurz")) {
                mimeType = mimeType.substring(0, mimeType.length() - 5);
            }
            if (CSV.getMimeType().equals(mimeType)) {
                return CSV;
            }
            if (XML.getMimeType().equals(mimeType)) {
                return XML;
            }
            if (TXT.getMimeType().equals(mimeType)) {
                return TXT;
            }
            if (ZIP.getMimeType().equals(mimeType)) {
                return ZIP;
            }
            return UNKNOWN;
        }
    }
}

