/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.service;

import de.superx.job.ContainerNode;
import de.superx.rest.model.job.Component;
import de.superx.spring.service.DbJobDescriptionAdapter;
import de.superx.spring.service.EntityJobDescriptionSource;
import de.superx.spring.service.JobDescriptionSource;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="jobAdapter")
public class JobAdapter
implements JobDescriptionSource {
    @Autowired
    DbJobDescriptionAdapter dbJobDescriptionAdapter;
    @Autowired
    EntityJobDescriptionSource entityJobDescriptionSource;
    static Logger logger = Logger.getLogger(JobAdapter.class);

    @Override
    public ContainerNode getUnloadJob(String componentAbbreviation) {
        return this.getJobPreferringDatabase(componentAbbreviation, ContainerNode.JobType.unload);
    }

    @Override
    public ContainerNode getLoadAndTransformJob(String componentAbbreviation) {
        return this.getJobPreferringDatabase(componentAbbreviation, ContainerNode.JobType.load_transform);
    }

    @Override
    public ContainerNode getCompleteJob(String componentAbbreviation) {
        return this.getJobPreferringDatabase(componentAbbreviation, ContainerNode.JobType.complete);
    }

    @Override
    public ContainerNode getInstallUpgradeJob(String componentAbbreviation) {
        return this.getJobPreferringDatabase(componentAbbreviation, ContainerNode.JobType.install_upgrade);
    }

    @Override
    public ContainerNode getUninstallJob(String componentAbbreviation) {
        return this.getJobPreferringDatabase(componentAbbreviation, ContainerNode.JobType.uninstall);
    }

    @Override
    public List<ContainerNode> readInstallJobs(List<String> components) {
        return JobAdapter.mergeJobsPreferringDatabase(this.dbJobDescriptionAdapter.readInstallJobs(components), this.entityJobDescriptionSource.readInstallJobs(components));
    }

    @Override
    public List<ContainerNode> readJobs() {
        return JobAdapter.mergeJobsPreferringDatabase(this.dbJobDescriptionAdapter.readJobs(), this.entityJobDescriptionSource.readJobs());
    }

    @Override
    public List<ContainerNode> getJobsForComponent(String componentAbbreviation) {
        return JobAdapter.mergeJobsPreferringDatabase(this.dbJobDescriptionAdapter.getJobsForComponent(componentAbbreviation), this.entityJobDescriptionSource.getJobsForComponent(componentAbbreviation));
    }

    @Override
    public List<ContainerNode> getSpecialJobs(String componentAbbreviation) {
        return JobAdapter.mergeJobsPreferringDatabase(this.dbJobDescriptionAdapter.getSpecialJobs(componentAbbreviation), this.entityJobDescriptionSource.getSpecialJobs(componentAbbreviation));
    }

    @Override
    public List<ContainerNode> getSpecialJobsOverview(String abbreviation) {
        return JobAdapter.mergeJobsPreferringDatabase(this.dbJobDescriptionAdapter.getSpecialJobsOverview(abbreviation), this.entityJobDescriptionSource.getSpecialJobsOverview(abbreviation));
    }

    @Override
    public ContainerNode getJobById(String searchId) {
        ContainerNode node = this.dbJobDescriptionAdapter.getJobById(searchId);
        if (node != null) {
            return node;
        }
        return this.entityJobDescriptionSource.getJobById(searchId);
    }

    @Override
    public Component getComponentWithLoadAndUnloadDetails(String abbreviation) {
        Component component = this.dbJobDescriptionAdapter.getComponentWithLoadAndUnloadDetails(abbreviation);
        if (component != null) {
            return component;
        }
        return this.entityJobDescriptionSource.getComponentWithLoadAndUnloadDetails(abbreviation);
    }

    public ContainerNode getJobPreferringDatabase(String componentAbbreviation, ContainerNode.JobType type) {
        String jobName = type.createName(componentAbbreviation);
        ContainerNode node = null;
        try {
            node = JobAdapter.getContainerNodeByType(type, this.dbJobDescriptionAdapter, componentAbbreviation);
            if (node != null) {
                logger.info((Object)("Job found '" + jobName + "' in Database."));
                return node;
            }
            logger.info((Object)("No Job '" + jobName + "' in Database."));
        }
        catch (Exception e) {
            logger.error((Object)("ERROR: getting Job '" + jobName + "' from Database."));
            logger.error((Object)("ERROR: using filesystem as fallback for Job '" + jobName + "'"), (Throwable)e);
        }
        try {
            node = JobAdapter.getContainerNodeByType(type, this.entityJobDescriptionSource, componentAbbreviation);
            if (node == null) {
                throw new RuntimeException("No Job found '" + jobName + "' in Filesystem.");
            }
        }
        catch (Exception e) {
            logger.error((Object)("ERROR: getting Job '" + jobName + "' from Filesystem."));
            throw e;
        }
        return node;
    }

    public static ContainerNode getContainerNodeByType(ContainerNode.JobType type, JobDescriptionSource source, String componentAbbreviation) {
        switch (type) {
            case unload: {
                return source.getUnloadJob(componentAbbreviation);
            }
            case load_transform: {
                return source.getLoadAndTransformJob(componentAbbreviation);
            }
            case complete: {
                return source.getCompleteJob(componentAbbreviation);
            }
            case install_upgrade: {
                return source.getInstallUpgradeJob(componentAbbreviation);
            }
            case uninstall: {
                return source.getUninstallJob(componentAbbreviation);
            }
            case unknown: {
                throw new RuntimeException("Unknown JobType for job " + type.getJobTypeId() + " and component " + componentAbbreviation);
            }
        }
        return null;
    }

    public static List<ContainerNode> mergeJobsPreferringDatabase(List<ContainerNode> jobsDatabase, List<ContainerNode> jobsFilesystem) {
        ArrayList<ContainerNode> result = new ArrayList<ContainerNode>(jobsDatabase);
        for (ContainerNode jobFs : jobsFilesystem) {
            boolean isJobInDatabase = false;
            for (ContainerNode jobDb : jobsDatabase) {
                if (!jobDb.name.equals(jobFs.name)) continue;
                isJobInDatabase = true;
                break;
            }
            if (isJobInDatabase) continue;
            result.add(jobFs);
        }
        return result;
    }
}

