/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.service;

import de.superx.job.ActionNode;
import de.superx.job.ContainerNode;
import de.superx.rest.model.job.Component;
import de.superx.spring.service.JobDescriptionSource;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dbJobDescriptionAdapter")
public class DbJobDescriptionAdapter
implements InitializingBean,
JobDescriptionSource {
    static Logger logger = LoggerFactory.getLogger(DbJobDescriptionAdapter.class);
    private static final String JOB_CREATE = "INSERT INTO etl_job (uniquename, caption, systeminfo_id, custom_job) VALUES (?, ?, ?, ?)";
    private static final PreparedStatementCreatorFactory JOB_CREATE_FACTORY = new PreparedStatementCreatorFactory("INSERT INTO etl_job (uniquename, caption, systeminfo_id, custom_job) VALUES (?, ?, ?, ?)", new int[]{12, 12, 4, 4});
    private static final String STEP_RELATION_CREATE = "INSERT INTO etl_step_relation (step_id, job_id, parent_step_id, sortnr, custom_step) VALUES (?, ?, ?, ?, ?)";
    private static final PreparedStatementCreatorFactory STEP_RELATION_CREATE_FACTORY = new PreparedStatementCreatorFactory("INSERT INTO etl_step_relation (step_id, job_id, parent_step_id, sortnr, custom_step) VALUES (?, ?, ?, ?, ?)", new int[]{4, 4, 4, 4, 4});
    private static final String STEP_CREATE = "INSERT INTO etl_step (uniquename, caption, systeminfo_id, step_type_id, custom_step) VALUES (?, ?, ?, ?, ?)";
    private static final PreparedStatementCreatorFactory STEP_CREATE_FACTORY = new PreparedStatementCreatorFactory("INSERT INTO etl_step (uniquename, caption, systeminfo_id, step_type_id, custom_step) VALUES (?, ?, ?, ?, ?)", new int[]{12, 12, 4, 4, 4});
    private static final String PROPERTY_CREATE = "INSERT INTO etl_step_property (etl_step_id, prop_name, prop_value) VALUES (?, ?, ?)";
    private static final PreparedStatementCreatorFactory PROPERTY_CREATE_FACTORY = new PreparedStatementCreatorFactory("INSERT INTO etl_step_property (etl_step_id, prop_name, prop_value) VALUES (?, ?, ?)", new int[]{4, 12, 12});
    private static final String JOBS_READ = "SELECT tid, uniquename, caption, systeminfo_id, custom_job FROM etl_job";
    private static final String JOBS_READ_UNIQUENAME = "SELECT tid, uniquename, caption, systeminfo_id, custom_job FROM etl_job WHERE uniquename like ?";
    private static final String JOB_READ_TID = "SELECT tid, uniquename, caption, systeminfo_id, custom_job FROM etl_job WHERE tid=?";
    private static final String JOBS_READ_SYSTEMINFO_ID = "SELECT tid, uniquename, caption, systeminfo_id, custom_job FROM etl_job WHERE systeminfo_id=? ORDER BY caption";
    private static final String JOBS_READ_UNIQUENAME_SYSTEMINFO_ID = "SELECT tid, uniquename, caption, systeminfo_id, custom_job FROM etl_job WHERE systeminfo_id=? AND uniquename like ?";
    private static final String STEP_READ = "SELECT uniquename, caption, systeminfo_id, step_type_id FROM etl_step WHERE tid=?";
    private static final String CHILDREN_JOB_READ = "SELECT step_id, force_continue, step_active, sortnr, custom_step FROM etl_step_relation WHERE parent_step_id IS NULL AND job_id=? ORDER BY sortnr";
    private static final String CHILDREN_CONTAINER_READ = "SELECT step_id, force_continue, step_active, sortnr, custom_step FROM etl_step_relation WHERE parent_step_id=? ORDER by sortnr";
    private static final String STEP_PROPERTIES_READ = "SELECT prop_name, prop_value FROM etl_step_property WHERE etl_step_id=?";
    private JdbcTemplate jt;
    @Autowired
    DataSource dataSource;

    public void afterPropertiesSet() throws Exception {
        this.jt = new JdbcTemplate(this.dataSource);
    }

    @Transactional
    public int writeToDb(ContainerNode root) {
        if (!this.etlTablesExist()) {
            return -1;
        }
        if (root == null) {
            return -2;
        }
        Integer jobId = this.writeJob(root);
        if (root.size() > 0) {
            List<ActionNode> children = root.getActions();
            int sortNr = 0;
            for (ActionNode action : children) {
                Integer sortNummer = sortNr;
                this.writeStep(action, jobId, null, sortNummer);
                ++sortNr;
            }
        }
        return jobId;
    }

    private boolean etlTablesExist() {
        boolean exist = false;
        try (Connection con = this.dataSource.getConnection();){
            DatabaseMetaData databaseMetaData = con.getMetaData();
            try (ResultSet resultSet = databaseMetaData.getTables(null, null, "etl_job", new String[]{"TABLE"});){
                if (resultSet.next()) {
                    exist = true;
                }
            }
        }
        catch (SQLException e) {
            logger.error("Could not check if table etl_job exists", (Throwable)e);
        }
        return exist;
    }

    private Integer writeJob(ContainerNode root) {
        SqlRowSet srs = this.jt.queryForRowSet(JOBS_READ_UNIQUENAME, new Object[]{root.id});
        boolean alreadyExists = srs.next();
        if (alreadyExists) {
            boolean custom = srs.getBoolean("custom_job");
            int tid = srs.getInt("tid");
            if (!custom) {
                logger.warn("Job already exists and is not custom: " + tid + ". Will delete it and read it again!");
                this.deleteJob(tid);
            } else {
                String error = "Job is custom and already exists: " + tid;
                logger.error(error);
                throw new RuntimeException(error);
            }
        }
        GeneratedKeyHolder jobIdHolder = new GeneratedKeyHolder();
        logger.info("Name: " + root.name + " Id: " + root.id);
        PreparedStatementCreator jobCreator = JOB_CREATE_FACTORY.newPreparedStatementCreator(List.of(root.id, root.name, root.systemInfoId, root.custom));
        this.jt.update(jobCreator, (KeyHolder)jobIdHolder);
        Map keys = jobIdHolder.getKeys();
        return (Integer)keys.get("tid");
    }

    private void deleteJob(int tid) {
        this.jt.execute("DELETE FROM etl_step_property WHERE etl_step_id IN (SELECT step_id FROM etl_step_relation WHERE job_id=" + tid + ")");
        this.jt.execute("DELETE FROM etl_step WHERE tid IN (SELECT step_id FROM etl_step_relation WHERE job_id=" + tid + ")");
        this.jt.execute("DELETE FROM etl_step_relation WHERE job_id=" + tid);
        this.jt.execute("DELETE FROM etl_job WHERE tid=" + tid);
    }

    private void writeChildren(List<ActionNode> children, Integer parentStepId, Integer parentJobId) {
        int sortNr = 0;
        for (ActionNode action : children) {
            Integer sortNummer = sortNr;
            this.writeStep(action, parentJobId, parentStepId, sortNummer);
            ++sortNr;
        }
    }

    private void writeStep(ActionNode node, Integer parentJobId, Integer parentStepId, Integer sortNr) {
        ArrayList<Object> params = new ArrayList<Object>();
        HashMap<String, String> runtimeProperties = new HashMap<String, String>();
        params.add(node.id);
        params.add(node.name);
        params.add(node.systemInfoId);
        params.add(node.type.getStepTypeId());
        params.add(node.custom);
        GeneratedKeyHolder stepIdHolder = new GeneratedKeyHolder();
        PreparedStatementCreator stepCreator = STEP_CREATE_FACTORY.newPreparedStatementCreator(params);
        try {
            this.jt.update(stepCreator, (KeyHolder)stepIdHolder);
        }
        catch (DuplicateKeyException dke) {
            String error = "Duplicate key for uniquename=" + node.id + " systeminfo_id=" + node.systemInfoId;
            logger.error(error);
            return;
        }
        Map keys = stepIdHolder.getKeys();
        Integer stepId = (Integer)keys.get("tid");
        if (node instanceof ContainerNode) {
            this.writeChildren(((ContainerNode)node).getActions(), stepId, parentJobId);
        } else {
            runtimeProperties.putAll(DbJobDescriptionAdapter.getRuntimeProperties(node));
        }
        ArrayList<Integer> relationParams = new ArrayList<Integer>();
        relationParams.add(stepId);
        relationParams.add(parentJobId);
        relationParams.add(parentStepId);
        relationParams.add(sortNr);
        relationParams.add(node.custom);
        PreparedStatementCreator relationCreator = STEP_RELATION_CREATE_FACTORY.newPreparedStatementCreator(relationParams);
        this.jt.update(relationCreator);
        for (Map.Entry property : runtimeProperties.entrySet()) {
            PreparedStatementCreator propertyCreator = PROPERTY_CREATE_FACTORY.newPreparedStatementCreator(List.of(stepId, (Serializable)property.getKey(), (Serializable)property.getValue()));
            this.jt.update(propertyCreator);
        }
    }

    private static Map<String, String> getRuntimeProperties(ActionNode node) {
        Field[] fields;
        if (node instanceof ContainerNode) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Field field : fields = node.getClass().getFields()) {
            String key = field.getName();
            if (key.equals("name") || key.equals("id") || key.equals("type")) continue;
            try {
                Object obj = field.get(node);
                String value = obj != null ? obj.toString() : "";
                properties.put(key, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                logger.error("Cannot read field " + key + " on node " + String.valueOf((Object)node.type));
                throw new RuntimeException(e);
            }
        }
        return properties;
    }

    @Override
    public ContainerNode getJobById(final String id) {
        ContainerNode jobRoot = (ContainerNode)this.jt.query(JOBS_READ_UNIQUENAME, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, id);
            }
        }, (ResultSetExtractor)new ResultSetExtractor<ContainerNode>(){

            public ContainerNode extractData(ResultSet rs) throws SQLException, DataAccessException {
                ContainerNode result = null;
                if (rs.next()) {
                    result = DbJobDescriptionAdapter.createContainerNode(rs.getString("caption"), rs.getString("uniquename"), rs.getInt("systeminfo_id"));
                    result.custom = rs.getInt("custom_job");
                    result.tid = rs.getInt("tid");
                }
                return result;
            }
        });
        if (jobRoot == null) {
            return null;
        }
        List<ActionNode> children = this.readChildrenOfJob(jobRoot.tid);
        jobRoot.addAll(children);
        return jobRoot;
    }

    @Override
    public ContainerNode getInstallUpgradeJob(String component) {
        return this.getJobById(ContainerNode.JobType.install_upgrade.createName(component));
    }

    @Override
    public ContainerNode getUninstallJob(String component) {
        return this.getJobById(ContainerNode.JobType.uninstall.createName(component));
    }

    @Override
    public ContainerNode getUnloadJob(String componentAbbreviation) {
        return this.getJobById(ContainerNode.JobType.unload.createName(componentAbbreviation));
    }

    @Override
    public ContainerNode getLoadAndTransformJob(String componentAbbreviation) {
        return this.getJobById(ContainerNode.JobType.load_transform.createName(componentAbbreviation));
    }

    @Override
    public ContainerNode getCompleteJob(String componentAbbreviation) {
        return this.getJobById(ContainerNode.JobType.complete.createName(componentAbbreviation));
    }

    @Override
    public List<ContainerNode> readJobs() {
        return this.jt.query(JOBS_READ, (RowMapper)new RowMapper<ContainerNode>(){

            public ContainerNode mapRow(ResultSet rs, int rowNum) throws SQLException {
                ContainerNode node = DbJobDescriptionAdapter.createContainerNode(rs.getString("caption"), rs.getString("uniquename"), rs.getInt("systeminfo_id"));
                node.tid = rs.getInt("tid");
                return node;
            }
        });
    }

    @Override
    public List<ContainerNode> readInstallJobs(List<String> components) {
        logger.debug("Reading install jobs from db");
        List<ContainerNode> allJobs = this.readJobs();
        ArrayList<ContainerNode> installJobs = new ArrayList<ContainerNode>();
        allJobs.forEach(n -> {
            if (n.id.contains("_install_upgrade")) {
                installJobs.add((ContainerNode)n);
            }
        });
        logger.debug("Count of jobs: " + installJobs.size());
        return installJobs;
    }

    public List<ContainerNode> readJobsForComponent(String abbreviation) {
        return this.jt.query(JOBS_READ_UNIQUENAME, new Object[]{abbreviation + "%"}, (RowMapper)new RowMapper<ContainerNode>(){

            public ContainerNode mapRow(ResultSet rs, int rowNum) throws SQLException {
                ContainerNode node = DbJobDescriptionAdapter.createContainerNode(rs.getString("caption"), rs.getString("uniquename"), rs.getInt("systeminfo_id"));
                node.tid = rs.getInt("tid");
                return node;
            }
        });
    }

    public List<ContainerNode> readSpecialJobs(int systemInfoId) {
        return this.jt.query(JOBS_READ_UNIQUENAME_SYSTEMINFO_ID, new Object[]{systemInfoId, "%" + ContainerNode.JobType.special.getNamePattern()}, (RowMapper)new RowMapper<ContainerNode>(){

            public ContainerNode mapRow(ResultSet rs, int rowNum) throws SQLException {
                ContainerNode node = DbJobDescriptionAdapter.createContainerNode(rs.getString("caption"), rs.getString("uniquename"), rs.getInt("systeminfo_id"));
                node.tid = rs.getInt("tid");
                return node;
            }
        });
    }

    @Override
    public List<ContainerNode> getSpecialJobs(String componentAbbreviation) {
        String name = componentAbbreviation + "%" + ContainerNode.JobType.special.getNamePattern();
        return this.jt.query(JOBS_READ_UNIQUENAME, new Object[]{name}, (RowMapper)new RowMapper<ContainerNode>(){

            public ContainerNode mapRow(ResultSet rs, int rowNum) throws SQLException {
                ContainerNode node = DbJobDescriptionAdapter.createContainerNode(rs.getString("caption"), rs.getString("uniquename"), rs.getInt("systeminfo_id"));
                node.tid = rs.getInt("tid");
                return node;
            }
        });
    }

    public boolean tryAcquireDbLockJobsLoading() {
        return this.tryAcquireDbLock(43);
    }

    public void releaseDbLockJobsLoading() {
        this.releaseDbLock(43);
    }

    public boolean tryAcquireDbLockJobExecution() {
        return this.tryAcquireDbLock(42);
    }

    public void releaseDbLockJobExecution() {
        this.releaseDbLock(42);
    }

    private boolean tryAcquireDbLock(int lockNr) {
        return (Boolean)this.jt.queryForObject("SELECT pg_try_advisory_lock(" + lockNr + ")", Boolean.class);
    }

    private void releaseDbLock(int lockNr) {
        this.jt.execute("SELECT pg_advisory_unlock(" + lockNr + ")");
    }

    private List<ActionNode> readChildrenOfJob(Integer tid) {
        ArrayList<ActionNode> result = new ArrayList<ActionNode>();
        List children = this.jt.queryForList(CHILDREN_JOB_READ, new Object[]{tid});
        for (Map child : children) {
            result.add(this.readStep(child));
        }
        return result;
    }

    private List<ActionNode> readChildrenOfContainer(Integer tid) {
        ArrayList<ActionNode> result = new ArrayList<ActionNode>();
        List children = this.jt.queryForList(CHILDREN_CONTAINER_READ, new Object[]{tid});
        for (Map child : children) {
            result.add(this.readStep(child));
        }
        return result;
    }

    private ActionNode readStep(Map<String, Object> child) {
        Map step = this.jt.queryForMap(STEP_READ, new Object[]{child.get("step_id")});
        int step_type = (Integer)step.get("step_type_id");
        ActionNode.ActionType actionType = ActionNode.ActionType.getActionTypeById(step_type);
        Class<? extends ActionNode> actionClass = actionType.getActionClass();
        ActionNode result = null;
        List fields = Arrays.asList(actionClass.getDeclaredFields()).stream().map(field -> field.getName()).collect(Collectors.toList());
        try {
            Constructor<? extends ActionNode> constructor = actionClass.getConstructor(new Class[0]);
            result = constructor.newInstance(new Object[0]);
            result.tid = (Integer)child.get("step_id");
            result.name = (String)step.get("caption");
            result.id = (String)step.get("uniquename");
            result.systemInfoId = (Integer)step.get("systeminfo_id");
            Number active = (Number)child.get("step_active");
            result.active = active.intValue() != 0;
            Number custom = (Number)child.get("custom_step");
            result.custom = (Integer)custom;
            result.type = actionType;
            if (result instanceof ContainerNode) {
                ((ContainerNode)result).addAll(this.readChildrenOfContainer(result.tid));
            } else {
                List properties = this.jt.queryForList(STEP_PROPERTIES_READ, new Object[]{child.get("step_id")});
                for (Map keyValuePair : properties) {
                    String key = (String)keyValuePair.get("prop_name");
                    String value = (String)keyValuePair.get("prop_value");
                    if (!fields.contains(key)) continue;
                    Field field2 = actionClass.getDeclaredField(key);
                    String type = field2.getType().getSimpleName();
                    if (value == null || value.isEmpty()) {
                        field2.set(result, null);
                        continue;
                    }
                    if ("String".equals(type)) {
                        field2.set(result, value);
                        continue;
                    }
                    if ("boolean".equals(type)) {
                        field2.set(result, Boolean.valueOf(value));
                        continue;
                    }
                    if ("Integer".equals(type)) {
                        field2.set(result, Integer.valueOf(value));
                        continue;
                    }
                    throw new RuntimeException("Unknown type: " + type);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public void deleteAllNonCustomJobs() {
        this.jt.execute("DELETE FROM etl_job WHERE custom_job=0");
        this.jt.execute("DELETE FROM etl_step_property WHERE etl_step_id IN (SELECT tid FROM etl_step WHERE custom_step=0)");
        this.jt.execute("DELETE FROM etl_step WHERE custom_step=0");
    }

    @Override
    public Component getComponentWithLoadAndUnloadDetails(final String abbreviation) {
        String sql = "SELECT etl_unl.tid IS NOT NULL AS unload,       etl_load.tid IS NOT NULL AS load  FROM systeminfo  JOIN db_version    ON db_version.systeminfo_id = systeminfo.tid  LEFT JOIN etl_job AS etl_unl    ON etl_unl.uniquename = trim(db_version.his_system) || '_unload'  LEFT JOIN etl_job AS etl_load    ON etl_load.uniquename = trim(db_version.his_system) || '_load_and_transform' WHERE trim(db_version.his_system) like ?";
        Component component = (Component)this.jt.queryForObject(sql, (Object[])new String[]{abbreviation}, (RowMapper)new RowMapper<Component>(){

            public Component mapRow(ResultSet rs, int rowNum) throws SQLException {
                if (rs.next()) {
                    boolean load = rs.getBoolean("load");
                    boolean unload = rs.getBoolean("unload");
                    return new Component(abbreviation, unload, load);
                }
                return null;
            }
        });
        return component;
    }

    @Override
    public List<ContainerNode> getJobsForComponent(String abbreviation) {
        return this.readJobsForComponent(abbreviation);
    }

    @Override
    public List<ContainerNode> getSpecialJobsOverview(String abbreviation) {
        return this.getSpecialJobs(abbreviation);
    }

    private static ContainerNode createContainerNode(String name, String id, Integer systemInfoId) {
        ContainerNode node = new ContainerNode(name, id, systemInfoId);
        node.setJobSource(ContainerNode.JobSource.DB);
        return node;
    }

    static {
        JOB_CREATE_FACTORY.setReturnGeneratedKeys(true);
        STEP_CREATE_FACTORY.setReturnGeneratedKeys(true);
    }
}

