/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.tasklet;

import com.zaxxer.hikari.HikariDataSource;
import de.superx.spring.batch.job.JobUtils;
import de.superx.spring.batch.tasklet.CommonSqlTasklet;
import de.superx.util.SqlStringUtils;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.jdbc.core.JdbcTemplate;

public class ExecuteSqlTasklet
extends CommonSqlTasklet
implements Tasklet,
StepExecutionListener {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private JdbcTemplate jdbcTemplate;
    private String sql;
    private Map<String, String> params = new HashMap<String, String>();
    private boolean continueOnError = true;

    public ExecuteSqlTasklet(String sql, DataSource dataSource) {
        this(sql, dataSource, true);
    }

    public ExecuteSqlTasklet(String sql, DataSource dataSource, boolean continueOnError) {
        this.sql = sql;
        this.dataSource = dataSource;
        this.sqlVarDataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.continueOnError = continueOnError;
    }

    public ExecuteSqlTasklet(String sql, DataSource dataSource, DataSource sqlVarDataSource) {
        this.sql = sql;
        this.dataSource = dataSource;
        this.sqlVarDataSource = sqlVarDataSource != null ? sqlVarDataSource : this.dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
        JobExecution jobExecution = stepExecution.getJobExecution();
        JobParameters jobParameters = jobExecution.getJobParameters();
        Properties jobParamProperties = JobUtils.jobParametersToProperties(jobParameters);
        Set<Map.Entry<Object, Object>> entries = jobParamProperties.entrySet();
        Map unloadParameters = (Map)jobExecution.getExecutionContext().get("UNLOAD_PARAMS");
        if (unloadParameters != null) {
            this.params.putAll(unloadParameters);
        }
        for (Map.Entry<Object, Object> entry : entries) {
            this.params.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        return null;
    }

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        String sqlWithSubstitutions = SqlStringUtils.replaceAllProperties(this.sql, this.params);
        sqlWithSubstitutions = this.checkFreemarker(sqlWithSubstitutions);
        try {
            this.jdbcTemplate.execute(sqlWithSubstitutions);
        }
        catch (Exception e) {
            this.jdbcTemplate.execute("ROLLBACK");
            HikariDataSource hikariDataSource = (HikariDataSource)this.jdbcTemplate.getDataSource();
            Connection con = hikariDataSource.getConnection();
            con.close();
            hikariDataSource.evictConnection(con);
            if (!this.continueOnError) {
                throw e;
            }
            ExitStatus exitStatus = ExitStatus.FAILED;
            String errorMsg = e.getMessage();
            Throwable cause = e.getCause();
            if (cause != null) {
                errorMsg = cause.getMessage();
            } else {
                this.logger.warn("No cause given for exception!");
            }
            exitStatus = exitStatus.addExitDescription(errorMsg.substring(0, errorMsg.length()));
            contribution.setExitStatus(exitStatus);
        }
        this.logger.info(sqlWithSubstitutions);
        return RepeatStatus.FINISHED;
    }
}

