/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest.model;

import de.superx.common.Field;
import de.superx.rest.model.FieldType;
import de.superx.rest.model.Item;
import java.util.ArrayList;
import java.util.List;

public class HisDynamicFieldConfig {
    private static final String DD_KEY_PREFIX = "cs.bia.form.field.";
    public String name;
    public FieldType controlType;
    public String label;
    public String helptext;
    public boolean required = false;
    public Object defaultValue;
    public boolean disabled;
    public String ddKey;
    public int height;
    public boolean showNullItem;
    public List<Item> items = new ArrayList<Item>();
    public String typeAheadUrl;
    public String treeName;
    public String subSearchConfiguration;
    public String subSearchEntity;
    public boolean visibleInSimplifiedForm;
    public List<HisDynamicFieldConfig> children = new ArrayList<HisDynamicFieldConfig>();

    public HisDynamicFieldConfig(Field field, FieldType fieldType) {
        this.name = field.getName();
        this.controlType = fieldType;
        this.label = field.getCaptionShort();
        if (this.label == null || this.label.equals("")) {
            this.label = field.getName();
        }
        this.helptext = field.getCaptionLong();
        this.height = field.getZeilenanzahl();
        this.required = field.isObligatorisch();
        this.defaultValue = field.getDefaultValueKey();
        this.ddKey = DD_KEY_PREFIX + field.getId().toString();
    }

    public HisDynamicFieldConfig(String name, FieldType fieldType) {
        this.name = name;
        this.controlType = fieldType;
    }

    public HisDynamicFieldConfig(String name, String label, FieldType fieldType, Object defaultValue) {
        this.name = name;
        this.label = label;
        this.controlType = fieldType;
        this.defaultValue = defaultValue;
    }

    public HisDynamicFieldConfig(String name, String label, Object defaultValue) {
        this.name = name;
        this.label = label;
        this.defaultValue = defaultValue;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }
}

