/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.baseobjects.IdObject;
import de.superx.common.DBServletException;
import de.superx.common.LocalizedItem;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;

public class TranslationContainer
extends IdObject {
    private static final long serialVersionUID = 1L;
    private Collection localizedItems = new LinkedList();
    public static final Locale defaultLocale = new Locale("de");
    public static final Locale DE_LOCALE = new Locale("de");
    public static final Locale EN_LOCALE = new Locale("en");

    public TranslationContainer(String mandantenID, Object id, String loc, String contentsShort, String contentsLong) throws SQLException, DBServletException {
        super(id);
        this.addLocalizedItem(loc, contentsShort, contentsLong);
    }

    public String getContentsShort(Locale l) {
        String result = "";
        for (LocalizedItem item : this.localizedItems) {
            if (item.getLocale() == null) {
                result = item.getContentsShort();
                continue;
            }
            if (!item.getLocale().getLanguage().equals(l.getLanguage())) continue;
            result = item.getContentsShort();
            break;
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public String getContentsLong(Locale l) {
        String result = "";
        for (LocalizedItem item : this.localizedItems) {
            if (item.getLocale() == null) {
                result = item.getContentsLong();
                continue;
            }
            if (!item.getLocale().getLanguage().equals(l.getLanguage())) continue;
            result = item.getContentsLong();
            break;
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer("id: " + String.valueOf(this.getId()) + " - ");
        for (LocalizedItem item : this.localizedItems) {
            result.append(item.toString() + " ");
        }
        return result.toString();
    }

    public void addLocalizedItem(String loc, String contentsShort, String contentsLong) {
        LocalizedItem item = new LocalizedItem();
        Locale l = null;
        if (loc.equals("de")) {
            l = DE_LOCALE;
        } else if (loc.equals("en")) {
            l = EN_LOCALE;
        } else if (loc != null && !loc.trim().equals("")) {
            l = new Locale(loc);
        }
        item.setLocale(l);
        item.setContentsShort(contentsShort);
        item.setContentsLong(contentsLong);
        this.localizedItems.add(item);
    }
}

