/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.util.EqualsUtil;
import java.io.Serializable;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.h2.util.StringUtils;

public class OrgUnit
implements Serializable,
Comparable<OrgUnit> {
    private static final long serialVersionUID = 1L;
    private static Date defaultStartDate = null;
    private static Date defaultEndDate = null;
    private String apnr = "";
    private String uniquename = "";
    private String lid = "";
    private String name = "";
    private Date gueltig_seit;
    private Date gueltig_bis;

    public OrgUnit(String apnr, String uniquename, String lid, String name, Date gueltig_seit, Date gueltig_bis) {
        if (defaultStartDate == null || defaultEndDate == null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                defaultStartDate = new Date(df.parse("1900-01-01").getTime());
                defaultEndDate = new Date(df.parse("2100-12-31").getTime());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isNullOrEmpty((String)apnr)) {
            throw new IllegalArgumentException("Apnr einer OrgUnit darf nicht leer sein");
        }
        this.apnr = apnr.trim();
        this.uniquename = StringUtils.isNullOrEmpty((String)uniquename) ? "unbekannt" : uniquename;
        this.lid = lid == null ? "unbekannt" : lid;
        this.name = name == null ? "unbekannt" : name;
        this.setGueltig_seit(gueltig_seit);
        this.setGueltig_bis(gueltig_bis);
    }

    public Date getGueltig_seit() {
        return this.gueltig_seit;
    }

    void setGueltig_seit(Date gueltig_seit) {
        this.gueltig_seit = gueltig_seit;
        if (gueltig_seit == null) {
            this.gueltig_seit = defaultStartDate;
        }
    }

    public Date getGueltig_bis() {
        return this.gueltig_bis;
    }

    void setGueltig_bis(Date gueltig_bis) {
        this.gueltig_bis = gueltig_bis;
        if (gueltig_bis == null) {
            this.gueltig_bis = defaultEndDate;
        }
    }

    public String getApnr() {
        return this.apnr;
    }

    public String getUniquename() {
        return this.uniquename;
    }

    public String getLid() {
        return this.lid;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(OrgUnit other) {
        int result = 1;
        if (other instanceof OrgUnit) {
            OrgUnit ou2 = other;
            if (EqualsUtil.areEqual(this.getApnr(), ou2.getApnr()) && EqualsUtil.areEqual(this.getUniquename(), ou2.getUniquename()) && EqualsUtil.areEqual(this.getLid(), ou2.getLid()) && EqualsUtil.areEqual(this.getName(), ou2.getName())) {
                result = 0;
            }
        }
        return result;
    }

    public String toString() {
        return "OrgUnit Apnr:" + this.getApnr();
    }
}

