/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class SimpleSoapClient {
    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Usage path/to/envelope.xml URL /path/to/ouputfile.xml");
            System.exit(-1);
        }
        try {
            SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection soapConnection = soapConnectionFactory.createConnection();
            String url = args[1];
            SOAPMessage sr = SimpleSoapClient.getSoapMessageFromString(SimpleSoapClient.readFile(new File(args[0])));
            sr.getMimeHeaders().addHeader("SOAPAction", "http://sap.com/xi/WebService/soap1.1");
            SOAPMessage soapResponse = soapConnection.call(sr, (Object)url);
            soapResponse.writeTo((OutputStream)System.out);
            StringWriter sw = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(new DOMSource((Node)soapResponse.getSOAPPart()), new StreamResult(sw));
            SimpleSoapClient.writeFile(args, sw);
            soapConnection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeFile(String[] args, StringWriter sw) throws IOException {
        FileWriter fw = new FileWriter(args[2]);
        BufferedWriter bfw = new BufferedWriter(fw);
        bfw.write(sw.toString());
        bfw.close();
        fw.close();
    }

    private static SOAPMessage getSoapMessageFromString(String xml) throws SOAPException, IOException {
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage message = factory.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(xml.getBytes(Charset.forName("UTF-8"))));
        return message;
    }

    private static String readFile(File f) throws IOException {
        String line;
        FileReader fr = new FileReader(f);
        BufferedReader bfr = new BufferedReader(fr);
        StringBuffer result = new StringBuffer();
        while ((line = bfr.readLine()) != null) {
            result.append(line + "\n");
        }
        bfr.close();
        fr.close();
        return result.toString();
    }
}

