/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.rest;

import de.superx.bianalysis.ExcelSheetBuilder;
import de.superx.bianalysis.ReportDefinition;
import de.superx.bianalysis.StoredReport;
import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.models.Dimension;
import de.superx.bianalysis.models.DimensionAttribute;
import de.superx.bianalysis.models.FactTable;
import de.superx.bianalysis.models.Measure;
import de.superx.bianalysis.models.Right;
import de.superx.bianalysis.service.BiAnalysisManager;
import de.superx.bianalysis.service.BiAnalysisRightService;
import de.superx.bianalysis.service.DbMetaAdapter;
import de.superx.common.NotYetImplementedException;
import de.superx.rest.RestControllerBase;
import de.superx.rest.model.Download;
import de.superx.rest.model.Result;
import de.superx.rest.model.ResultType;
import de.superx.rest.model.Row;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/reportwizard"})
public class BiAnalysisApi
extends RestControllerBase {
    static Logger logger = Logger.getLogger(BiAnalysisApi.class);
    @Autowired
    DbMetaAdapter dbAdapter;
    @Autowired
    BiAnalysisRightService rightsService;
    @Autowired
    BiAnalysisManager biAnalysisManager;

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/facttables"})
    public List<FactTable> listFactTables() throws NotYetImplementedException {
        List<Integer> sachgebiete = this.rightsService.getSachgebiete(Right.CREATE_ANALYSIS, Right.VIEW_REPORT);
        List<Identifier> factTables = this.rightsService.getFactTables(Right.CREATE_ANALYSIS, Right.VIEW_REPORT);
        List<FactTable> facts = this.dbAdapter.getFactTables(sachgebiete, factTables);
        return facts;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/dimensions"})
    public List<Dimension> listDimensions(@RequestParam(value="facttable_id") String facttable_id) {
        int sachgebietTid = this.dbAdapter.getSachgebietByFactTableId(facttable_id);
        this.rightsService.checkSachgebiet(sachgebietTid, Right.CREATE_ANALYSIS);
        this.rightsService.checkFactTable(new Identifier(facttable_id), Right.CREATE_ANALYSIS);
        return this.dbAdapter.getDimensionsWithoutHidden(new Identifier(facttable_id));
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/dimensionAttributeValues"})
    public List<String> listAttributeValues(@RequestParam(value="attribute_id") List<Identifier> attribute_id, @RequestParam(value="facts") List<Identifier> facts) {
        List<Integer> tids = this.rightsService.getSachgebiete(Right.CREATE_ANALYSIS);
        List<Identifier> factTables = this.rightsService.getFactTables(Right.CREATE_ANALYSIS);
        List<DimensionAttribute> attributes = this.dbAdapter.getAllowedDimensionAttributes(attribute_id, tids, factTables);
        return this.dbAdapter.getDimensionAttributeValues(attributes, facts);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/dimensionAttributeValuesHierarchy"})
    public List<List<Object>> listAttributeValuesHierarchy(@RequestParam(value="attribute_id") String attribute_id) {
        this.rightsService.checkCreateRights();
        return this.dbAdapter.getDimensionAttributeValuesHierarchy(new Identifier(attribute_id));
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/measures"})
    public List<Measure> listMeasures(@RequestParam(value="facttable_id") String facttable_id) {
        this.rightsService.checkSachgebiet(this.dbAdapter.getSachgebietByFactTableId(facttable_id), Right.CREATE_ANALYSIS, Right.VIEW_REPORT);
        this.rightsService.checkFactTable(new Identifier(facttable_id), Right.CREATE_ANALYSIS, Right.VIEW_REPORT);
        return this.dbAdapter.getMeasures(new Identifier(facttable_id));
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/findReportDefinition"})
    public List<StoredReport> findReportDefinition(@RequestParam(value="title") Optional<String> title, @RequestParam(value="sach") Optional<Integer> sach, @RequestParam(value="facts") Optional<List<String>> facts) {
        List<Integer> allowedSachgebiete = this.rightsService.getSachgebiete(Right.CREATE_ANALYSIS, Right.VIEW_REPORT);
        List<Identifier> allowedFacts = this.rightsService.getFactTables(Right.CREATE_ANALYSIS, Right.VIEW_REPORT);
        ArrayList<StoredReport> result = new ArrayList<StoredReport>();
        for (StoredReport report : this.dbAdapter.findAllStoredReports()) {
            List<Integer> sachgebieteOfReport = this.dbAdapter.getSachgebieteForReport(report.reportDefinition);
            if (!allowedSachgebiete.isEmpty() && !allowedSachgebiete.containsAll(sachgebieteOfReport) || title.isPresent() && !report.name.toLowerCase().contains(title.get().toLowerCase()) || sach.isPresent() && !sachgebieteOfReport.contains(sach.get())) continue;
            if (allowedFacts != null && allowedFacts.size() > 0) {
                boolean isFactAllowed = true;
                for (Identifier reportFactId : report.reportDefinition.factTableIds) {
                    if (allowedFacts.isEmpty() || allowedFacts.contains(reportFactId)) continue;
                    isFactAllowed = false;
                }
                if (!isFactAllowed) continue;
            }
            if (facts.isPresent()) {
                boolean isFactMissing = false;
                for (Identifier reportFactId : report.reportDefinition.factTableIds) {
                    if (facts.get().contains(reportFactId.composedId)) continue;
                    isFactMissing = true;
                    break;
                }
                if (isFactMissing) continue;
            }
            result.add(report);
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/getStoredReport"})
    public StoredReport getStoredReport(@RequestParam(value="id") int id) {
        Optional<StoredReport> storedReportOpt = this.dbAdapter.findById(id);
        if (storedReportOpt.isPresent()) {
            StoredReport storedReport = storedReportOpt.get();
            this.checkCreateOrViewRightForFactTables(storedReport.reportDefinition.factTableIds);
            try {
                storedReport.exportedResult = this.biAnalysisManager.createResult(storedReport.reportDefinition, this.dbAdapter);
            }
            catch (Exception e) {
                logger.error((Object)"Couldn't create report", (Throwable)e);
                e.printStackTrace();
            }
            storedReport.isReadOnly = !this.rightsService.isCreateRight();
            return storedReport;
        }
        return null;
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/report"})
    public Result getReport(@RequestBody ReportDefinition reportDefinition) throws Exception {
        List<Identifier> factTableIds = reportDefinition.factTableIds;
        this.checkCreateRightForFactTables(factTableIds);
        return this.biAnalysisManager.createResult(reportDefinition, this.dbAdapter);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/persistReportDefinition"})
    public int persistReportDefinition(@RequestBody StoredReport storedReport) throws Exception {
        StoredReport.setReportDefinitionJson(storedReport);
        List<Identifier> factTableIds = storedReport.reportDefinition.factTableIds;
        this.checkCreateRightForFactTables(factTableIds);
        return this.dbAdapter.saveReportDefinition(storedReport);
    }

    @RequestMapping(value={"/report/download"}, method={RequestMethod.POST})
    public Download getFile(@RequestBody StoredReport storedReport) throws Exception {
        this.checkCreateOrViewRightForFactTables(storedReport.reportDefinition.factTableIds);
        Date date = new Date();
        Object fileName = "BI-Analyse_";
        if (storedReport.id != 0) {
            if (((String)(fileName = (String)fileName + this.dbAdapter.findById((int)storedReport.id).get().name + "_")).length() > 206) {
                fileName = ((String)fileName).substring(0, 160);
            }
            fileName = ((String)fileName).replaceAll("[^a-zA-Z0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df_]+", "_");
        }
        fileName = (String)fileName + new SimpleDateFormat("yyyyMMdd_HHmmss").format(date);
        if (!storedReport.exportedResult.resultType.equals((Object)ResultType.FlatTable)) {
            Row totalRow = storedReport.exportedResult.getTotalRow();
            storedReport.exportedResult.rows = BiAnalysisManager.hierarchyToRows(storedReport.hierarchy);
            storedReport.exportedResult.rows.add(totalRow);
        }
        XSSFWorkbook workbook = new ExcelSheetBuilder(storedReport.exportedResult).withFileName((String)fileName).withReportName(storedReport.name).withDescription(storedReport.description).withDate(date).build();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        workbook.write((OutputStream)bos);
        String base64String = Base64.getEncoder().encodeToString(bos.toByteArray());
        String contentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        return new Download((String)fileName, contentType, base64String);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/deleteReportDefinition"})
    public boolean deleteReportDefinition(@RequestBody int id) throws Exception {
        try {
            Optional<StoredReport> reportOpt = this.dbAdapter.findById(id);
            if (reportOpt.isEmpty()) {
                throw new Exception("FEHLER: Berichtskonfiguration konnte nicht gefunden werden.");
            }
            this.checkCreateRightForFactTables(reportOpt.get().reportDefinition.factTableIds);
            this.rightsService.checkDeleteRights();
            this.dbAdapter.deleteById(id);
            return true;
        }
        catch (Exception e) {
            throw new Exception("FEHLER: Berichtskonfiguration konnte nicht gel\u00f6scht werden.", e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/reportDefinitions"})
    public List<StoredReport> listReportDefinitions() throws Exception {
        this.rightsService.checkCreateOrViewRights();
        List<StoredReport> storedReports = null;
        try {
            storedReports = this.dbAdapter.findAllStoredReports();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e.getCause().getMessage().contains("FEHLER: Relation \u00bbmetadata.rw_report_definitions\u00ab existiert nicht")) {
                throw new NotYetImplementedException("Bitte installieren Sie zuerst die Komponente 'BI-Analyse-Daten' und f\u00fchren Sie anschlie\u00dfend den Konnektor aus.");
            }
            throw e;
        }
        return storedReports;
    }

    private void checkCreateOrViewRightForFactTables(List<Identifier> factTableIds) {
        for (Identifier factId : factTableIds) {
            int sachgebiet = this.dbAdapter.getSachgebietByFactTableId(factId.composedId);
            this.rightsService.checkSachgebiet(sachgebiet, Right.CREATE_ANALYSIS, Right.VIEW_REPORT);
            this.rightsService.checkFactTable(factId, Right.CREATE_ANALYSIS, Right.VIEW_REPORT);
        }
    }

    private void checkCreateRightForFactTables(List<Identifier> factTableIds) {
        for (Identifier factId : factTableIds) {
            int sachgebiet = this.dbAdapter.getSachgebietByFactTableId(factId.composedId);
            this.rightsService.checkSachgebiet(sachgebiet, Right.CREATE_ANALYSIS);
            this.rightsService.checkFactTable(factId, Right.CREATE_ANALYSIS);
        }
    }
}

