/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.bin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.StatementVisitorAdapter;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitorAdapter;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.TableFunction;
import net.sf.jsqlparser.statement.select.WithItem;

public class ColumnCollector {
    Map<String, String> aliasToTableMap = new HashMap<String, String>();
    List<String> ctes = new ArrayList<String>();
    Map<String, List<String>> aliases = new HashMap<String, List<String>>();
    String filePath;
    FromItemVisitorAdapter<Void> fromvisiter = new FromItemVisitorAdapter<Void>(){

        public <S> Void visit(Table table, S context) {
            if (table.getAlias() != null) {
                ColumnCollector.this.aliasToTableMap.put(table.getAlias().getName(), table.getSchemaName() + "." + table.getName());
            }
            return null;
        }

        public <S> Void visit(ParenthesedSelect parenthesedSelect, S context) {
            if (parenthesedSelect.getSelect() != null) {
                parenthesedSelect.getSelect().accept(ColumnCollector.this.selectVisitorAdapter, context);
            }
            return null;
        }
    };
    ExpressionVisitorAdapter<Void> expressionVisitorAdapter = new ExpressionVisitorAdapter<Void>(){

        public <S> Void visit(EqualsTo equalsTo, S context) {
            equalsTo.getLeftExpression().accept((ExpressionVisitor)this, context);
            if (equalsTo.getRightExpression() instanceof ParenthesedSelect) {
                ((ParenthesedSelect)equalsTo.getRightExpression()).accept(ColumnCollector.this.fromvisiter, context);
            } else {
                equalsTo.getRightExpression().accept((ExpressionVisitor)this, context);
            }
            return null;
        }

        public <S> Void visit(AndExpression expr, S context) {
            Expression rightExpr = expr.getRightExpression();
            if (rightExpr instanceof ParenthesedSelect) {
                rightExpr.accept((ExpressionVisitor)this, ColumnCollector.this.fromvisiter);
            } else {
                rightExpr.accept((ExpressionVisitor)this, context);
            }
            Expression leftExpr = expr.getLeftExpression();
            if (leftExpr instanceof ParenthesedSelect) {
                leftExpr.accept((ExpressionVisitor)this, ColumnCollector.this.fromvisiter);
            } else {
                leftExpr.accept((ExpressionVisitor)this, context);
            }
            return null;
        }

        public <S> Void visit(InExpression expr, S context) {
            Expression expression = expr.getRightExpression();
            Expression leftExpression = expr.getLeftExpression();
            if (expression instanceof ParenthesedSelect) {
                ((ParenthesedSelect)expression).accept(ColumnCollector.this.fromvisiter, context);
            } else {
                expression.accept((ExpressionVisitor)this, context);
            }
            if (leftExpression instanceof ParenthesedSelect) {
                ((ParenthesedSelect)leftExpression).accept(ColumnCollector.this.fromvisiter, context);
            } else {
                leftExpression.accept((ExpressionVisitor)this, context);
            }
            return null;
        }

        public <S> Void visit(Column column, S context) {
            List<String> cols;
            String tableName = null;
            String tableNameFromContext = (String)context;
            if (column.getTable() != null && column.getTable().getName() != null) {
                String alias = column.getTable().getName();
                if (ColumnCollector.this.aliasToTableMap.containsKey(alias)) {
                    tableName = ColumnCollector.this.aliasToTableMap.getOrDefault(alias, alias);
                }
            } else {
                tableName = tableNameFromContext;
            }
            if (tableName == null || tableName.isEmpty() || ColumnCollector.this.ctes.contains(tableName.replace("null.", ""))) {
                return null;
            }
            if (!ColumnCollector.this.aliases.containsKey(tableName)) {
                ColumnCollector.this.aliases.put(tableName, new ArrayList());
            }
            if (!(cols = ColumnCollector.this.aliases.get(tableName)).contains(column.getColumnName())) {
                cols.add(column.getColumnName());
            }
            return null;
        }
    };
    SelectVisitorAdapter<Void> selectVisitorAdapter = new SelectVisitorAdapter<Void>(){

        public <S> Void visit(SetOperationList setOpList, S context) {
            for (Select selectBody : setOpList.getSelects()) {
                selectBody.accept((SelectVisitor)this, context);
            }
            return null;
        }

        public <S> Void visit(PlainSelect plainSelect, S context) {
            if (plainSelect.getWithItemsList() != null) {
                for (WithItem withItem : plainSelect.getWithItemsList()) {
                    ColumnCollector.this.ctes.add(withItem.getAliasName());
                    withItem.accept(ColumnCollector.this.statementVisitor, context);
                }
            }
            Object tabCon = "";
            if (plainSelect.getFromItem() != null) {
                FromItem fromItem = plainSelect.getFromItem();
                if (fromItem instanceof Table) {
                    Table table = (Table)fromItem;
                    if (table.getAlias() != null) {
                        ColumnCollector.this.aliasToTableMap.put(fromItem.getAlias().getName(), table.getSchemaName() + "." + table.getName());
                    } else {
                        tabCon = table.getSchemaName() + "." + table.getName();
                    }
                } else if (fromItem instanceof ParenthesedSelect) {
                    ((ParenthesedSelect)fromItem).getSelect().accept((SelectVisitor)this, context);
                } else if (!(fromItem instanceof TableFunction)) {
                    System.out.println("UWAGA!");
                }
            }
            if (plainSelect.getJoins() != null) {
                for (Join join : plainSelect.getJoins()) {
                    if (join.isCross()) {
                        join.getRightItem().accept(ColumnCollector.this.fromvisiter, context);
                        continue;
                    }
                    if (join.getRightItem() != null) {
                        join.getRightItem().accept(ColumnCollector.this.fromvisiter, context);
                    }
                    try {
                        Collection onExpressions = join.getOnExpressions();
                        if (onExpressions == null) continue;
                        for (Expression expression : onExpressions) {
                            expression.accept(ColumnCollector.this.expressionVisitorAdapter, context);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (plainSelect.getSelectItems() != null) {
                for (SelectItem selectItem : plainSelect.getSelectItems()) {
                    selectItem.accept(ColumnCollector.this.expressionVisitorAdapter, tabCon);
                }
            }
            if (plainSelect.getWhere() != null) {
                plainSelect.getWhere().accept(ColumnCollector.this.expressionVisitorAdapter, tabCon);
            }
            return null;
        }
    };
    StatementVisitorAdapter<Void> statementVisitor = new StatementVisitorAdapter<Void>(){

        public <S> Void visit(Select select, S context) {
            if (select.getWithItemsList() != null) {
                for (WithItem withItem : select.getWithItemsList()) {
                    ColumnCollector.this.ctes.add(withItem.getAliasName());
                    ColumnCollector.this.aliasToTableMap = new HashMap<String, String>();
                    withItem.accept((StatementVisitor)this, context);
                }
            }
            if (select.getSelectBody() != null) {
                select.getSelectBody().accept(ColumnCollector.this.selectVisitorAdapter, context);
            }
            return null;
        }
    };

    public ColumnCollector(String filePath) {
        this.filePath = filePath;
    }

    public ColumnCollector() {
    }

    public void parseForFile() {
        try {
            String sql = Files.readString(Paths.get(this.filePath, new String[0]));
            String cleanedSql = Arrays.stream(sql.split("\n")).map(String::trim).filter(line -> !line.isEmpty()).collect(Collectors.joining("\n"));
            this.parseSql(cleanedSql);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Map<String, List<String>> getColumns() {
        return this.aliases;
    }

    public void parseSql(String sql) {
        this.aliasToTableMap = new HashMap<String, String>();
        this.aliases = new HashMap<String, List<String>>();
        this.ctes = new ArrayList<String>();
        try {
            Statement stmt = CCJSqlParserUtil.parse((String)sql);
            stmt.accept(this.statementVisitor, null);
        }
        catch (JSQLParserException e) {
            e.printStackTrace();
        }
    }
}

