/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XmlFlatFileMerger {
    private static Logger logger = Logger.getLogger(XmlFlatFileMerger.class);
    public static final DateFormat MONDRIAN_SCHEMA_TIMESTAMP_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    public static final DateFormat MONDRIAN_SCHEMA_TIMESTAMP_FORMAT_NO_SECONDS = new SimpleDateFormat("dd.MM.yyyy HH:mm");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Level logLevelBefore = logger.getLevel();
        try {
            logger.setLevel(Level.DEBUG);
            if (args.length < 3 || args.length > 4) {
                System.exit(0);
            }
            String dir = args[0];
            String inPattern = args[1];
            String outFile = args[2];
            String encoding = "UTF-8";
            if (args.length == 4) {
                encoding = args[3];
            }
            XmlFlatFileMerger.flatMergeXmlFiles(dir, inPattern, outFile, encoding);
        }
        finally {
            logger.setLevel(logLevelBefore);
        }
    }

    public static boolean flatMergeXmlFiles(String inDir, String inPattern, String outFile, String encoding) {
        boolean success = false;
        final Pattern filePattern = Pattern.compile(inPattern);
        File dir = new File(inDir);
        if (dir.isDirectory()) {
            File[] inFiles = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    Matcher m = filePattern.matcher(pathname.getName());
                    return m.matches();
                }
            });
            SAXReader reader = new SAXReader();
            LinkedHashMap outNodes = new LinkedHashMap();
            Document doc = null;
            Element root = null;
            HashSet<String> dimensionNames = new HashSet<String>();
            for (File inFile : inFiles) {
                try {
                    doc = reader.read(inFile);
                    Node comment = doc.selectSingleNode("//comment()");
                    doc.remove(comment);
                    root = doc.getRootElement();
                    List elements = root.elements();
                    for (Element element : elements) {
                        String type = element.getName();
                        String name = element.attributeValue("name");
                        if (name == null) {
                            if (!outNodes.containsKey(type)) {
                                outNodes.put(type, new HashMap());
                            }
                            element.detach();
                            for (Element child : element.elements()) {
                                ((Map)outNodes.get(type)).put(child.attributeValue("alias"), child.detach());
                            }
                            continue;
                        }
                        logger.debug((Object)(type + " : " + name));
                        if (!outNodes.containsKey(type)) {
                            outNodes.put(type, new HashMap());
                        }
                        if (type.equals("Dimension")) {
                            if (dimensionNames.contains(name)) {
                                logger.debug((Object)("Dimension " + name + " already exists."));
                                Node newDim = element.detach();
                                Node oldDim = (Node)((Map)outNodes.get(type)).get(name);
                                if (StringUtils.removePattern((String)newDim.asXML(), (String)"\\s").equals(StringUtils.removePattern((String)oldDim.asXML(), (String)"\\s"))) continue;
                                String msg = "Dimension " + name + " has differing entries in " + inFile.getName() + "! Please fix.";
                                msg = msg + "\nXML:\n" + newDim.asXML();
                                msg = msg + "\nexpected XML:\n" + oldDim.asXML();
                                logger.error((Object)msg);
                                continue;
                            }
                            ((Map)outNodes.get(type)).put(name, element.detach());
                            dimensionNames.add(name);
                            continue;
                        }
                        ((Map)outNodes.get(type)).put(name, element.detach());
                    }
                    for (Map.Entry entry : outNodes.entrySet()) {
                        String tagName = (String)entry.getKey();
                        logger.debug((Object)("All elements of type " + tagName + ":"));
                        TreeSet sortedEntries = new TreeSet(((Map)entry.getValue()).keySet());
                        boolean isContainerTag = !((Node)((Map)entry.getValue()).values().iterator().next()).getName().equals(tagName);
                        Element addToNode = isContainerTag ? root.addElement(tagName) : root;
                        for (String key : sortedEntries) {
                            logger.debug((Object)("Name: " + key));
                            addToNode.add(((Node)((Map)entry.getValue()).get(key)).detach());
                        }
                    }
                }
                catch (DocumentException e) {
                    logger.error((Object)("Cannot open file " + String.valueOf(inFile)));
                }
            }
            if (doc != null) {
                try (FileOutputStream fos = new FileOutputStream(dir.getAbsolutePath() + File.separator + outFile);){
                    OutputFormat format = OutputFormat.createPrettyPrint();
                    format.setNewLineAfterDeclaration(false);
                    format.setEncoding(encoding);
                    XMLWriter writer = new XMLWriter((OutputStream)fos, format);
                    List tmpList = doc.getRootElement().elements();
                    doc.getRootElement().clearContent();
                    doc.getRootElement().addComment("Automatisch generiert von Edustore durch mondrian_schema_4.xsl " + MONDRIAN_SCHEMA_TIMESTAMP_FORMAT.format(new Date()));
                    doc.getRootElement().elements().addAll(tmpList);
                    writer.write(doc);
                    writer.flush();
                    success = true;
                }
                catch (IOException e) {
                    logger.error((Object)"Cannot write xml to output file.", (Throwable)e);
                }
            }
        }
        return success;
    }
}

