/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.db;

import de.memtext.db.ConnectionCreator;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.io.FileUtils;

public class SchemaReader {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("SchemaReader db.properties");
            System.exit(1);
        }
        try {
            Connection con = ConnectionCreator.getConnectionCryptPassword(args[0], "driverName", "connectionURL", "connectionName", "connectionPassword");
            DatabaseMetaData md = con.getMetaData();
            ResultSet myTables = md.getTables(null, null, null, null);
            StringBuffer result = new StringBuffer();
            if (myTables != null) {
                while (myTables.next()) {
                    String tabname = myTables.getString(3);
                    result.append("TABLE " + tabname + "\n");
                    ResultSet cols = md.getColumns(null, null, tabname, null);
                    while (cols.next()) {
                        result.append(cols.getString(4) + ":" + String.valueOf(cols.getObject(5)) + "\n");
                    }
                    result.append("----\n");
                }
            }
            FileUtils.writeStringToFile((File)new File("schema.txt"), (String)result.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

