/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.annotation;

import io.micrometer.observation.ObservationRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class BatchObservabilityBeanPostProcessor
implements BeanFactoryPostProcessor,
BeanPostProcessor {
    private static final Log LOGGER = LogFactory.getLog(BatchObservabilityBeanPostProcessor.class);
    private ConfigurableListableBeanFactory beanFactory;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        try {
            if (bean instanceof AbstractJob || bean instanceof AbstractStep) {
                ObservationRegistry observationRegistry = (ObservationRegistry)this.beanFactory.getBean(ObservationRegistry.class);
                if (bean instanceof AbstractJob) {
                    ((AbstractJob)bean).setObservationRegistry(observationRegistry);
                }
                if (bean instanceof AbstractStep) {
                    ((AbstractStep)bean).setObservationRegistry(observationRegistry);
                }
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            LOGGER.info((Object)"No Micrometer observation registry found, defaulting to ObservationRegistry.NOOP");
        }
        return bean;
    }
}

