/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;

public class CasAuthenticationProvider
implements AuthenticationProvider {
    private static final String ROLE_USER = "ROLE_USER";
    private static final String ROLE_ADMIN = "ROLE_ADMIN";
    private static Map<String, UserDetails> userCache = new HashMap<String, UserDetails>();

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        UserDetails user = this.createUserByUsername(authentication.getName());
        return new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities());
    }

    public boolean supports(Class<?> aClass) {
        return true;
    }

    private UserDetails createUserByUsername(String username) {
        if (userCache.containsKey(username)) {
            return userCache.get(username);
        }
        User user = new User(username, username, true, true, true, true, (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{ROLE_USER, ROLE_ADMIN}));
        userCache.put(username, (UserDetails)user);
        return user;
    }
}

