/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.util.security.authorisation;

import org.saiku.service.util.security.authorisation.AuthorisationPredicate;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class RoleBasedAuthorisation
implements AuthorisationPredicate {
    private final String mandatoryRole;

    public RoleBasedAuthorisation(String mandatoryRole) {
        this.mandatoryRole = mandatoryRole;
    }

    @Override
    public boolean isAuthorised(Authentication authentication) {
        if (authentication == null) {
            return false;
        }
        if (!authentication.isAuthenticated()) {
            return false;
        }
        for (GrantedAuthority authority : authentication.getAuthorities()) {
            if (!authority.getAuthority().equals(this.mandatoryRole)) continue;
            return true;
        }
        return false;
    }
}

