/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.util.export;

import java.util.List;
import org.olap4j.CellSet;
import org.saiku.olap.dto.resultset.CellDataSet;
import org.saiku.olap.query2.ThinHierarchy;
import org.saiku.olap.util.OlapResultSetUtil;
import org.saiku.olap.util.formatter.FlattenedCellSetFormatter;
import org.saiku.olap.util.formatter.HierarchicalCellSetFormatter;
import org.saiku.olap.util.formatter.ICellSetFormatter;
import org.saiku.service.util.export.excel.ExcelBuilderOptions;
import org.saiku.service.util.export.excel.ExcelWorksheetBuilder;

public class ExcelExporter {
    public static byte[] exportExcel(CellSet cellSet, List<ThinHierarchy> filters) {
        return ExcelExporter.exportExcel(cellSet, (ICellSetFormatter)new HierarchicalCellSetFormatter(), filters);
    }

    public static byte[] exportExcel(CellSet cellSet, ICellSetFormatter formatter, List<ThinHierarchy> filters) {
        CellDataSet table = OlapResultSetUtil.cellSet2Matrix(cellSet, formatter);
        return ExcelExporter.exportExcel(table, formatter, filters);
    }

    public static byte[] exportExcel(CellDataSet table, ICellSetFormatter formatter, List<ThinHierarchy> filters) {
        ExcelBuilderOptions exb = new ExcelBuilderOptions();
        exb.repeatValues = formatter instanceof FlattenedCellSetFormatter;
        return ExcelExporter.getExcel(table, filters, exb);
    }

    private static byte[] getExcel(CellDataSet table, List<ThinHierarchy> filters, ExcelBuilderOptions options) {
        ExcelWorksheetBuilder worksheetBuilder = new ExcelWorksheetBuilder(table, filters, options);
        return worksheetBuilder.build();
    }
}

