/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.olap.totals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mondrian.util.Format;
import org.apache.commons.lang.StringUtils;
import org.olap4j.Axis;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.OlapException;
import org.olap4j.Position;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.Property;
import org.saiku.olap.query2.ThinLevel;
import org.saiku.olap.query2.ThinMeasure;
import org.saiku.olap.query2.ThinQuery;
import org.saiku.olap.query2.util.Fat;
import org.saiku.olap.util.SaikuProperties;
import org.saiku.service.olap.totals.AxisInfo;
import org.saiku.service.olap.totals.FormatList;
import org.saiku.service.olap.totals.TotalNode;
import org.saiku.service.olap.totals.aggregators.TotalAggregator;

public class TotalsListsBuilder
implements FormatList {
    private final Member[] memberBranch;
    private final TotalNode[] totalBranch;
    private final TotalAggregator[] aggrTempl;
    private final int col;
    private final int row;
    private final List<TotalNode>[] totalsLists;
    private final int measuresAt;
    private final String[] measuresCaptions;
    private final Measure[] measures;
    private final Map<String, Integer> uniqueToSelected;
    private final AxisInfo dataAxisInfo;
    private final AxisInfo totalsAxisInfo;
    private final CellSet cellSet;
    private final Format[] valueFormats;
    private final ThinQuery thinQuery;

    public TotalsListsBuilder(Measure[] selectedMeasures, TotalAggregator[] aggrTempl, CellSet cellSet, AxisInfo totalsAxisInfo, AxisInfo dataAxisInfo) throws Exception {
        this(selectedMeasures, aggrTempl, cellSet, totalsAxisInfo, dataAxisInfo, null);
    }

    public TotalsListsBuilder(Measure[] selectedMeasures, TotalAggregator[] aggrTempl, CellSet cellSet, AxisInfo totalsAxisInfo, AxisInfo dataAxisInfo, ThinQuery thinQuery) throws Exception {
        List members;
        Cube cube;
        this.thinQuery = thinQuery;
        try {
            cube = cellSet.getMetaData().getCube();
        }
        catch (OlapException e) {
            throw new RuntimeException(e);
        }
        this.uniqueToSelected = new HashMap<String, Integer>();
        if (selectedMeasures.length > 0) {
            this.valueFormats = new Format[selectedMeasures.length];
            this.measures = selectedMeasures;
            for (int i = 0; i < this.valueFormats.length; ++i) {
                this.valueFormats[i] = this.getMeasureFormat(selectedMeasures[i]);
                this.uniqueToSelected.put(selectedMeasures[i].getUniqueName(), i);
            }
        } else {
            Member ms;
            Measure defaultMeasure = (Measure)cube.getMeasures().get(0);
            if (cube.getDimensions().get("Measures") != null && (ms = ((Dimension)cube.getDimensions().get("Measures")).getDefaultHierarchy().getDefaultMember()) instanceof Measure) {
                defaultMeasure = (Measure)ms;
            }
            this.measures = new Measure[]{defaultMeasure};
            this.valueFormats = new Format[]{this.getMeasureFormat(defaultMeasure)};
        }
        this.cellSet = cellSet;
        this.dataAxisInfo = dataAxisInfo;
        this.totalsAxisInfo = totalsAxisInfo;
        int maxDepth = dataAxisInfo.maxDepth + 1;
        boolean hasMeasuresOnDataAxis = false;
        int measuresAt = 0;
        List list = members = dataAxisInfo.axis.getPositionCount() > 0 ? ((Position)dataAxisInfo.axis.getPositions().get(0)).getMembers() : Collections.emptyList();
        for (int measuresMember = 0; measuresMember < members.size(); ++measuresMember) {
            Member m = (Member)members.get(measuresMember);
            if ("Measures".equals(m.getDimension().getName())) {
                hasMeasuresOnDataAxis = true;
                break;
            }
            measuresAt += dataAxisInfo.levels[measuresMember].size();
        }
        if (hasMeasuresOnDataAxis) {
            this.measuresAt = measuresAt;
            this.measuresCaptions = new String[selectedMeasures.length];
            for (int i = 0; i < this.measuresCaptions.length; ++i) {
                this.measuresCaptions[i] = selectedMeasures[i].getCaption();
            }
        } else {
            this.measuresAt = Integer.MIN_VALUE;
            this.measuresCaptions = null;
        }
        this.totalBranch = new TotalNode[maxDepth];
        if (aggrTempl[0] == null) {
            for (Measure m : this.measures) {
                ThinMeasure tm;
                if (!(m instanceof Fat.MeasureAdapter) || (tm = ((Fat.MeasureAdapter)m).getThinMeasure()) == null || tm.getAggregators() == null || tm.getAggregators().isEmpty()) continue;
                aggrTempl[0] = TotalAggregator.newInstanceByFunctionName("nil");
                break;
            }
        }
        TotalNode rootNode = new TotalNode(this.measuresCaptions, this.measures, aggrTempl[0], this, totalsAxisInfo.fullPositions.size(), dataAxisInfo);
        this.col = Axis.ROWS.equals((Object)dataAxisInfo.axis.getAxisOrdinal()) ? 1 : 0;
        this.row = this.col + 1 & 1;
        this.aggrTempl = aggrTempl;
        this.totalBranch[0] = rootNode;
        this.totalsLists = new List[maxDepth];
        for (int i = 0; i < this.totalsLists.length; ++i) {
            this.totalsLists[i] = new ArrayList<TotalNode>();
        }
        this.totalsLists[0].add(rootNode);
        this.memberBranch = new Member[dataAxisInfo.maxDepth + 1];
    }

    private Format getMeasureFormat(Measure m) {
        try {
            String formatString = (String)m.getPropertyValue((Property)Property.StandardCellProperty.FORMAT_STRING);
            if (StringUtils.isBlank((String)formatString)) {
                if (m.getProperties() != null) {
                    Map props = m.getProperties().asMap();
                    if (props.containsKey("FORMAT_STRING")) {
                        formatString = (String)m.getPropertyValue((Property)props.get("FORMAT_STRING"));
                    } else if (props.containsKey("FORMAT_EXP_PARSED")) {
                        formatString = (String)m.getPropertyValue((Property)props.get("FORMAT_EXP_PARSED"));
                    } else if (props.containsKey("FORMAT_EXP")) {
                        formatString = (String)m.getPropertyValue((Property)props.get("FORMAT_EXP"));
                    } else if (props.containsKey("FORMAT")) {
                        formatString = (String)m.getPropertyValue((Property)props.get("FORMAT"));
                    }
                }
                if (StringUtils.isBlank((String)formatString)) {
                    formatString = "Standard";
                }
                if (StringUtils.isNotBlank((String)formatString) && formatString.length() > 1 && formatString.startsWith("\"") && formatString.endsWith("\"")) {
                    formatString = formatString.substring(1, formatString.length() - 1);
                }
            }
            return Format.get((String)formatString, (Locale)SaikuProperties.locale);
        }
        catch (OlapException e) {
            throw new RuntimeException(e);
        }
    }

    private void positionMember(int depth, Member m, List<Integer> levels, Member[] branch) {
        int i = levels.size() - 1;
        while (i >= 0) {
            branch[depth + i] = m;
            --i;
            do {
                m = m.getParentMember();
            } while (i >= 0 && m != null && m.getDepth() != levels.get(i).intValue());
        }
    }

    private void traverse(List<Integer>[] levels, List<TotalNode>[] totalLists) {
        int fullPosition = 0;
        Member[] prevMemberBranch = new Member[this.memberBranch.length];
        block0: for (Position p : this.dataAxisInfo.axis.getPositions()) {
            int i;
            int changedFrom;
            int depth = 1;
            int mI = 0;
            for (Member m : p.getMembers()) {
                int maxDepth = levels[mI].get(levels[mI].size() - 1);
                if (m.getDepth() < maxDepth) continue block0;
                this.positionMember(depth, m, levels[mI], this.memberBranch);
                depth += levels[mI].size();
                ++mI;
            }
            for (changedFrom = 1; changedFrom < this.memberBranch.length - 1 && this.memberBranch[changedFrom].equals(prevMemberBranch[changedFrom]); ++changedFrom) {
            }
            for (i = this.totalBranch.length - 1; i >= changedFrom; --i) {
                if (this.totalBranch[i] == null) continue;
                this.totalBranch[i - 1].appendChild(this.totalBranch[i]);
            }
            for (i = changedFrom; i < this.totalBranch.length; ++i) {
                String[] captions = this.measuresAt > i - 1 ? this.measuresCaptions : null;
                String uniqueLevelName = this.dataAxisInfo.uniqueLevelNames.get(i - 1);
                ThinLevel level = this.thinQuery.getLevel(uniqueLevelName);
                if (level != null && level.getAggregators() != null && !level.getAggregators().isEmpty()) {
                    List<String> lvlAggr = level.getAggregators();
                    Measure[] newMeasures = new Measure[this.measures.length];
                    for (int j = 0; j < newMeasures.length; ++j) {
                        if (j < lvlAggr.size()) {
                            ThinMeasure mockMeasure = new ThinMeasure(this.measures[j].getName(), this.measures[j].getUniqueName(), this.measures[j].getCaption(), ThinMeasure.Type.EXACT);
                            mockMeasure.getAggregators().add(lvlAggr.get(j));
                            newMeasures[j] = new Fat.MeasureAdapter(this.measures[j], mockMeasure);
                            continue;
                        }
                        newMeasures[j] = this.measures[j];
                    }
                    this.totalBranch[i] = new TotalNode(captions, newMeasures, this.aggrTempl[i], this, this.totalsAxisInfo.fullPositions.size(), this.dataAxisInfo);
                } else {
                    this.totalBranch[i] = new TotalNode(captions, this.measures, this.aggrTempl[i], this, this.totalsAxisInfo.fullPositions.size(), this.dataAxisInfo);
                }
                totalLists[i].add(this.totalBranch[i]);
            }
            System.arraycopy(this.memberBranch, 0, prevMemberBranch, 0, prevMemberBranch.length);
            this.totalBranch[this.totalBranch.length - 1].setSpan(1);
            this.totalBranch[this.totalBranch.length - 1].setWidth(1);
            for (int t = 0; t < this.totalsAxisInfo.fullPositions.size(); ++t) {
                Cell cell = this.getCellAt(fullPosition, t);
                for (int branchNode = 0; branchNode < this.totalBranch.length; ++branchNode) {
                    if (this.aggrTempl[branchNode] == null) continue;
                    this.totalBranch[branchNode].addData(this.getMemberIndex(branchNode, fullPosition), t, cell);
                }
            }
            ++fullPosition;
        }
        for (int i = this.totalBranch.length - 1; i > 0; --i) {
            this.totalBranch[i - 1].appendChild(this.totalBranch[i]);
        }
        for (TotalNode n : totalLists[totalLists.length - 1]) {
            n.setWidth(0);
        }
    }

    public List<TotalNode>[] buildTotalsLists() {
        this.traverse(this.dataAxisInfo.levels, this.totalsLists);
        return this.totalsLists;
    }

    private Cell getCellAt(int axisCoord, int perpAxisCoord) {
        Position[] positions = new Position[]{this.dataAxisInfo.fullPositions.get(axisCoord), this.totalsAxisInfo.fullPositions.get(perpAxisCoord)};
        return this.cellSet.getCell(new Position[]{positions[this.col], positions[this.row]});
    }

    private int getMemberIndex(int depth, int index) {
        Member m;
        if (depth - 1 < this.measuresAt && this.uniqueToSelected.containsKey((m = (Member)this.dataAxisInfo.fullPositions.get(index).getMembers().get(this.dataAxisInfo.measuresMember)).getUniqueName())) {
            return this.uniqueToSelected.get(m.getUniqueName());
        }
        return 0;
    }

    @Override
    public Format getValueFormat(int position, int member) {
        Member m;
        int formatIndex = 0;
        if (this.dataAxisInfo.measuresMember >= 0) {
            formatIndex = member;
        } else if (this.totalsAxisInfo.measuresMember >= 0 && this.uniqueToSelected.containsKey((m = (Member)this.totalsAxisInfo.fullPositions.get(position).getMembers().get(this.totalsAxisInfo.measuresMember)).getUniqueName())) {
            formatIndex = this.uniqueToSelected.get(m.getUniqueName());
        }
        return this.valueFormats[formatIndex];
    }
}

