/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.datasource;

import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.saiku.database.dto.MondrianSchema;
import org.saiku.datasources.connection.IConnectionManager;
import org.saiku.datasources.connection.RepositoryFile;
import org.saiku.datasources.datasource.SaikuDatasource;
import org.saiku.repository.AclEntry;
import org.saiku.repository.ClassPathRepositoryManager;
import org.saiku.repository.DataSource;
import org.saiku.repository.IRepositoryManager;
import org.saiku.repository.IRepositoryObject;
import org.saiku.repository.JackRabbitRepositoryManager;
import org.saiku.repository.MarkLogicRepositoryManager;
import org.saiku.repository.ScopedRepo;
import org.saiku.service.datasource.IDatasourceManager;
import org.saiku.service.importer.JujuSource;
import org.saiku.service.importer.LegacyImporterImpl;
import org.saiku.service.user.UserService;
import org.saiku.service.util.security.authentication.PasswordProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.userdetails.UserDetails;

public class RepositoryDatasourceManager
implements IDatasourceManager,
ApplicationListener<ApplicationEvent> {
    public static final String ORBIS_WORKSPACE_DIR = "workspace";
    public static final String SAIKU_AUTH_PRINCIPAL = "SAIKU_AUTH_PRINCIPAL";
    private final Map<String, SaikuDatasource> datasources = Collections.synchronizedMap(new HashMap());
    public IConnectionManager connectionManager;
    private ScopedRepo sessionRegistry;
    private boolean workspaces;
    private UserService userService;
    private static final Logger log = LoggerFactory.getLogger(RepositoryDatasourceManager.class);
    private String configurationpath;
    private String datadir;
    private IRepositoryManager irm;
    private String foodmartdir;
    private String foodmartschema;
    private String foodmarturl;
    private PasswordProvider repopasswordprovider;
    private String oldpassword;
    private String earthquakeurl;
    private String earthquakedir;
    private String earthquakeschema;
    private String defaultRole;
    private String externalparameters;
    private String type;
    private String separator = "/";
    private String host;
    private String port;
    private String username;
    private String password;
    private String database;
    private String sessionUsername;

    public void setConnectionManager(IConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void onApplicationEvent(ApplicationEvent appEvent) {
        if (appEvent instanceof AuthenticationSuccessEvent) {
            AuthenticationSuccessEvent authEvent = (AuthenticationSuccessEvent)appEvent;
            UserDetails userDetails = (UserDetails)authEvent.getAuthentication().getPrincipal();
            this.sessionUsername = userDetails.getUsername();
            this.loadDatasources(this.checkForExternalDataSourceProperties());
        }
    }

    @Override
    public void load() {
        Properties ext = this.checkForExternalDataSourceProperties();
        if (this.type.equals("marklogic")) {
            this.irm = MarkLogicRepositoryManager.getMarkLogicRepositoryManager(this.host, Integer.parseInt(this.port), this.username, this.password, this.database, this.cleanse(this.datadir), this.sessionRegistry, this.workspaces);
        } else if (this.type.equals("classpath")) {
            this.separator = "/";
            log.debug("init datadir= " + this.datadir);
            this.irm = ClassPathRepositoryManager.getClassPathRepositoryManager(this.cleanse(this.datadir), this.defaultRole, this.sessionRegistry, this.workspaces);
            log.debug("2nd init datadir= " + this.datadir);
        } else {
            this.irm = JackRabbitRepositoryManager.getJackRabbitRepositoryManager(this.configurationpath, this.datadir, this.repopasswordprovider.getPassword(), this.oldpassword, this.defaultRole, this.sessionRegistry, this.workspaces);
        }
        try {
            this.irm.start(this.userService);
            this.saveInternalFile("/etc" + this.separator + ".repo_version", "d20f0bea-681a-11e5-9d70-feff819cdc9f", null);
        }
        catch (RepositoryException e) {
            log.error("Could not start repo", (Throwable)e);
        }
        this.loadDatasources(ext);
    }

    public void setRepositoryManager(IRepositoryManager irm) {
        this.irm = irm;
    }

    public Properties checkForExternalDataSourceProperties() {
        Properties p = new Properties();
        try {
            FileInputStream input = new FileInputStream(this.externalparameters);
            p.load(input);
        }
        catch (IOException e) {
            log.debug("file did not exist");
        }
        return p;
    }

    @Override
    public String[] getAvailablePropertiesKeys() {
        Properties p = new Properties();
        try {
            FileInputStream input = new FileInputStream(this.externalparameters);
            p.load(input);
        }
        catch (IOException e) {
            log.debug("file did not exist");
        }
        String[] arr = p.keySet().toArray(new String[p.keySet().size()]);
        ArrayList<String> newlist = new ArrayList<String>();
        for (String str : arr) {
            String[] s = str.split("\\.");
            newlist.add(s[1]);
        }
        HashSet unique = new HashSet(newlist);
        return unique.toArray(new String[unique.size()]);
    }

    @Override
    public void unload() {
        this.irm.shutdown();
    }

    @Override
    public SaikuDatasource addDatasource(SaikuDatasource datasource) throws Exception {
        DataSource ds = new DataSource(datasource);
        if (ds.getCsv() != null && ds.getCsv().equals("true")) {
            Object[] split = ds.getLocation().split("=");
            String loc = split[2];
            if (split[2].startsWith("mondrian:")) {
                split[2] = "mondrian:/" + this.getDatadir() + "datasources/" + ds.getName() + "-csv.json;Catalog";
            } else {
                split[2] = this.getDatadir() + "datasources/" + ds.getName() + "-csv.json;Catalog";
                split[2] = split[2].replace('\\', '/');
                split[2] = ((String)split[2]).replaceAll("[/]+", "/");
            }
            for (int i = 0; i < split.length - 1; ++i) {
                split[i] = (String)split[i] + "=";
            }
            ds.setLocation(StringUtils.join((Object[])split));
            log.debug("LOC IS: " + loc);
            String path = loc.substring(0, loc.lastIndexOf(";"));
            log.debug("PATH IS: " + path);
            path = path.replace("\\", "/");
            path = path.replaceAll("[/]+", "/");
            log.debug("Trimmed path is: " + path);
            if (!this.datadir.equals("${CLASSPATH_REPO_PATH_UNPARSED}")) {
                path = path.replaceFirst(this.getDatadir(), "");
            }
            if ((this.type.equals("jackrabbit") || this.type.equals("marklogic")) && !path.startsWith("mondrian://")) {
                if (this.type.equals("marklogic")) {
                    path = "mondrian:/" + path;
                } else {
                    String oldHomePrefix = "/homes/";
                    String newHomePrefix = "mondrian://homes/home:";
                    path = newHomePrefix + path.substring(oldHomePrefix.length());
                }
            }
            boolean f = true;
            if (new File(this.getDatadir() + path).exists() && new File(this.getDatadir() + path).isDirectory()) {
                f = false;
            }
            path = path.replace("\\", "/");
            if (!(path = path.replaceAll("[/]+", "/")).startsWith("mondrian:")) {
                String pathToSave = this.getDatadir() + path;
                pathToSave = pathToSave.replace("\\", "/");
                pathToSave = pathToSave.replaceAll("[/]+", "/");
                this.irm.saveInternalFile(this.getCSVJson(f, ds.getName(), pathToSave), this.separator + "datasources" + this.separator + ds.getName() + "-csv.json", null);
            } else {
                this.irm.saveInternalFile(this.getCSVJson(f, ds.getName(), path), this.separator + "datasources" + this.separator + ds.getName() + "-csv.json", null);
            }
            this.irm.saveDataSource(ds, this.separator + "datasources" + this.separator + ds.getName() + ".sds", "fixme");
            String name = ds.getName();
            SaikuDatasource sds = new SaikuDatasource(name, SaikuDatasource.Type.OLAP, datasource.getProperties());
            this.datasources.put(ds.getName(), sds);
            this.connectionManager.refreshConnection(name);
        } else {
            this.irm.saveDataSource(ds, this.separator + "datasources" + this.separator + ds.getName() + ".sds", "fixme");
        }
        String name = ds.getName();
        SaikuDatasource sds = new SaikuDatasource(name, SaikuDatasource.Type.OLAP, datasource.getProperties());
        this.datasources.put(name, sds);
        return datasource;
    }

    @Override
    public SaikuDatasource setDatasource(SaikuDatasource datasource) throws Exception {
        return this.addDatasource(datasource);
    }

    @Override
    public List<SaikuDatasource> addDatasources(List<SaikuDatasource> dsources) {
        for (SaikuDatasource datasource : dsources) {
            DataSource ds = new DataSource(datasource);
            try {
                this.irm.saveDataSource(ds, this.separator + "datasources" + this.separator + ds.getName() + ".sds", "fixme");
                this.datasources.put(datasource.getName(), datasource);
            }
            catch (RepositoryException e) {
                log.error("Could not add data source" + datasource.getName(), (Throwable)e);
            }
        }
        return dsources;
    }

    @Override
    public boolean removeDatasource(String datasourceId) {
        List<DataSource> ds = null;
        try {
            ds = this.irm.getAllDataSources();
        }
        catch (RepositoryException e) {
            log.error("Could not get all data sources");
        }
        if (ds != null) {
            for (DataSource data : ds) {
                if (!data.getId().equals(datasourceId)) continue;
                this.datasources.remove(data.getName());
                String path = data.getPath();
                if (!this.datadir.equals("${CLASSPATH_REPO_PATH_UNPARSED}")) {
                    path = path.replaceFirst(this.datadir, "");
                }
                this.irm.deleteFile(path);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeSchema(String schemaName) {
        List<MondrianSchema> s = null;
        try {
            s = this.irm.getAllSchema();
        }
        catch (RepositoryException e) {
            log.error("Could not get All Schema", (Throwable)e);
        }
        if (s != null) {
            for (MondrianSchema data : s) {
                if (!data.getName().equals(schemaName)) continue;
                this.irm.deleteFile(data.getPath());
                break;
            }
            return true;
        }
        return false;
    }

    @Override
    public Map<String, SaikuDatasource> getDatasources(String[] roles) {
        return this.datasources;
    }

    @Override
    public SaikuDatasource getDatasource(String datasourceName) {
        return this.datasources.get(datasourceName);
    }

    @Override
    public SaikuDatasource getDatasource(String datasourceName, boolean refresh) {
        if (!refresh) {
            if (this.datasources.size() > 0) {
                return this.datasources.get(datasourceName);
            }
        } else {
            return this.getDatasource(datasourceName);
        }
        return null;
    }

    @Override
    public void addSchema(String file, String path, String name) throws Exception {
        this.irm.saveInternalFile(file, path, "nt:mondrianschema");
    }

    @Override
    public List<MondrianSchema> getMondrianSchema() {
        try {
            return this.irm.getAllSchema();
        }
        catch (RepositoryException e) {
            log.error("Could not get all Schema", (Throwable)e);
            return null;
        }
    }

    @Override
    public MondrianSchema getMondrianSchema(String catalog) {
        return null;
    }

    @Override
    public RepositoryFile getFile(String file) {
        return this.irm.getFile(file);
    }

    @Override
    public String getFileData(String file, String username, List<String> roles) {
        try {
            return this.irm.getFile(file, username, roles);
        }
        catch (RepositoryException e) {
            log.error("Could not get file " + file, (Throwable)e);
            return null;
        }
    }

    @Override
    public String getInternalFileData(String file) throws RepositoryException {
        return this.irm.getInternalFile(file);
    }

    @Override
    public InputStream getBinaryInternalFileData(String file) throws RepositoryException {
        return this.irm.getBinaryInternalFile(file);
    }

    @Override
    public String saveFile(String path, Object content, String user, List<String> roles) {
        try {
            this.irm.saveFile(content, path, user, "nt:saikufiles", roles);
            return "Save Okay";
        }
        catch (RepositoryException e) {
            log.error("Save Failed", (Throwable)e);
            return "Save Failed: " + e.getLocalizedMessage();
        }
    }

    @Override
    public String removeFile(String path, String user, List<String> roles) {
        try {
            this.irm.removeFile(path, user, roles);
            return "Remove Okay";
        }
        catch (RepositoryException e) {
            log.error("Save Failed", (Throwable)e);
            return "Save Failed: " + e.getLocalizedMessage();
        }
    }

    @Override
    public String moveFile(String source, String target, String user, List<String> roles) {
        try {
            this.irm.moveFile(source, target, user, roles);
            return "Move Okay";
        }
        catch (RepositoryException e) {
            log.error("Move Failed", (Throwable)e);
            return "Move Failed: " + e.getLocalizedMessage();
        }
    }

    @Override
    public String saveInternalFile(String path, Object content, String type) {
        try {
            this.irm.saveInternalFile(content, path, type);
            return "Save Okay";
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return "Save Failed: " + e.getLocalizedMessage();
        }
    }

    @Override
    public String saveBinaryInternalFile(String path, InputStream content, String type) {
        try {
            this.irm.saveBinaryInternalFile(content, path, type);
            return "Save Okay";
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return "Save Failed: " + e.getLocalizedMessage();
        }
    }

    @Override
    public void removeInternalFile(String filePath) {
        try {
            this.irm.removeInternalFile(filePath);
        }
        catch (RepositoryException e) {
            log.error("Remove file failed: " + filePath);
            e.printStackTrace();
        }
    }

    @Override
    public List<IRepositoryObject> getFiles(List<String> type, String username, List<String> roles) {
        return this.irm.getAllFiles(type, username, roles);
    }

    @Override
    public List<IRepositoryObject> getFiles(List<String> type, String username, List<String> roles, String path) {
        try {
            return this.irm.getAllFiles(type, username, roles, path);
        }
        catch (RepositoryException e) {
            log.error("Get failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public void createUser(String username) {
        try {
            this.irm.createUser(username);
        }
        catch (RepositoryException e) {
            log.error("Create User Failed", (Throwable)e);
        }
    }

    @Override
    public void deleteFolder(String folder) {
        try {
            this.irm.deleteFolder(folder);
        }
        catch (RepositoryException e) {
            log.error("Delete User Failed", (Throwable)e);
        }
    }

    @Override
    public AclEntry getACL(String object, String username, List<String> roles) {
        return this.irm.getACL(object, username, roles);
    }

    @Override
    public void setACL(String object, String acl, String username, List<String> roles) {
        try {
            this.irm.setACL(object, acl, username, roles);
        }
        catch (RepositoryException e) {
            log.error("Set ACL Failed", (Throwable)e);
        }
    }

    @Override
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Override
    public List<MondrianSchema> getInternalFilesOfFileType(String type) {
        try {
            return this.irm.getInternalFilesOfFileType(type);
        }
        catch (RepositoryException e) {
            log.error("Get internal file failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public void createFileMixin(String type) throws RepositoryException {
        this.irm.createFileMixin(type);
    }

    @Override
    public byte[] exportRepository() {
        try {
            return this.irm.exportRepository();
        }
        catch (RepositoryException e) {
            log.error("could not export repository", (Throwable)e);
        }
        catch (IOException e) {
            log.error("could not export repository IO issue", (Throwable)e);
        }
        return null;
    }

    @Override
    public void restoreRepository(byte[] data) {
        try {
            this.irm.restoreRepository(data);
        }
        catch (Exception e) {
            log.error("Could not restore export", (Throwable)e);
        }
    }

    @Override
    public boolean hasHomeDirectory(String name) {
        try {
            Object eturn = this.irm.getHomeFolder(name);
            return eturn != null;
        }
        catch (PathNotFoundException e) {
            return false;
        }
        catch (RepositoryException e) {
            log.error("could not get home directory");
            return false;
        }
    }

    @Override
    public void restoreLegacyFiles(byte[] data) {
        LegacyImporterImpl l = new LegacyImporterImpl(null);
        l.importLegacyReports(this.irm, data);
    }

    public Object getRepository() {
        return this.irm.getRepositoryObject();
    }

    public void setConfigurationpath(String configurationpath) {
        this.configurationpath = configurationpath;
    }

    public String getConfigurationpath() {
        return this.configurationpath;
    }

    @Override
    public void setDatadir(String datadir) {
        this.datadir = datadir = datadir.replaceFirst(":", ":/");
    }

    @Override
    public String getDatadir() {
        if (this.type.equals("classpath")) {
            if (this.workspaces) {
                try {
                    if (this.getSession().getAttribute(ORBIS_WORKSPACE_DIR) != null) {
                        String workspace = (String)this.getSession().getAttribute(ORBIS_WORKSPACE_DIR);
                        if (!workspace.equals("")) {
                            workspace = this.cleanse(workspace);
                        }
                        log.debug("Workspace directory set to:" + this.datadir + workspace);
                        return this.cleanse(this.datadir) + workspace;
                    }
                    log.debug("Workspace directory set to:" + this.datadir + "unknown/");
                    return this.cleanse(this.datadir) + "unknown/";
                }
                catch (Exception e) {
                    return this.cleanse(this.datadir) + "unknown/";
                }
            }
            return this.cleanse(this.datadir);
        }
        return "/";
    }

    private String getCookieUsername() {
        String cookieUsername = null;
        HttpSession session = this.getSession();
        if (session != null && this.workspaces && session.getAttribute(SAIKU_AUTH_PRINCIPAL) != null) {
            cookieUsername = (String)session.getAttribute(SAIKU_AUTH_PRINCIPAL);
        }
        if (cookieUsername != null && cookieUsername.trim().length() == 0) {
            cookieUsername = null;
        }
        return cookieUsername;
    }

    private String getworkspacedir() {
        try {
            if (this.workspaces && this.getSession().getAttribute(ORBIS_WORKSPACE_DIR) != null) {
                String workspace = (String)this.getSession().getAttribute(ORBIS_WORKSPACE_DIR);
                if (!workspace.equals("")) {
                    workspace = this.cleanse(workspace);
                }
                log.debug("Workspace directory set to:" + workspace);
                return workspace;
            }
            if (this.workspaces) {
                log.debug("Workspace directory set to: unknown/");
                return "unknown/";
            }
            return "";
        }
        catch (Exception e) {
            return "unknown/";
        }
    }

    public String cleanse(String workspace) {
        workspace = workspace.replace("\\", "/");
        if (!(workspace = workspace.replaceAll("[/]+", "/")).endsWith("/")) {
            return workspace + "/";
        }
        return workspace;
    }

    @Override
    public void setFoodmartdir(String foodmartdir) {
        this.foodmartdir = foodmartdir;
    }

    @Override
    public String getFoodmartdir() {
        return this.foodmartdir;
    }

    @Override
    public void setFoodmartschema(String foodmartschema) {
        this.foodmartschema = foodmartschema;
    }

    @Override
    public String getFoodmartschema() {
        return this.foodmartschema;
    }

    @Override
    public void setFoodmarturl(String foodmarturl) {
        this.foodmarturl = foodmarturl;
    }

    @Override
    public String getFoodmarturl() {
        return this.foodmarturl;
    }

    @Override
    public String getEarthquakeUrl() {
        return this.earthquakeurl;
    }

    @Override
    public String getEarthquakeDir() {
        return this.earthquakedir;
    }

    @Override
    public String getEarthquakeSchema() {
        return this.earthquakeschema;
    }

    @Override
    public void setEarthquakeUrl(String earthquakeurl) {
        this.earthquakeurl = earthquakeurl;
    }

    @Override
    public void setEarthquakeDir(String earthquakedir) {
        this.earthquakedir = earthquakedir;
    }

    @Override
    public void setEarthquakeSchema(String earthquakeschema) {
        this.earthquakeschema = earthquakeschema;
    }

    @Override
    public void setExternalPropertiesFile(String file) {
        this.externalparameters = file;
    }

    public void setRepoPasswordProvider(PasswordProvider passwordProvider) {
        this.repopasswordprovider = passwordProvider;
    }

    public PasswordProvider getRepopasswordprovider() {
        return this.repopasswordprovider;
    }

    public void setOldRepoPassword(String password) {
        this.oldpassword = password;
    }

    public String getOldRepopassword() {
        return this.oldpassword;
    }

    public void setDefaultRole(String defaultRole) {
        this.defaultRole = defaultRole;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    private String getCSVJson(boolean file, String name, String path) {
        path = path.replace("\\", "/");
        path = path.replaceAll("[/]+", "/");
        if (!file) {
            String p = "directory: '" + path + "'\n";
            return "{\nversion: '1.0',\ndefaultSchema: '" + name + "',\nschemas: [\n{\nname: '" + name + "',\ntype: 'custom',\nfactory: 'org.apache.calcite.adapter.csv.CsvSchemaFactory',\noperand: {\n" + p + "}\n}\n]\n}";
        }
        String p = "file: '" + path + "',";
        return "{\nversion: '1.0',\ndefaultSchema: '" + name + "',\nschemas: [\n{\nname: '" + name + "',\ntables:[{\nname: '" + name + "1',\ntype: 'custom',\nfactory: 'org.apache.calcite.adapter.csv.CsvTableFactory',\noperand: {\n" + p + "flavor: 'scannable'\n}\n}]}\n]\n}";
    }

    public HttpSession getSession() {
        return this.sessionRegistry.getSession();
    }

    public void setSessionRegistry(ScopedRepo sessionRegistry) {
        this.sessionRegistry = sessionRegistry;
    }

    public void setWorkspaces(String workspaces) {
        this.workspaces = Boolean.parseBoolean(workspaces);
    }

    @Override
    public List<JujuSource> getJujuDatasources() {
        LegacyImporterImpl l = new LegacyImporterImpl(null);
        return l.importJujuDatasources();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    private void loadDatasources(Properties ext) {
        this.datasources.clear();
        List<DataSource> exporteddatasources = null;
        try {
            exporteddatasources = this.irm.getAllDataSources();
        }
        catch (RepositoryException e1) {
            log.error("Could not export data sources", (Throwable)e1);
        }
        if (exporteddatasources != null) {
            block4: for (int i = 0; i < exporteddatasources.size(); ++i) {
                DataSource file = exporteddatasources.get(i);
                try {
                    if (file.getName() == null || file.getType() == null) continue;
                    SaikuDatasource.Type t = SaikuDatasource.Type.valueOf(file.getType().toUpperCase());
                    SaikuDatasource ds = new SaikuDatasource(file.getName(), t, this.setupDataSourceProperties(file, ext));
                    if (this.sessionUsername != null && file.getOwners() != null) {
                        if (file.getOwners().trim().length() > 0 && this.sessionUsername.trim().length() > 0) {
                            String[] owners;
                            for (String owner : owners = file.getOwners().split(",")) {
                                if (!owner.trim().equalsIgnoreCase(this.sessionUsername.trim())) continue;
                                this.datasources.put(file.getName(), ds);
                                continue block4;
                            }
                            continue;
                        }
                        this.datasources.put(file.getName(), ds);
                        continue;
                    }
                    this.datasources.put(file.getName(), ds);
                    continue;
                }
                catch (Exception e) {
                    log.error("Failed to add datasource", (Throwable)e);
                }
            }
        }
    }

    private Properties setupDataSourceProperties(DataSource file, Properties ext) {
        String p;
        Properties props = new Properties();
        if (file.getDriver() != null) {
            props.put("driver", file.getDriver());
        } else if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".driver")) {
            p = ext.getProperty("datasource." + file.getPropertyKey() + ".driver");
            props.put("driver", p);
        }
        if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".location")) {
            p = ext.getProperty("datasource." + file.getPropertyKey() + ".location");
            if (ext.containsKey("datasource." + file.getPropertyKey() + ".schemaoverride")) {
                String[] spl = p.split(";");
                spl[1] = "Catalog=mondrian://" + file.getSchema();
                StringBuilder sb = new StringBuilder();
                for (String str : spl) {
                    sb.append(str + ";");
                }
                props.put("location", sb.toString());
            } else {
                props.put("location", p);
            }
        } else if (file.getLocation() != null) {
            props.put("location", file.getLocation());
        }
        if (file.getUsername() != null && file.getPropertyKey() == null) {
            props.put("username", file.getUsername());
        } else if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".username")) {
            p = ext.getProperty("datasource." + file.getPropertyKey() + ".username");
            props.put("username", p);
        }
        if (file.getPassword() != null && file.getPropertyKey() == null) {
            props.put("password", file.getPassword());
        } else if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".password")) {
            p = ext.getProperty("datasource." + file.getPropertyKey() + ".password");
            props.put("password", p);
        }
        if (file.getPath() != null) {
            props.put("path", file.getPath());
        } else if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".path")) {
            p = ext.getProperty("datasource." + file.getPropertyKey() + ".path");
            props.put("path", p);
        }
        if (file.getId() != null) {
            props.put("id", file.getId());
        }
        if (file.getOwners() != null) {
            props.put("owners", file.getOwners());
        }
        if (file.getSecurityenabled() != null) {
            props.put("security.enabled", file.getSecurityenabled());
        } else if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".security.enabled")) {
            p = ext.getProperty("datasource." + file.getPropertyKey() + ".security.enabled");
            props.put("security.enabled", p);
        }
        if (file.getSecuritytype() != null) {
            props.put("security.type", file.getSecuritytype());
        } else if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".security.type")) {
            p = ext.getProperty("datasource." + file.getPropertyKey() + ".security.type");
            props.put("security.type", p);
        }
        if (file.getSecuritymapping() != null) {
            props.put("security.mapping", file.getSecuritymapping());
        } else if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".security.mapping")) {
            p = ext.getProperty("datasource." + file.getPropertyKey() + ".security.mapping");
            props.put("security.mapping", p);
        }
        if (file.getAdvanced() != null) {
            props.put("advanced", file.getAdvanced());
        }
        if (file.getCsv() != null) {
            props.put("csv", file.getCsv());
        }
        if (file.getEnabled() != null) {
            props.put("enabled", file.getEnabled());
        }
        if (file.getPropertyKey() != null) {
            props.put("propertykey", file.getPropertyKey());
        }
        return props;
    }
}

