/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.util.formatter;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.saiku.olap.util.formatter.CellSetFormatter;
import org.saiku.olap.util.formatter.FlattenedCellSetFormatter;
import org.saiku.olap.util.formatter.HierarchicalCellSetFormatter;
import org.saiku.olap.util.formatter.ICellSetFormatter;
import org.saiku.service.olap.ThinQueryService;
import org.saiku.service.util.exception.SaikuServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellSetFormatterFactory {
    private static final Logger log = LoggerFactory.getLogger(ThinQueryService.class);
    private Map<String, String> formatters = new HashMap<String, String>();
    private String defaultFormatter = FlattenedCellSetFormatter.class.getName();

    public void setFormatters(Map<String, String> formatters) {
        this.formatters = formatters;
    }

    public void setDefaultFormatter(String clazz) {
        this.defaultFormatter = clazz;
    }

    public CellSetFormatterFactory() {
        this.formatters.put("flattened", FlattenedCellSetFormatter.class.getName());
        this.formatters.put("hierarchical", HierarchicalCellSetFormatter.class.getName());
        this.formatters.put("flat", CellSetFormatter.class.getName());
    }

    public ICellSetFormatter forName(String name) {
        return this.create(name, this.defaultFormatter);
    }

    private ICellSetFormatter create(String name, String defaultFormatter) {
        String clazzName = StringUtils.isBlank((String)name) || !this.formatters.containsKey(name) ? defaultFormatter : this.formatters.get(name);
        try {
            Class<?> clazz = Class.forName(clazzName);
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            return (ICellSetFormatter)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.error("Error creating CellSetFormatter \"" + clazzName + "\"", (Throwable)e);
            throw new SaikuServiceException("Error creating cellsetformatter for class: " + clazzName, e);
        }
    }
}

