/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.datasources.connection.encrypt;

import org.saiku.datasources.connection.encrypt.Des;

public class CryptoUtil {
    private static final byte[] defaultKey1 = new byte[]{-109, -87, 15, -76, 87, 17, -115, 44};
    private static final byte[] defaultKey2 = new byte[]{117, 44, -12, 92, 117, 21, -58, -93};

    public static String encrypt(String text) {
        try {
            if (text.length() == 0) {
                return text;
            }
            int length = text.getBytes("UTF8").length + 1;
            if (length % 8 != 0) {
                length = length / 8 * 8 + 8;
            }
            byte[] source = text.getBytes("UTF8");
            byte[] digest = new byte[length];
            System.arraycopy(source, 0, digest, 0, source.length);
            Des des = new Des();
            des.SetKey(true, defaultKey1, defaultKey2);
            des.Crypt(digest);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                int temp = digest[i] & 0xFF;
                if (temp < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(temp));
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decrypt(String encrypted) {
        try {
            if (encrypted.length() == 0) {
                return encrypted;
            }
            if (encrypted.length() % 2 != 0) {
                throw new IllegalArgumentException("Cannot decrypt the input length has to be multiple of 2:" + encrypted);
            }
            int len = encrypted.length() / 2;
            byte[] digest = new byte[len];
            for (int i = 0; i < digest.length; ++i) {
                digest[i] = (byte)Integer.parseInt(encrypted.substring(i * 2, i * 2 + 2), 16);
            }
            Des des = new Des();
            des.SetKey(false, defaultKey1, defaultKey2);
            des.Crypt(digest);
            int finalLen = 0;
            for (int i = 0; i < digest.length; ++i) {
                if (digest[i] == 0) continue;
                finalLen = i + 1;
            }
            return new String(digest, 0, finalLen, "UTF8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String encodePassword(String rawPass) {
        if (rawPass.length() == 0) {
            return rawPass;
        }
        int length = rawPass.length() + 1;
        if (length % 8 != 0) {
            length = length / 8 * 8 + 8;
        }
        byte[] source = rawPass.getBytes();
        byte[] digest = new byte[length];
        System.arraycopy(source, 0, digest, 0, source.length);
        Des des = new Des();
        des.SetKey(true, defaultKey1, defaultKey2);
        des.Crypt(digest);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int temp = digest[i] & 0xFF;
            if (temp < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(temp));
        }
        return sb.toString();
    }

    public static boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        String pass1 = "" + encPass;
        String pass2 = CryptoUtil.encodePassword(rawPass);
        return pass1.equals(pass2);
    }

    public static void main(String[] args) throws Exception {
        String db = "63cb6745f7b4324f";
        System.out.println(CryptoUtil.decrypt(db));
    }
}

