/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.examples.formula;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.ss.formula.OperationEvaluationContext;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.FreeRefFunction;
import org.apache.poi.ss.formula.udf.UDFFinder;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SettingExternalFunction {
    public static void main(String[] args) throws IOException {
        try (XSSFWorkbook wb = new XSSFWorkbook();){
            wb.addToolPack((UDFFinder)new BloombergAddIn());
            Sheet sheet = wb.createSheet();
            Row row = sheet.createRow(0);
            row.createCell(0).setCellFormula("BDP(\"GOOG Equity\",\"CHG_PCT_YTD\")/100");
            row.createCell(1).setCellFormula("BDH(\"goog us equity\",\"EBIT\",\"1/1/2005\",\"12/31/2009\",\"per=cy\",\"curr=USD\") ");
            row.createCell(2).setCellFormula("BDS(\"goog us equity\",\"top_20_holders_public_filings\") ");
            try (FileOutputStream out = new FileOutputStream("bloomberg-demo.xlsx");){
                wb.write((OutputStream)out);
            }
        }
    }

    public static class BloombergAddIn
    implements UDFFinder {
        private final Map<String, FreeRefFunction> _functionsByName;

        public BloombergAddIn() {
            FreeRefFunction NA = new FreeRefFunction(){

                public ValueEval evaluate(ValueEval[] args, OperationEvaluationContext ec) {
                    return ErrorEval.NA;
                }
            };
            this._functionsByName = new HashMap<String, FreeRefFunction>();
            this._functionsByName.put("BDP", NA);
            this._functionsByName.put("BDH", NA);
            this._functionsByName.put("BDS", NA);
        }

        public FreeRefFunction findFunction(String name) {
            return this._functionsByName.get(name.toUpperCase(Locale.ROOT));
        }
    }
}

