/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.util;

import java.util.ArrayList;

public class PlGeneratorUtil {
    public static int[] parseExternalIndex(String index) {
        int[] result = PlGeneratorUtil.parseIndex(index, -1);
        return result;
    }

    public static int[] parseIndex(String index, int offset) {
        if (index == null) {
            throw new IllegalArgumentException("Ung\u00fcltiger Index (null).");
        }
        ArrayList<String> indizes = new ArrayList<String>();
        StringBuilder indexBuffer = new StringBuilder();
        boolean inBrackets = false;
        int len = index.length();
        block6: for (int i = 0; i < len; ++i) {
            char character = index.charAt(i);
            switch (character) {
                case '[': {
                    if (inBrackets) {
                        throw new IllegalArgumentException("Ung\u00fcltiger Index '" + index + "' (verschachtelte Klammerung).");
                    }
                    inBrackets = true;
                    indexBuffer.setLength(0);
                    continue block6;
                }
                case ']': {
                    if (!inBrackets) {
                        throw new IllegalArgumentException("Ung\u00fcltiger Index '" + index + "' (schlie\u00dfende Klammer ohne \u00f6ffnende Klammer).");
                    }
                    if (indexBuffer.length() == 0) {
                        throw new IllegalArgumentException("Ung\u00fcltiger Index '" + index + "' (leere Klammerung).");
                    }
                    indizes.add(indexBuffer.toString());
                    inBrackets = false;
                    continue block6;
                }
                default: {
                    if (!inBrackets) {
                        throw new IllegalArgumentException("Ung\u00fcltiger Index '" + index + "' (fehlende Klammerung).");
                    }
                    indexBuffer.append(character);
                }
            }
        }
        if (inBrackets) {
            throw new IllegalArgumentException("Ung\u00fcltiger Index '" + index + "' (nicht geschlossene Klammer).");
        }
        if (indizes.isEmpty()) {
            throw new IllegalArgumentException("Ung\u00fcltiger Index '" + index + "' (keine Indizes).");
        }
        int[] result = new int[indizes.size()];
        int len2 = indizes.size();
        for (int i = 0; i < len2; ++i) {
            String indexStr = (String)indizes.get(i);
            try {
                result[i] = Integer.parseInt(indexStr) + offset;
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Ung\u00fcltiger Index '" + index + "' (ung\u00fcltiger Indexwert '" + indexStr + "').");
            }
        }
        return result;
    }
}

