/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.meta.MetaCustomInitwert;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class InitwerteParser
extends SubParser {
    private MetaCustomInitwert currentInitwert;

    public InitwerteParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
    }

    @Override
    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("topic".equalsIgnoreCase(this.superParser().parentElement()) && "http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "parameter".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    @Override
    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("parameter".equalsIgnoreCase(localName)) {
            this.enable();
            this.currentInitwert = new MetaCustomInitwert();
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("parameter".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    @Override
    public MetaElement object() {
        return this.currentInitwert;
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("parameter".equalsIgnoreCase(localName)) {
            String length;
            String name = atts.getValue("name");
            if (name == null) {
                throw new ILParseException("Fuer den Parameter (Initwert) ist kein Name definiert!");
            }
            this.currentInitwert.setName(name.trim());
            String type = atts.getValue("type");
            if (type == null) {
                throw new ILParseException("Fuer den Parameter (Initwert) " + name + " ist kein Typ definiert!");
            }
            this.currentInitwert.setTyp(Helper.typeByName(type.trim()));
            String nr = atts.getValue("nr");
            if (nr != null) {
                // empty if block
            }
            if ((length = atts.getValue("length")) == null) {
                this.currentInitwert.setLaenge(0L);
            } else {
                this.currentInitwert.setLaenge(Long.parseLong(length.trim()));
            }
            String dimensions = atts.getValue("dimensions");
            if (dimensions != null) {
                this.currentInitwert.setListe(true);
                this.currentInitwert.setDimension(dimensions);
                this.currentInitwert.setDimensions(Helper.parseDimensionSpec(dimensions));
            }
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        boolean handled = true;
        if (!"properties".equalsIgnoreCase(localName) && !"about".equalsIgnoreCase(localName)) {
            if ("description".equalsIgnoreCase(localName)) {
                String chars = this.superParser().charData().toString();
                this.currentInitwert.setBeschreibung(chars);
            } else {
                handled = false;
            }
        }
        return handled;
    }
}

