/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.interpreter;

import de.statspez.pleditor.generator.interpreter.ClassificationFactory;
import de.statspez.pleditor.generator.interpreter.InterpreterContext;
import de.statspez.pleditor.generator.interpreter.ProgramInterpreter;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaCustomAuspraegung;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaPLAuspraegung;
import de.statspez.pleditor.generator.runtime.Classification;
import de.statspez.pleditor.generator.runtime.ClassificationGroup;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeIterator;
import de.statspez.pleditor.generator.runtime.RangeSeries;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueFactory;
import java.util.HashMap;
import java.util.Iterator;

public class PlausiClassificationFactory
extends AbstractElementVisitor
implements ClassificationFactory {
    private HashMap classificationsByCode = new HashMap();
    private HashMap classificationsByValue = new HashMap();
    private ClassificationGroup currentClassificationGroup;
    private ProgramInterpreter programInterpreter = new ProgramInterpreter();
    private InterpreterContext context = new InterpreterContext(){

        @Override
        public boolean isVariableDeclared(String name) {
            return name.equals("myVal");
        }

        @Override
        public void setVariableValue(String name, int[] indicies, Value value) {
            PlausiClassificationFactory.this.currentMyVal = value;
        }
    };
    private Value currentMyVal;

    public PlausiClassificationFactory(MetaCustomPlausibilisierung plausi) {
        Iterator iter = plausi.getAuspraegungsgruppen();
        if (iter != null) {
            while (iter.hasNext()) {
                ((MetaElement)iter.next()).accept(this);
            }
        }
    }

    @Override
    public void registerClassificationGroup(String name, ClassificationGroup classificationGroup) {
        String reference = "#" + name;
        this.classificationsByCode.put(reference, this.currentClassificationGroup);
        this.classificationsByValue.put(reference, this.currentClassificationGroup);
        this.registerClassificationsRecursive(reference, reference, this.currentClassificationGroup);
    }

    @Override
    public boolean isClassificationRegistered(String reference) {
        return this.classificationsByCode.containsKey(reference) || this.classificationsByValue.containsKey(reference);
    }

    @Override
    public void visitAuspraegungsgruppe(MetaAuspraegungsgruppe auspraegungsgruppe) {
        this.currentClassificationGroup = new ClassificationGroup(ValueFactory.instance().valueFor(auspraegungsgruppe.getName()), ValueFactory.instance().valueFor(auspraegungsgruppe.getName()));
        Iterator iter = auspraegungsgruppe.getAuspraegungsComps().getAuspraegungen();
        if (iter != null) {
            while (iter.hasNext()) {
                ((MetaElement)iter.next()).accept(this);
            }
        }
        this.registerClassificationGroup(auspraegungsgruppe.getName(), this.currentClassificationGroup);
        this.currentClassificationGroup = null;
    }

    @Override
    public void visitPLAuspraegung(MetaPLAuspraegung auspraegung) {
        MetaCustomAuspraegung myClassi = (MetaCustomAuspraegung)auspraegung;
        this.programInterpreter.execute(myClassi.getKodeSpezifikation(), this.context);
        Value codeValue = this.currentMyVal;
        if (codeValue != null && codeValue instanceof RangeSeries) {
            try {
                RangeSeries rangeSeries = (RangeSeries)codeValue;
                Value singleRangeValue = null;
                PlausiRuntimeIterator iter = rangeSeries.iterator();
                if (iter.hasNext()) {
                    singleRangeValue = (Value)iter.next();
                }
                if (!iter.hasNext()) {
                    codeValue = singleRangeValue;
                }
            }
            catch (Exception e) {
                codeValue = this.currentMyVal;
            }
        }
        if (auspraegung.sizeOfAuspraegungen() > 0) {
            ClassificationGroup parentGroup = this.currentClassificationGroup;
            this.currentClassificationGroup = new ClassificationGroup(codeValue, ValueFactory.instance().valueFor(auspraegung.getName()));
            Iterator iter = auspraegung.getAuspraegungen();
            if (iter != null) {
                while (iter.hasNext()) {
                    ((MetaElement)iter.next()).accept(this);
                }
            }
            parentGroup.addClassfication(this.currentClassificationGroup);
            this.currentClassificationGroup = parentGroup;
        } else {
            this.currentClassificationGroup.addClassfication(new Classification(codeValue, ValueFactory.instance().valueFor(auspraegung.getName())));
        }
    }

    @Override
    public Value getClassificationByCode(String referenceByCode) {
        if (!this.isClassificationRegistered(referenceByCode)) {
            throw new RuntimeException("Die Auspr\u00e4gungsgruppe " + referenceByCode.substring(1) + " ist nicht definiert.");
        }
        return (Value)this.classificationsByCode.get(referenceByCode);
    }

    @Override
    public Classification getClassificationByValue(String referenceByValue) {
        if (!this.isClassificationRegistered(referenceByValue)) {
            throw new RuntimeException("Die Auspr\u00e4gungsgruppe " + referenceByValue.substring(1) + " ist nicht definiert.");
        }
        return (Classification)this.classificationsByValue.get(referenceByValue);
    }

    private void registerClassificationsRecursive(String referenceByCode, String referenceByValue, ClassificationGroup classificationGroup) {
        Iterator iter = classificationGroup.getClassifications();
        while (iter.hasNext()) {
            Classification classification = (Classification)iter.next();
            if (classification instanceof ClassificationGroup) {
                this.registerClassificationsRecursive(referenceByCode + "." + classification.code(), referenceByCode + ".'" + classification.value() + "'", (ClassificationGroup)classification);
            }
            this.classificationsByCode.put(referenceByCode + "." + classification.code(), classification);
            this.classificationsByValue.put(referenceByCode + ".'" + classification.value() + "'", classification);
        }
    }
}

