/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.common;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.common.DefaultMessageContext;

public class ElementMessageContext
extends DefaultMessageContext {
    private static final long serialVersionUID = 6067398444318310258L;
    public static final int TYPE_PRUEFUNG = 1;
    public static final int TYPE_ABLAUF = 2;
    public static final int TYPE_EIGENSCHAFT = 3;
    public static final int TYPE_FUNKTION = 4;
    public static final int TYPE_MERKMAL = 5;
    public static final int TYPE_THEMENBEREICH = 6;
    public static final int TYPE_MATERIAL_THEMENBEREICH = 7;
    public static final int TYPE_TBFELD = 8;
    public static final int TYPE_SDFMERKMALSGRUPPE = 9;
    public static final int TYPE_SDFAUSGABESATZ = 10;
    public static final int TYPE_MAPPINGELEMENT_QUELLE = 11;
    public static final int TYPE_MAPPINGELEMENT_ZIEL = 12;
    public static final int TYPE_MAPPING = 13;
    public static final int TYPE_SDFMAPPING = 14;
    public static final int TYPE_SDFTBMAPPING = 15;
    public static final int TYPE_DSB = 16;
    public static final int TYPE_SDFMERKMAL = 17;
    public static final int TYPE_LIEFERVORGABE = 18;
    protected int elementType = 0;
    protected String elementId = null;
    protected String elementName = null;
    protected int parentType = 0;
    protected String parentId = null;
    protected String parentName = null;
    protected String hint = null;

    public ElementMessageContext(int elementType, String elementId, String elementName, String hint) {
        super(ElementMessageContext.stringForType(elementType) + " " + elementName + (hint != null ? " " + hint : ""));
        this.elementType = elementType;
        this.elementId = elementId;
        this.elementName = elementName;
        this.hint = hint;
    }

    public ElementMessageContext(int elementType, String elementId, String elementName) {
        this(elementType, elementId, elementName, null);
    }

    public ElementMessageContext(int elementType, String elementId, String elementName, int parentType, String parentId, String parentName) {
        this(elementType, elementId, elementName, null);
        this.parentType = parentType;
        this.parentId = parentId;
        this.parentName = parentName;
    }

    public ElementMessageContext(int elementType, String elementId, String elementName, int parentType, String parentId, String parentName, String hint) {
        this(elementType, elementId, elementName, hint);
        this.parentType = parentType;
        this.parentId = parentId;
        this.parentName = parentName;
    }

    public int getElementType() {
        return this.elementType;
    }

    @Override
    public String toStringHTML(AbstractMessage message) {
        StringBuffer text = new StringBuffer();
        if (message != null) {
            boolean spalte;
            text.append(message.messageType());
            text.append(" (");
            text.append(ElementMessageContext.stringForType(this.elementType));
            text.append(" <a href=\"http://material/element?name=");
            text.append(this.elementName);
            text.append("&id=");
            text.append(this.elementId);
            text.append("&type=");
            text.append(ElementMessageContext.xmlStringForType(this.elementType));
            text.append("\">");
            text.append(this.elementName);
            text.append("</a>");
            if (ElementMessageContext.typeIsValid(this.parentType) && this.parentName != null) {
                text.append(" ");
                text.append(ElementMessageContext.stringForType(this.parentType));
                text.append(" ");
                text.append(this.parentName);
            }
            if (this.hint != null) {
                text.append(" ");
                text.append(this.hint);
            }
            text.append(")");
            text.append(": ");
            text.append(message.message());
            int aktLine = this.getLineForDisplay(message.line());
            boolean zeile = aktLine > -1;
            boolean bl = spalte = message.column() > -1;
            if (zeile || spalte) {
                text.append(" [");
            }
            if (zeile) {
                text.append("Zeile ");
                text.append(Integer.toString(aktLine));
            }
            if (zeile && spalte) {
                text.append(", ");
            }
            if (spalte) {
                text.append("Position ");
                text.append(Integer.toString(message.column()));
            }
            if (zeile || spalte) {
                text.append("]");
            }
        } else {
            text.append(" (");
            text.append(this.textContext);
            text.append(")");
            text.append(": Leere Fehlermeldung.");
        }
        return text.toString();
    }

    public static String stringForType(int id) {
        switch (id) {
            case 1: {
                return "Pr\u00fcfung";
            }
            case 2: {
                return "Ablauf";
            }
            case 3: {
                return "Eigenschaft";
            }
            case 4: {
                return "Funktion";
            }
            case 5: {
                return "Merkmal";
            }
            case 6: {
                return "Themenbereich";
            }
            case 7: {
                return "Material-Themenbereich";
            }
            case 8: {
                return "TB-Feld";
            }
            case 10: {
                return "Lieferdatenmodell";
            }
            case 9: {
                return "Merkmalsgruppe";
            }
            case 11: {
                return "Quellmappingregel des Mapping";
            }
            case 12: {
                return "Zielmappingregel des Mapping";
            }
            case 13: {
                return "Mapping";
            }
            case 14: {
                return "SDFMapping";
            }
            case 15: {
                return "SDFTBMapping";
            }
            case 16: {
                return "Datensatzbeschreibung";
            }
            case 17: {
                return "SDF-Merkmal";
            }
            case 18: {
                return "Liefervorgabe";
            }
        }
        return "Element";
    }

    public static String xmlStringForType(int id) {
        switch (id) {
            case 1: {
                return "check";
            }
            case 2: {
                return "flow";
            }
            case 3: {
                return "test";
            }
            case 4: {
                return "function";
            }
            case 5: {
                return "statisticVariable";
            }
            case 6: {
                return "topic";
            }
            case 7: {
                return "topic";
            }
            case 8: {
                return "field";
            }
            case 10: {
                return "outputDataModel";
            }
            case 9: {
                return "variableGroup";
            }
            case 11: {
                return "mapping";
            }
            case 12: {
                return "mapping";
            }
            case 13: {
                return "mapping";
            }
            case 14: {
                return "sdf-dsb-mapping";
            }
            case 15: {
                return "tb-sdf-mapping";
            }
            case 16: {
                return "dataSetType";
            }
            case 17: {
                return "variable";
            }
            case 18: {
                return "sdfRequirements";
            }
        }
        return "element";
    }

    public static boolean typeIsValid(int id) {
        switch (id) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
            case 10: {
                return true;
            }
            case 9: {
                return true;
            }
            case 11: {
                return true;
            }
            case 12: {
                return true;
            }
            case 13: {
                return true;
            }
            case 14: {
                return true;
            }
            case 15: {
                return true;
            }
            case 16: {
                return true;
            }
            case 17: {
                return true;
            }
            case 18: {
                return true;
            }
        }
        return false;
    }
}

