/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.js;

import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.js.CodegenContext;
import de.statspez.pleditor.generator.codegen.js.ErrorTextProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.js.ExternalFunctionProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.js.JavaScriptCodeGenerator;
import de.statspez.pleditor.generator.codegen.js.ProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.js.ReferenceFunctionProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLInitwert;
import de.statspez.pleditor.generator.meta.generated.MetaPLPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ThemenbereichCodeGenerator
extends JavaScriptCodeGenerator {
    private Scope scope;
    private List<String> initValues = new ArrayList<String>();

    public synchronized void generate(CodegenContext context, MetaThemenbereich themenbereich, Scope tbScope) {
        this.setCodegenContext(context);
        this.scope = tbScope;
        themenbereich.accept(this);
        this.out.flush();
        this.checkForErrors();
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich tb) {
        if (((MetaCustomThemenbereich)tb).referencedByErhebung()) {
            this.visitElements(tb.getFunktionen());
            this.visitElements(tb.getPruefungen());
            this.initValues.clear();
            this.visitElements(tb.getInitialisierungswerte());
            this.visitElements(tb.getFelder());
            this.visitElements(tb.getAblaeufe());
        }
    }

    @Override
    public void visitPLPruefung(MetaPLPruefung aPruefung) {
        ErrorTextProgramCodeGenerator errorTextCodeGen;
        MetaCustomPruefung pruefung = (MetaCustomPruefung)aPruefung;
        ProgramCodeGenerator codeGen = new ProgramCodeGenerator();
        codeGen.setOutput(this.out);
        codeGen.setIndentLevel(this.indentLevel());
        codeGen.setErrorContext(new ElementMessageContext(1, pruefung.getId(), pruefung.getName()));
        this.context.putContextInfo("programPerformsPlausiKey", new Boolean(true));
        codeGen.generate(this.context, pruefung.getMetaSpezifikation(), this.scope);
        this.context.putContextInfo("programPerformsPlausiKey", null);
        if (pruefung.getFehlerTextKurzProgram() != null || pruefung.getFehlerTextLangProgram() != null || pruefung.getKorrekturhinweisProgram() != null) {
            errorTextCodeGen = new ErrorTextProgramCodeGenerator();
            errorTextCodeGen.setOutput(this.out);
            errorTextCodeGen.setIndentLevel(this.indentLevel());
        } else {
            errorTextCodeGen = null;
        }
        this.indentNewLine();
        this.print("function ");
        this.print("err_");
        this.printContextAsPrefix();
        this.print(StringHelper.getEscapedName(pruefung.getName()));
        this.print("(");
        if (this.hasContext()) {
            this.print("ns");
        }
        this.print(")");
        this.openBlock();
        this.indentNewLine();
        this.print("var ");
        this.print("e");
        this.print(" = new PlausiError();");
        this.indentNewLine();
        this.print("e");
        this.print(".type = ");
        this.print(aPruefung.getPruefungsart());
        this.print(";");
        this.indentNewLine();
        this.print("e");
        this.print(".infoType = 0;");
        this.indentNewLine();
        this.print("e");
        this.print(".message = ");
        MetaProgram fehlerTextKurzProgram = this.context.getTextResource().getFehlertextKurzProgram(pruefung);
        if (fehlerTextKurzProgram != null) {
            errorTextCodeGen.generate(this.context, fehlerTextKurzProgram, this.scope);
        } else {
            String message = this.context.getTextResource().getFehlertextKurz(pruefung);
            if (message != null) {
                this.print("\"");
                this.print(StringHelper.getEscapedStringValue(message));
                this.print("\"");
            } else {
                this.print("null");
            }
        }
        this.print(";");
        this.indentNewLine();
        this.print("e");
        this.print(".description = ");
        MetaProgram fehlerTextLangProgram = this.context.getTextResource().getFehlertextLangProgram(pruefung);
        if (fehlerTextLangProgram != null) {
            errorTextCodeGen.generate(this.context, fehlerTextLangProgram, this.scope);
        } else {
            String description = this.context.getTextResource().getFehlertextLang(pruefung);
            if (description != null) {
                this.print("\"");
                this.print(StringHelper.getEscapedStringValue(description));
                this.print("\"");
            } else {
                this.print("null");
            }
        }
        this.print(";");
        this.indentNewLine();
        this.print("e");
        this.print(".correctionAdvice = ");
        MetaProgram korrekturhinweisProgram = this.context.getTextResource().getKorrekturhinweisProgram(pruefung);
        if (korrekturhinweisProgram != null) {
            errorTextCodeGen.generate(this.context, korrekturhinweisProgram, this.scope);
        } else {
            String correctionAdvice = this.context.getTextResource().getKorrekturhinweis(pruefung);
            if (correctionAdvice != null) {
                this.print("\"");
                this.print(StringHelper.getEscapedStringValue(correctionAdvice));
                this.print("\"");
            } else {
                this.print("null");
            }
        }
        this.print(";");
        if (pruefung.sizeOfHauptBezugsfeld() > 0) {
            this.indentNewLine();
            this.print("e");
            this.print(".field = ");
            if (this.hasContext()) {
                this.print("ns");
                this.print(" + ");
            }
            this.print("\"");
            if (this.hasContext()) {
                this.print(".");
            }
            Iterator iter = pruefung.getHauptBezugsfeld();
            while (iter.hasNext()) {
                MetaTBFeld field = (MetaTBFeld)iter.next();
                this.print(field.getName());
                if (!iter.hasNext()) continue;
                this.print(".");
            }
            this.print("\";");
            this.indentNewLine();
            this.print("e");
            this.print(".id = ");
            this.print("e");
            this.print(".field + \"#");
            this.print(pruefung.getName());
            this.print("\";");
        } else {
            this.indentNewLine();
            this.print("e");
            this.print(".id = \"#");
            this.print(pruefung.getName());
            this.print("\";");
        }
        this.indentNewLine();
        this.print("e");
        this.print(".referencedFields = referencedFields;");
        this.indentNewLine();
        this.print("referencedFields = null;");
        this.indentNewLine();
        this.print("return ");
        this.print("e");
        this.print(";");
        this.closeBlock();
    }

    @Override
    public void visitPLInitwert(MetaPLInitwert initwert) {
        this.initValues.add(initwert.getName());
    }

    @Override
    public void visitTBFeld(MetaTBFeld feld) {
        String korrekturHinweis;
        String fehlerTextLang;
        MetaCustomTBFeld f = (MetaCustomTBFeld)feld;
        String fehlerTextKurz = this.context.getTextResource().getFehlertextKurz(f);
        if (fehlerTextKurz != null && fehlerTextKurz.length() > 0) {
            this.printErrorTextProgram(f.getName(), fehlerTextKurz, this.context.getTextResource().getFehlertextKurzProgram(f), "msg_");
        }
        if ((fehlerTextLang = this.context.getTextResource().getFehlertextLang(f)) != null && fehlerTextLang.length() > 0) {
            this.printErrorTextProgram(f.getName(), fehlerTextLang, this.context.getTextResource().getFehlertextLangProgram(f), "dsc_");
        }
        if ((korrekturHinweis = this.context.getTextResource().getKorrekturhinweis(f)) != null && korrekturHinweis.length() > 0) {
            this.printErrorTextProgram(f.getName(), korrekturHinweis, this.context.getTextResource().getKorrekturhinweisProgram(f), "adv_");
        }
    }

    @Override
    public void visitPLAblauf(MetaPLAblauf ablauf) {
        MetaCustomAblauf a = (MetaCustomAblauf)ablauf;
        ProgramCodeGenerator prgGen = new ProgramCodeGenerator();
        prgGen.setOutput(this.out);
        prgGen.setIndentLevel(this.indentLevel());
        prgGen.setErrorContext(new ElementMessageContext(2, a.getId(), a.getName(), 6, a.getThemenbereich().getId(), a.getThemenbereich().getName()));
        this.context.putContextInfo("programPerformsPlausiKey", new Boolean(true));
        this.context.putContextInfo("programInitValuesKey", this.initValues);
        prgGen.generate(this.context, a.getMetaSpezifikation(), this.scope);
        this.context.putContextInfo("programPerformsPlausiKey", null);
        this.context.putContextInfo("programInitValuesKey", null);
    }

    @Override
    public void visitPLFunktion(MetaPLFunktion funktion) {
        MetaCustomFunktion f = (MetaCustomFunktion)funktion;
        String art = f.getArt();
        if ("extern".equals(art)) {
            ExternalFunctionProgramCodeGenerator extFunctionProgramGenerator = new ExternalFunctionProgramCodeGenerator(this.context);
            extFunctionProgramGenerator.setOutput(this.out);
            extFunctionProgramGenerator.setIndentLevel(this.indentLevel());
            f.accept(extFunctionProgramGenerator);
        } else if ("ref".equals(art)) {
            ReferenceFunctionProgramCodeGenerator refFunctionProgramGenerator = new ReferenceFunctionProgramCodeGenerator(this.context);
            refFunctionProgramGenerator.setOutput(this.out);
            refFunctionProgramGenerator.setIndentLevel(this.indentLevel());
            f.accept(refFunctionProgramGenerator);
        } else {
            ProgramCodeGenerator prgGen = new ProgramCodeGenerator();
            prgGen.setOutput(this.out);
            prgGen.setIndentLevel(this.indentLevel());
            int contextType = 4;
            if (f.getFunctionType() == 1) {
                contextType = 3;
            }
            prgGen.setErrorContext(new ElementMessageContext(contextType, f.getId(), f.getName(), 6, f.getThemenbereich().getId(), f.getThemenbereich().getName()));
            prgGen.generate(this.context, f.getMetaSpezifikation(), this.scope);
        }
        String escapedName = StringHelper.getEscapedName(f.getName());
        this.indentNewLine();
        this.print("topicFunctions[\"");
        if (this.hasContext()) {
            this.printContextAsPrefix();
        }
        this.print(escapedName);
        this.print("\"] = ");
        this.print("prg_");
        if (this.hasContext()) {
            this.printContextAsPrefix();
        }
        this.print(escapedName);
        this.print(";");
    }

    private void printErrorTextProgram(String fieldName, String errorText, MetaProgram program, String functionNamePrefix) {
        ErrorTextProgramCodeGenerator errorTextCodeGen = new ErrorTextProgramCodeGenerator();
        errorTextCodeGen.setOutput(this.out);
        errorTextCodeGen.setIndentLevel(this.indentLevel());
        this.indentNewLine();
        this.print("function ");
        this.print(functionNamePrefix);
        this.printContextAsPrefix();
        this.print(StringHelper.getEscapedName(fieldName));
        this.print("(");
        this.print("f");
        this.print(")");
        this.openBlock();
        if (this.hasContext()) {
            this.indentNewLine();
            this.print("var ");
            this.print("ns");
            this.print(" = ");
            this.print("f");
            this.print(".substring(0, ");
            this.print("f");
            this.print(".lastIndexOf(\".\"));");
        }
        this.indentNewLine();
        this.print("return ");
        if (program != null) {
            errorTextCodeGen.generate(this.context, program, this.scope);
        } else {
            this.print("\"");
            this.print(StringHelper.getEscapedStringValue(errorText));
            this.print("\"");
        }
        this.print(";");
        this.closeBlock();
    }
}

