/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java.mapping.util;

import de.statspez.pleditor.generator.codegen.java.mapping.util.ConstructorGenerator;
import de.statspez.pleditor.generator.codegen.support.DSBStructureBuilder;
import de.statspez.pleditor.generator.meta.MetaCustomEinzelfeld;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaDsbObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaEinzelfeld;
import de.statspez.pleditor.generator.meta.generated.MetaSatzart;
import java.io.PrintWriter;
import java.util.Iterator;

public class DSBConstructorGenerator
extends ConstructorGenerator {
    public DSBConstructorGenerator(PrintWriter out) {
        this.setOutput(out);
        this.prefix = "DSB_";
    }

    @Override
    public void generate(Object anObject, String className) {
        this.generate(anObject, className, "public");
    }

    public void generate(Object anObject, String className, String visible) {
        this.printConstructor(className, visible);
        if (anObject instanceof MetaDsbObjekt) {
            ((MetaDsbObjekt)anObject).accept(this);
        }
        if (anObject instanceof MetaEinzelfeld) {
            this.visitElements(((MetaCustomEinzelfeld)anObject).getCompList());
        }
        if (anObject instanceof MetaSatzart) {
            this.visitElementsStufe1(((MetaSatzart)anObject).getFelder());
        }
        this.closeBlock();
    }

    @Override
    public void visitDsbObjekt(MetaDsbObjekt anObject) {
        this.visitElementsStufe1(anObject.getComps().getCompList());
        this.visitElements(anObject.getComps().getSatzList());
    }

    @Override
    public void visitEinzelfeld(MetaEinzelfeld anObject) {
        int typ = 3;
        if (DSBStructureBuilder.istStrukturTyp(anObject.getTyp())) {
            int[] einzelfeldDimension = new int[]{0};
            if (anObject.getTyp().equals("Str")) {
                int[] dimension = new int[]{0};
                einzelfeldDimension = dimension;
                String type_name = "DSB_" + this.getStructurePrefix() + anObject.getName();
                this.printFieldInitialization(type_name, anObject.getName(), typ);
            } else if (anObject.getTyp().equals("Wfgr")) {
                int wiederholungen = 0;
                int index = anObject.getTypIntern().indexOf(32);
                if (index > 0) {
                    String whStr = anObject.getTypIntern().substring(0, index);
                    wiederholungen = Integer.parseInt(whStr);
                }
                int[] dimension = new int[]{wiederholungen};
                einzelfeldDimension = dimension;
                this.structurInitilization(anObject.getName(), 0, einzelfeldDimension);
            } else if (anObject.getTyp().equals("VKWG")) {
                int[] dimension = new int[]{-1};
                einzelfeldDimension = dimension;
                this.structurInitilization(anObject.getName(), 0, einzelfeldDimension);
            }
        } else {
            this.printFieldInitialization("FeatureVariable", anObject.getName(), typ);
        }
    }

    @Override
    public void visitSatzart(MetaSatzart anObject) {
        int[] einzelfeldDimension = new int[]{-1};
        this.structurInitilization(anObject.getName(), 7, einzelfeldDimension);
    }

    protected void visitElementsStufe1(Iterator it) {
        assert (it != null) : "Iterator ist null";
        while (it.hasNext()) {
            MetaElement e = (MetaElement)it.next();
            if (e == null || !(e instanceof MetaCustomEinzelfeld) || ((MetaCustomEinzelfeld)e).getStufenNr() != 1) continue;
            e.accept(this);
        }
    }
}

