/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.mdx.parser.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.mdx.ParseRegion;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.parser.MdxParseException;
import org.olap4j.mdx.parser.MdxParser;
import org.olap4j.mdx.parser.impl.MdxParserImpl;
import org.olap4j.mdx.parser.impl.ParseException;
import org.olap4j.mdx.parser.impl.Token;
import org.olap4j.mdx.parser.impl.TokenMgrError;

public class DefaultMdxParserImpl
implements MdxParser {
    private boolean debug = false;
    private final FunTable funTable = new FunTable(){

        public boolean isProperty(String s) {
            return s.equalsIgnoreCase("CHILDREN");
        }
    };

    public SelectNode parseSelect(String mdx) {
        try {
            return new MdxParserImpl(mdx, this.debug, this.funTable, false).selectStatement();
        }
        catch (TokenMgrError e) {
            throw this.convertException(mdx, e);
        }
        catch (ParseException e) {
            throw this.convertException(mdx, e);
        }
    }

    public ParseTreeNode parseExpression(String mdx) {
        try {
            return new MdxParserImpl(mdx, this.debug, this.funTable, false).expression();
        }
        catch (TokenMgrError e) {
            throw this.convertException(mdx, e);
        }
        catch (ParseException e) {
            throw this.convertException(mdx, e);
        }
    }

    private RuntimeException convertException(String queryString, Throwable pe) {
        ParseRegion parseRegion = null;
        String message = null;
        if (pe instanceof TokenMgrError) {
            Pattern pattern = Pattern.compile("Lexical error at line ([0-9]+), column ([0-9]+)\\. .*");
            Matcher matcher = pattern.matcher(pe.getMessage());
            if (matcher.matches()) {
                Olap4jUtil.discard(matcher);
                int line = Integer.parseInt(matcher.group(1));
                int column = Integer.parseInt(matcher.group(2));
                parseRegion = new ParseRegion(line, column);
                message = pe.getMessage();
            }
        } else if (pe instanceof ParseException && pe.getMessage().startsWith("Encountered ")) {
            Token errorToken = ((ParseException)pe).currentToken.next;
            parseRegion = new ParseRegion(errorToken.beginLine, errorToken.beginColumn, errorToken.endLine, errorToken.endColumn);
            message = "Syntax error at line " + parseRegion.getStartLine() + ", column " + parseRegion.getStartColumn() + ", token '" + errorToken.image + "'";
        }
        Throwable e = parseRegion != null ? new MdxParseException(parseRegion, message) : pe;
        throw new RuntimeException("Error while parsing MDX statement '" + queryString + "'", e);
    }

    static interface FunTable {
        public boolean isProperty(String var1);
    }
}

