/*
 * Decompiled with CFR 0.152.
 */
package mondrian.tui;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHttpServletRequest
implements HttpServletRequest {
    public static String AUTHORIZATION = "Authorization";
    public static final String DATE_FORMAT_HEADER = "EEE, d MMM yyyy HH:mm:ss Z";
    private HttpSession session;
    private Map<String, String[]> parameters;
    private Map<String, RequestDispatcher> requestDispatchers;
    private List<Locale> locales;
    private String serverName;
    private String charEncoding;
    private String method;
    private String pathInfo;
    private String pathTranslated;
    private String contextPath;
    private String queryString;
    private String remoteUser;
    private String requestedSessionId;
    private String servletPath;
    private String scheme;
    private String localName;
    private String localAddr;
    private String authType;
    private String protocol;
    private String schema;
    private Principal principal;
    private List<Cookie> cookies;
    private boolean requestedSessionIdIsFromCookie;
    private int remotePort;
    private int localPort;
    private int serverPort;
    private String remoteAddr;
    private String remoteHost;
    private Map<String, Object> attributes;
    private final LinkedHashMap<String, List<String>> headers;
    private boolean sessionCreated;
    private String requestedURI;
    private StringBuffer requestUrl;
    private String bodyContent;
    private Map<String, Boolean> roles;

    public MockHttpServletRequest() {
        this(new byte[0]);
    }

    public MockHttpServletRequest(byte[] bytes) {
        this(new String(bytes));
    }

    public MockHttpServletRequest(String bodyContent) {
        this.bodyContent = bodyContent;
        this.attributes = Collections.emptyMap();
        this.headers = new LinkedHashMap();
        this.requestDispatchers = new HashMap<String, RequestDispatcher>();
        this.parameters = new HashMap<String, String[]>();
        this.cookies = new ArrayList<Cookie>();
        this.locales = new ArrayList<Locale>();
        this.roles = new HashMap<String, Boolean>();
        this.requestedSessionIdIsFromCookie = true;
        this.method = "GET";
        this.protocol = "HTTP/1.1";
        this.serverName = "localhost";
        this.serverPort = 8080;
        this.scheme = "http";
        this.remoteHost = "localhost";
        this.remoteAddr = "127.0.0.1";
        this.localAddr = "127.0.0.1";
        this.localName = "localhost";
        this.localPort = 8080;
        this.remotePort = 5000;
        this.sessionCreated = false;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        return this.charEncoding;
    }

    public void setCharacterEncoding(String charEncoding) throws UnsupportedEncodingException {
        this.charEncoding = charEncoding;
    }

    public int getContentLength() {
        return this.getIntHeader("Content-Length");
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public ServletInputStream getInputStream() throws IOException {
        return new MockServletInputStream(this.bodyContent.getBytes());
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        return null != values && 0 < values.length ? values[0] : null;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getScheme() {
        return this.schema;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public BufferedReader getReader() throws IOException {
        return this.bodyContent == null ? null : new BufferedReader(new StringReader(this.bodyContent));
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setAttribute(String name, Object obj) {
        if (this.attributes == Collections.EMPTY_MAP) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, obj);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Locale getLocale() {
        return this.locales.size() < 1 ? Locale.getDefault() : this.locales.get(0);
    }

    public Enumeration getLocales() {
        return Collections.enumeration(this.locales);
    }

    public boolean isSecure() {
        String scheme = this.getScheme();
        return scheme == null ? false : scheme.equals("https");
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        RequestDispatcher dispatcher = this.requestDispatchers.get(path);
        if (dispatcher == null) {
            dispatcher = new MockRequestDispatcher();
            this.setRequestDispatcher(path, dispatcher);
        }
        return dispatcher;
    }

    public String getRealPath(String path) {
        HttpSession session = this.getSession();
        return session == null ? null : session.getServletContext().getRealPath(path);
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public String getAuthType() {
        return this.authType;
    }

    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public long getDateHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1L;
        }
        try {
            Date dateValue = new SimpleDateFormat(DATE_FORMAT_HEADER, Locale.US).parse(header);
            return dateValue.getTime();
        }
        catch (ParseException exc) {
            throw new IllegalArgumentException(exc.getMessage());
        }
    }

    public String getHeader(String name) {
        List<String> headerList = this.headers.get(name);
        return headerList == null || headerList.size() == 0 ? null : headerList.get(0);
    }

    public Enumeration getHeaders(String name) {
        List<String> headerList = this.headers.get(name);
        return headerList == null ? null : Collections.enumeration(headerList);
    }

    public Enumeration getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public int getIntHeader(String name) {
        String header = this.getHeader(name);
        return header == null ? -1 : Integer.parseInt(header);
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public boolean isUserInRole(String role) {
        return this.roles.get(role);
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public String getRequestedSessionId() {
        HttpSession session = this.getSession();
        return session == null ? null : session.getId();
    }

    public String getRequestURI() {
        return this.requestedURI;
    }

    public StringBuffer getRequestURL() {
        return this.requestUrl;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession(boolean create) {
        if (!create && !this.sessionCreated) {
            return null;
        }
        return this.getSession();
    }

    public HttpSession getSession() {
        this.sessionCreated = true;
        return this.session;
    }

    public boolean isRequestedSessionIdValid() {
        HttpSession session = this.getSession();
        return session != null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.requestedSessionIdIsFromCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        return !this.requestedSessionIdIsFromCookie;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public void setPathTranslated(String pathTranslated) {
        this.pathTranslated = pathTranslated;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public void setRequestedSessionId(String requestedSessionId) {
        this.requestedSessionId = requestedSessionId;
    }

    public void setRequestURI(String requestedURI) {
        this.requestedURI = requestedURI;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setScheme(String schema) {
        this.schema = schema;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setContentType(String contentType) {
        this.setHeader("Content-Type", contentType);
    }

    public void setHeader(String name, String value) {
        List<String> valueList = this.headers.get(name);
        if (valueList == null) {
            valueList = new ArrayList<String>();
            this.headers.put(name, valueList);
        }
        valueList.add(value);
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public void setupAddParameter(String key, String[] values) {
        this.parameters.put(key, values);
    }

    public void setupAddParameter(String key, String value) {
        this.setupAddParameter(key, new String[]{value});
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    public Map<String, RequestDispatcher> getRequestDispatcherMap() {
        return Collections.unmodifiableMap(this.requestDispatchers);
    }

    public void setRequestDispatcher(String path, RequestDispatcher dispatcher) {
        if (dispatcher instanceof MockRequestDispatcher) {
            ((MockRequestDispatcher)dispatcher).setPath(path);
        }
        this.requestDispatchers.put(path, dispatcher);
    }

    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    public void addLocales(List<Locale> localeList) {
        this.locales.addAll(localeList);
    }

    public void addHeader(String key, String value) {
        List<String> valueList = this.headers.get(key);
        if (valueList == null) {
            valueList = new ArrayList<String>();
            this.headers.put(key, valueList);
        }
        valueList.add(value);
    }

    public void clearHeader(String key) {
        this.headers.remove(key);
    }

    public void setRequestURL(String requestUrl) {
        this.requestUrl = new StringBuffer(requestUrl);
    }

    public void setUserPrincipal(Principal principal) {
        this.principal = principal;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public void setRequestedSessionIdFromCookie(boolean requestedSessionIdIsFromCookie) {
        this.requestedSessionIdIsFromCookie = requestedSessionIdIsFromCookie;
    }

    public void setUserInRole(String role, boolean isInRole) {
        this.roles.put(role, isInRole);
    }

    public void setBodyContent(byte[] data) {
        this.setBodyContent(new String(data));
    }

    public void setBodyContent(String bodyContent) {
        this.bodyContent = bodyContent;
    }

    static class MockServletInputStream
    extends ServletInputStream {
        private ByteArrayInputStream stream;

        public MockServletInputStream(byte[] data) {
            this.stream = new ByteArrayInputStream(data);
        }

        public int read() throws IOException {
            return this.stream.read();
        }
    }

    public static class MockRequestDispatcher
    implements RequestDispatcher {
        private ServletRequest forwardedRequest;
        private ServletResponse forwardedResponse;
        private ServletRequest includedRequest;
        private ServletResponse includedResponse;
        private String path;

        MockRequestDispatcher() {
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            this.forwardedRequest = request;
            this.forwardedResponse = response;
        }

        public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            this.includedRequest = request;
            this.includedResponse = response;
        }

        public ServletRequest getForwardedRequest() {
            return this.forwardedRequest;
        }

        public ServletResponse getForwardedResponse() {
            return this.forwardedResponse;
        }

        public ServletRequest getIncludedRequest() {
            return this.includedRequest;
        }

        public ServletResponse getIncludedResponse() {
            return this.includedResponse;
        }
    }
}

