/*
 * Decompiled with CFR 0.152.
 */
package mondrian.server;

import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Query;
import mondrian.olap.SchemaReader;
import mondrian.rolap.RolapSchema;
import mondrian.server.Execution;
import mondrian.server.Statement;
import mondrian.spi.ProfileHandler;

public abstract class StatementImpl
implements Statement {
    private static AtomicLong SEQ = new AtomicLong();
    private ProfileHandler profileHandler;
    protected Query query;
    protected long queryTimeout;
    private Execution execution;
    private boolean cancelBeforeStart;
    private final long id;

    public StatementImpl() {
        this.queryTimeout = MondrianProperties.instance().QueryTimeout.get() * 1000;
        this.id = SEQ.getAndIncrement();
    }

    public synchronized void start(Execution execution) {
        if (this.execution != null) {
            throw new AssertionError();
        }
        if (execution.statement != this) {
            throw new AssertionError();
        }
        this.execution = execution;
        execution.start();
        if (this.cancelBeforeStart) {
            execution.cancel();
            this.cancelBeforeStart = false;
        }
    }

    public synchronized void cancel() throws SQLException {
        if (this.execution == null) {
            this.cancelBeforeStart = true;
        } else {
            this.execution.cancel();
        }
    }

    public synchronized void end(Execution execution) {
        if (execution == null || execution != this.execution) {
            throw new IllegalArgumentException(execution + " != " + this.execution);
        }
        this.execution = null;
        execution.end();
    }

    public void enableProfiling(ProfileHandler profileHandler) {
        this.profileHandler = profileHandler;
    }

    public ProfileHandler getProfileHandler() {
        return this.profileHandler;
    }

    public void setQueryTimeoutMillis(long timeoutMillis) {
        this.queryTimeout = timeoutMillis;
    }

    public long getQueryTimeoutMillis() {
        return this.queryTimeout;
    }

    public void checkCancelOrTimeout() {
        Execution execution0 = this.execution;
        if (execution0 == null) {
            return;
        }
        execution0.checkCancelOrTimeout();
    }

    public SchemaReader getSchemaReader() {
        return this.getMondrianConnection().getSchemaReader().withLocus();
    }

    public RolapSchema getSchema() {
        return this.getMondrianConnection().getSchema();
    }

    public Object getProperty(String name) {
        return this.getMondrianConnection().getProperty(name);
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public Execution getCurrentExecution() {
        return this.execution;
    }

    public long getId() {
        return this.id;
    }
}

