/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.List;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.MemberPredicate;
import mondrian.rolap.agg.PredicateColumn;
import mondrian.spi.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeMemberPredicate
implements MemberPredicate {
    private final RolapMember member;
    private final List<PredicateColumn> columnList = new ArrayList<PredicateColumn>();

    public CompositeMemberPredicate(RolapSchema.PhysRouter router, RolapMember member) {
        this.member = member;
        assert (member != null);
        for (RolapSchema.PhysColumn physColumn : member.getLevel().getAttribute().getKeyList()) {
            this.columnList.add(new PredicateColumn(router, physColumn));
        }
        assert (this.columnList.size() > 1) : "use MemberColumnPredicate for non-comp";
    }

    public String toString() {
        return this.member.getUniqueName();
    }

    @Override
    public List<PredicateColumn> getColumnList() {
        return this.columnList;
    }

    @Override
    public RolapMember getMember() {
        return this.member;
    }

    public boolean equals(Object other) {
        if (!(other instanceof CompositeMemberPredicate)) {
            return false;
        }
        CompositeMemberPredicate that = (CompositeMemberPredicate)other;
        return this.member.equals(that.getMember());
    }

    public int hashCode() {
        return this.member.hashCode();
    }

    @Override
    public void describe(StringBuilder buf) {
        buf.append(this.member.getUniqueName());
    }

    @Override
    public BitKey getConstrainedColumnBitKey() {
        throw new UnsupportedOperationException("TODO:");
    }

    @Override
    public boolean evaluate(List<Object> valueList) {
        throw new UnsupportedOperationException("TODO:");
    }

    @Override
    public boolean equalConstraint(StarPredicate that) {
        throw new UnsupportedOperationException("TODO:");
    }

    @Override
    public StarPredicate minus(StarPredicate predicate) {
        throw new UnsupportedOperationException("TODO:");
    }

    @Override
    public StarPredicate or(StarPredicate predicate) {
        throw new UnsupportedOperationException("TODO:");
    }

    @Override
    public StarPredicate and(StarPredicate predicate) {
        throw new UnsupportedOperationException("TODO:");
    }

    @Override
    public void toSql(Dialect dialect, StringBuilder buf) {
        throw new UnsupportedOperationException("TODO:");
    }
}

