/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.GroupingSetsCollector;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AggregationKey;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.GroupingSet;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.MemberColumnPredicate;
import mondrian.rolap.agg.PredicateColumn;
import mondrian.rolap.agg.Predicates;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentCacheManager;
import mondrian.rolap.agg.SegmentLoader;
import mondrian.rolap.agg.SegmentWithData;
import mondrian.rolap.agg.StarPredicates;
import mondrian.spi.DataServicesLocator;
import mondrian.spi.DataServicesProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aggregation {
    private final List<StarPredicate> compoundPredicateList;
    private final RolapStar star;
    private final BitKey constrainedColumnsBitKey;
    private final int maxConstraints;
    private final Date creationTimestamp;

    public Aggregation(AggregationKey aggregationKey) {
        this.compoundPredicateList = aggregationKey.getCompoundPredicateList();
        this.star = aggregationKey.getStar();
        this.constrainedColumnsBitKey = aggregationKey.getConstrainedColumnsBitKey();
        this.maxConstraints = MondrianProperties.instance().MaxConstraints.get();
        this.creationTimestamp = new Date();
    }

    public Date getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void load(SegmentCacheManager cacheMgr, int cellRequestCount, RolapStar.Column[] columns, List<RolapStar.Measure> measures, StarColumnPredicate[] predicates, AggregationManager.StarConverter starConverter, GroupingSetsCollector groupingSetsCollector, List<Future<Map<Segment, SegmentWithData>>> segmentFutures) {
        BitKey measureBitKey = this.getConstrainedColumnsBitKey().emptyCopy();
        int axisCount = columns.length;
        Util.assertTrue(predicates.length == axisCount);
        List<Segment> segments = this.createSegments(starConverter, columns, measures, measureBitKey, predicates);
        BitKey levelBitKey = this.getConstrainedColumnsBitKey();
        GroupingSet groupingSet = new GroupingSet(segments, levelBitKey, measureBitKey, predicates, columns);
        if (groupingSetsCollector.useGroupingSets()) {
            groupingSetsCollector.add(groupingSet);
        } else {
            DataServicesProvider provider = DataServicesLocator.getDataServicesProvider(this.star.getSchema().getDataServiceProviderName());
            SegmentLoader segmentLoader = provider.getSegmentLoader(cacheMgr);
            segmentLoader.load(cellRequestCount, new ArrayList<GroupingSet>(Collections.singletonList(groupingSet)), this.compoundPredicateList, segmentFutures);
        }
    }

    private List<Segment> createSegments(AggregationManager.StarConverter starConverter, RolapStar.Column[] columns, List<RolapStar.Measure> measures, BitKey measureBitKey, StarColumnPredicate[] predicates) {
        ArrayList<Segment> segments = new ArrayList<Segment>(measures.size());
        for (RolapStar.Measure measure : measures) {
            measureBitKey.set(measure.getBitPosition());
            Segment segment = Segment.create(starConverter, this.star, this.constrainedColumnsBitKey, columns, measure, predicates, Collections.<Segment.ExcludedRegion>emptyList(), this.compoundPredicateList);
            segments.add(segment);
        }
        Collections.sort(segments, new Comparator<Segment>(){

            @Override
            public int compare(Segment o1, Segment o2) {
                return Util.compare(o1.measure.getBitPosition(), o2.measure.getBitPosition());
            }
        });
        return segments;
    }

    public StarColumnPredicate[] optimizePredicates(RolapStar.Column[] columns, StarColumnPredicate[] predicates) {
        int j;
        if (predicates.length == 0) {
            return predicates;
        }
        RolapStar star = this.getStar();
        assert (predicates.length == columns.length);
        StarColumnPredicate[] newPredicates = (StarColumnPredicate[])predicates.clone();
        double[] bloats = new double[columns.length];
        RolapSchema.PhysRouter router = predicates[0].getColumn().router;
        ArrayList<RolapMember> potentialParents = new ArrayList<RolapMember>();
        for (StarColumnPredicate predicate : predicates) {
            if (!(predicate instanceof MemberColumnPredicate)) continue;
            RolapMember m = ((MemberColumnPredicate)predicate).getMember();
            potentialParents.add(m);
        }
        for (int i = 0; i < newPredicates.length; ++i) {
            int memberCount;
            SchemaReader scr;
            if (!(newPredicates[i] instanceof ListColumnPredicate)) {
                bloats[i] = 0.0;
                continue;
            }
            ListColumnPredicate newPredicate = (ListColumnPredicate)newPredicates[i];
            List<StarColumnPredicate> predicateList = newPredicate.getPredicates();
            int valueCount = predicateList.size();
            if (valueCount < 2) {
                bloats[i] = 0.0;
                continue;
            }
            if (valueCount > this.maxConstraints) {
                bloats[i] = 1.0;
                continue;
            }
            double constraintLength = valueCount;
            Member parent = null;
            Level level = null;
            for (int j2 = 0; j2 < valueCount; ++j2) {
                StarColumnPredicate value = predicateList.get(j2);
                if (value instanceof MemberColumnPredicate) {
                    MemberColumnPredicate memberColumnPredicate = (MemberColumnPredicate)value;
                    RolapMember m = memberColumnPredicate.getMember();
                    if (j2 == 0) {
                        parent = m.getParentMember();
                        level = m.getLevel();
                        continue;
                    }
                    if (parent != null && !parent.equals(m.getParentMember())) {
                        parent = null;
                    }
                    if (level == null || level.equals(m.getLevel())) continue;
                    level = null;
                    continue;
                }
                parent = null;
                level = null;
                bloats[i] = constraintLength / (double)columns[i].getCardinality();
                break;
            }
            boolean done = false;
            if (parent != null && (parent.isAll() || potentialParents.contains(parent))) {
                scr = star.getSchema().getSchemaReader();
                int childCount = scr.getChildrenCountFromCache(parent);
                if (childCount == -1) {
                    if (!parent.isAll()) {
                        bloats[i] = 0.0;
                        done = true;
                    }
                } else {
                    bloats[i] = constraintLength / (double)childCount;
                    done = true;
                }
            }
            if (!done && level != null && (memberCount = (scr = star.getSchema().getSchemaReader()).getLevelCardinality(level, true, false)) > 0) {
                bloats[i] = constraintLength / (double)memberCount;
                done = true;
            }
            if (done) continue;
            bloats[i] = constraintLength / (double)columns[i].getCardinality();
        }
        ConstraintComparator comparator = new ConstraintComparator(bloats);
        Integer[] indexes = new Integer[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            indexes[i] = i;
        }
        Arrays.sort(indexes, comparator);
        double abloat = 1.0;
        double aBloatLimit = 0.5;
        Integer[] arr$ = indexes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !((abloat *= bloats[j = arr$[i$].intValue()]) <= 0.5); ++i$) {
            if (!MondrianProperties.instance().OptimizePredicates.get() && bloats[j] != 1.0) continue;
            newPredicates[j] = Predicates.wildcard(new PredicateColumn(router, columns[j].getExpression()), true);
        }
        for (int i = 0; i < newPredicates.length; ++i) {
            newPredicates[i] = StarPredicates.optimize(newPredicates[i]);
        }
        return newPredicates;
    }

    public RolapStar getStar() {
        return this.star;
    }

    public BitKey getConstrainedColumnsBitKey() {
        return this.constrainedColumnsBitKey;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstraintComparator
    implements Comparator<Integer> {
        private final double[] bloats;

        ConstraintComparator(double[] bloats) {
            this.bloats = bloats;
        }

        @Override
        public int compare(Integer o0, Integer o1) {
            double bloat1;
            double bloat0 = this.bloats[o0];
            return bloat0 == (bloat1 = this.bloats[o1]) ? 0 : (bloat0 < bloat1 ? 1 : -1);
        }
    }
}

