/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.AbstractCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.olap.Access;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NameResolver;
import mondrian.olap.NamedSet;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.OlapElement;
import mondrian.olap.Parameter;
import mondrian.olap.ParameterImpl;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.type.StringType;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNativeSet;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapSchemaLoader;
import mondrian.rolap.RolapSchemaParameter;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SmartMemberReader;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.Property;
import org.olap4j.mdx.IdentifierSegment;
import org.olap4j.metadata.NamedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapSchemaReader
implements SchemaReader,
RolapNativeSet.SchemaReaderWithMemberReaderAvailable,
NameResolver.Namespace {
    protected final Role role;
    private final Map<Hierarchy, MemberReader> hierarchyReaders = new ConcurrentHashMap<Hierarchy, MemberReader>();
    protected final RolapSchema schema;
    private final SqlConstraintFactory sqlConstraintFactory = SqlConstraintFactory.instance();
    private static final Logger LOGGER = Logger.getLogger(RolapSchemaReader.class);

    RolapSchemaReader(Role role, RolapSchema schema) {
        assert (role != null) : "precondition: role != null";
        assert (schema != null);
        this.role = role;
        this.schema = schema;
    }

    @Override
    public Role getRole() {
        return this.role;
    }

    @Override
    public List<Member> getHierarchyRootMembers(Hierarchy hierarchy) {
        Role.HierarchyAccess hierarchyAccess = this.role.getAccessDetails(hierarchy);
        List<? extends Level> levels = hierarchy.getLevelList();
        Level firstLevel = hierarchyAccess == null ? levels.get(0) : levels.get(hierarchyAccess.getTopLevelDepth());
        return this.getLevelMembers(firstLevel, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemberReader getMemberReader(RolapCubeHierarchy hierarchy) {
        MemberReader memberReader = this.hierarchyReaders.get(hierarchy);
        if (memberReader == null) {
            RolapSchemaReader rolapSchemaReader = this;
            synchronized (rolapSchemaReader) {
                memberReader = this.hierarchyReaders.get(hierarchy);
                if (memberReader == null) {
                    memberReader = RolapSchemaLoader.createMemberReader(hierarchy, this.role);
                    assert (memberReader != null) : hierarchy;
                    this.hierarchyReaders.put(hierarchy, memberReader);
                }
            }
        }
        return memberReader;
    }

    @Override
    public Member substitute(Member _member) {
        RolapMember member = (RolapMember)_member;
        MemberReader memberReader = this.getMemberReader(member.getHierarchy());
        return memberReader.substitute(member);
    }

    @Override
    public void getMemberRange(Level _level, Member _startMember, Member _endMember, List<Member> list) {
        RolapCubeLevel level = (RolapCubeLevel)_level;
        RolapMember startMember = (RolapMember)_startMember;
        RolapMember endMember = (RolapMember)_endMember;
        this.getMemberReader(level.getHierarchy()).getMemberRange(level, startMember, endMember, Util.cast(list));
    }

    @Override
    public int compareMembersHierarchically(Member m1, Member m2) {
        RolapMember member1 = (RolapMember)m1;
        RolapMember member2 = (RolapMember)m2;
        RolapCubeHierarchy hierarchy = member1.getHierarchy();
        Util.assertPrecondition(hierarchy == m2.getHierarchy());
        return this.getMemberReader(hierarchy).compare(member1, member2, true);
    }

    @Override
    public RolapMember getMemberParent(Member _member) {
        RolapMember member = (RolapMember)_member;
        return this.getMemberReader(member.getHierarchy()).getMemberParent(member);
    }

    @Override
    public int getMemberDepth(Member _member) {
        RolapMember member = (RolapMember)_member;
        Role.HierarchyAccess hierarchyAccess = this.role.getAccessDetails(member.getHierarchy());
        if (hierarchyAccess != null) {
            int memberDepth = member.getLevel().getDepth();
            int topLevelDepth = hierarchyAccess.getTopLevelDepth();
            return memberDepth - topLevelDepth;
        }
        if (member.getLevel().isParentChild()) {
            int depth = 0;
            for (RolapMember m = member.getParentMember(); m != null; m = m.getParentMember()) {
                ++depth;
            }
            return depth;
        }
        return member.getLevel().getDepth();
    }

    @Override
    public List<Member> getMemberChildren(Member member) {
        return this.getMemberChildren(member, null);
    }

    @Override
    public List<Member> getMemberChildren(Member _member, Evaluator _context) {
        RolapMember member = (RolapMember)_member;
        RolapEvaluator context = (RolapEvaluator)_context;
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(context);
        List<RolapMember> memberList = this.internalGetMemberChildren(member, constraint);
        return Util.cast(memberList);
    }

    private List<RolapMember> internalGetMemberChildren(RolapMember member, MemberChildrenConstraint constraint) {
        ArrayList<RolapMember> children = new ArrayList<RolapMember>();
        MemberReader memberReader = this.getMemberReader(member.getHierarchy());
        memberReader.getMemberChildren(member, children, constraint);
        return children;
    }

    @Override
    public void getParentChildContributingChildren(Member _dataMember, Hierarchy _hierarchy, List<Member> _list) {
        RolapMember dataMember = (RolapMember)_dataMember;
        RolapCubeHierarchy hierarchy = (RolapCubeHierarchy)_hierarchy;
        List<RolapMember> list = Util.cast(_list);
        list.add(dataMember);
        hierarchy.getMemberReader().getMemberChildren(dataMember, list);
    }

    @Override
    public int getChildrenCountFromCache(Member _member) {
        RolapMember member = (RolapMember)_member;
        MemberReader memberReader = this.getMemberReader(member.getHierarchy());
        if (memberReader instanceof SmartMemberReader) {
            List<RolapMember> list = ((SmartMemberReader)memberReader).getMemberCache().getChildrenFromCache(member, null);
            if (list == null) {
                return -1;
            }
            return list.size();
        }
        if (!(memberReader instanceof MemberCache)) {
            return -1;
        }
        List<RolapMember> list = ((MemberCache)((Object)memberReader)).getChildrenFromCache(member, null);
        if (list == null) {
            return -1;
        }
        return list.size();
    }

    private int getLevelCardinalityFromCache(RolapCubeLevel level) {
        RolapCubeHierarchy hierarchy = level.getHierarchy();
        MemberReader memberReader = this.getMemberReader(hierarchy);
        if (memberReader instanceof SmartMemberReader) {
            List<RolapMember> list = ((SmartMemberReader)memberReader).getMemberCache().getLevelMembersFromCache(level, null);
            if (list == null) {
                return Integer.MIN_VALUE;
            }
            return list.size();
        }
        if (memberReader instanceof MemberCache) {
            List<RolapMember> list = ((MemberCache)((Object)memberReader)).getLevelMembersFromCache(level, null);
            if (list == null) {
                return Integer.MIN_VALUE;
            }
            return list.size();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getLevelCardinality(Level _level, boolean approximate, boolean materialize) {
        RolapCubeLevel level = (RolapCubeLevel)_level;
        if (!this.role.canAccess(_level)) {
            return 1;
        }
        int rowCount = Integer.MIN_VALUE;
        if (approximate) {
            rowCount = level.getApproxRowCount();
        }
        if (rowCount == Integer.MIN_VALUE) {
            rowCount = level.getAttribute().getApproxRowCount();
        }
        if (rowCount == Integer.MIN_VALUE) {
            rowCount = this.getLevelCardinalityFromCache(level);
        }
        if (rowCount == Integer.MIN_VALUE && materialize) {
            MemberReader memberReader = this.getMemberReader(level.getHierarchy());
            rowCount = memberReader.getLevelMemberCount(level);
            level.setApproxRowCount(rowCount);
        }
        return rowCount;
    }

    @Override
    public List<Member> getMemberChildren(List<Member> members) {
        return this.getMemberChildren(members, null);
    }

    @Override
    public List<Member> getMemberChildren(List<Member> _members, Evaluator _context) {
        List<RolapMember> members = Util.cast(_members);
        if (members.size() == 0) {
            return Collections.emptyList();
        }
        RolapEvaluator context = (RolapEvaluator)_context;
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(context);
        MemberReader memberReader = this.getMemberReader(((RolapMember)members.get(0)).getHierarchy());
        ArrayList<RolapMember> children = new ArrayList<RolapMember>();
        memberReader.getMemberChildren(members, children, constraint);
        return Util.cast(children);
    }

    @Override
    public void getMemberAncestors(Member member, List<Member> ancestorList) {
        RolapMember parentMember = this.getMemberParent(member);
        while (parentMember != null) {
            ancestorList.add(parentMember);
            parentMember = this.getMemberParent(parentMember);
        }
    }

    @Override
    public Cube getCube() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SchemaReader withoutAccessControl() {
        assert (this.getClass() == RolapSchemaReader.class) : "Subclass " + this.getClass() + " must override";
        if (this.role == this.schema.rootRole) {
            return this;
        }
        return new RolapSchemaReader(this.schema.rootRole, this.schema);
    }

    @Override
    public OlapElement getElementChild(OlapElement parent, Id.Segment name) {
        return this.getElementChild(parent, name, MatchType.EXACT);
    }

    @Override
    public OlapElement getElementChild(OlapElement parent, Id.Segment name, MatchType matchType) {
        return parent.lookupChild(this, name, matchType);
    }

    @Override
    public final Member getMemberByUniqueName(List<Id.Segment> uniqueNameParts, boolean failIfNotFound) {
        return this.getMemberByUniqueName(uniqueNameParts, failIfNotFound, MatchType.EXACT);
    }

    @Override
    public Member getMemberByUniqueName(List<Id.Segment> uniqueNameParts, boolean failIfNotFound, MatchType matchType) {
        return null;
    }

    @Override
    public OlapElement lookupCompound(OlapElement parent, List<Id.Segment> names, boolean failIfNotFound, int category) {
        return this.lookupCompound(parent, names, failIfNotFound, category, MatchType.EXACT);
    }

    @Override
    public final OlapElement lookupCompound(OlapElement parent, List<Id.Segment> names, boolean failIfNotFound, int category, MatchType matchType) {
        return new NameResolver().resolve(parent, Util.toOlap4j(names), failIfNotFound, category, matchType, this.getNamespaces());
    }

    @Override
    public List<NameResolver.Namespace> getNamespaces() {
        return Collections.singletonList(this);
    }

    @Override
    public OlapElement lookupChild(OlapElement parent, IdentifierSegment segment) {
        return this.lookupChild(parent, segment, MatchType.EXACT);
    }

    @Override
    public OlapElement lookupChild(OlapElement parent, IdentifierSegment segment, MatchType matchType) {
        OlapElement element = this.getElementChild(parent, Util.convert(segment), matchType);
        if (element != null) {
            return element;
        }
        if (parent instanceof Cube) {
            element = this.schema.getNamedSet(segment);
        }
        return element;
    }

    @Override
    public Member lookupMemberChildByName(Member _parent, Id.Segment childName, MatchType matchType) {
        RolapMember parent = (RolapMember)_parent;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("looking for child \"" + childName + "\" of " + parent));
        }
        assert (!(parent instanceof RolapHierarchy.LimitedRollupMember));
        try {
            MemberChildrenConstraint constraint = childName instanceof Id.NameSegment && matchType.isExact() ? this.sqlConstraintFactory.getChildByNameConstraint(parent, (Id.NameSegment)childName) : this.sqlConstraintFactory.getMemberChildrenConstraint(null);
            List<RolapMember> children = this.internalGetMemberChildren(parent, constraint);
            if (children.size() > 0) {
                return RolapUtil.findBestMemberMatch(children, parent, children.get(0).getLevel(), childName, matchType);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.debug((Object)("NumberFormatException in lookupMemberChildByName for parent = \"" + parent + "\", childName=\"" + childName + "\", exception: " + e.getMessage()));
        }
        return null;
    }

    @Override
    public Member getCalculatedMember(List<Id.Segment> nameParts) {
        return null;
    }

    @Override
    public NamedSet getNamedSet(List<Id.Segment> nameParts) {
        if (nameParts.size() != 1) {
            return null;
        }
        if (!(nameParts.get(0) instanceof Id.NameSegment)) {
            return null;
        }
        String name = ((Id.NameSegment)nameParts.get((int)0)).name;
        return this.schema.getNamedSet(name);
    }

    @Override
    public Member getLeadMember(Member _member, int n) {
        RolapMember member = (RolapMember)_member;
        MemberReader memberReader = this.getMemberReader(member.getHierarchy());
        return memberReader.getLeadMember(member, n);
    }

    @Override
    public List<Member> getLevelMembers(Level level, boolean includeCalculated) {
        List<Member> members = this.getLevelMembers(level, null);
        if (!includeCalculated) {
            members = SqlConstraintUtils.removeCalculatedMembers(members);
        }
        return members;
    }

    @Override
    public List<Member> getLevelMembers(Level _level, Evaluator _context) {
        RolapCubeLevel level = (RolapCubeLevel)_level;
        RolapEvaluator context = (RolapEvaluator)_context;
        TupleConstraint constraint = this.sqlConstraintFactory.getLevelMembersConstraint(context, Collections.singletonList(level));
        MemberReader memberReader = this.getMemberReader(level.getHierarchy());
        List<RolapMember> membersInLevel = memberReader.getMembersInLevel(level, constraint);
        return Util.cast(membersInLevel);
    }

    @Override
    public List<Dimension> getCubeDimensions(Cube cube) {
        assert (cube != null);
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        block3: for (Dimension dimension : cube.getDimensionList()) {
            switch (this.role.getAccess(dimension)) {
                case NONE: {
                    continue block3;
                }
            }
            dimensions.add(dimension);
        }
        return dimensions;
    }

    @Override
    public List<Hierarchy> getDimensionHierarchies(Dimension dimension) {
        assert (dimension != null);
        ArrayList<Hierarchy> hierarchies = new ArrayList<Hierarchy>();
        block3: for (Hierarchy hierarchy : dimension.getHierarchyList()) {
            switch (this.role.getAccess(hierarchy)) {
                case NONE: {
                    continue block3;
                }
            }
            hierarchies.add(hierarchy);
        }
        return hierarchies;
    }

    @Override
    public List<Level> getHierarchyLevels(Hierarchy hierarchy) {
        assert (hierarchy != null);
        Role.HierarchyAccess hierarchyAccess = this.role.getAccessDetails(hierarchy);
        List<Level> levels = Util.cast(hierarchy.getLevelList());
        if (hierarchyAccess == null) {
            return levels;
        }
        Level topLevel = levels.get(hierarchyAccess.getTopLevelDepth());
        Level bottomLevel = levels.get(hierarchyAccess.getBottomLevelDepth());
        List<Level> restrictedLevels = levels.subList(topLevel.getDepth(), bottomLevel.getDepth() + 1);
        assert (restrictedLevels.size() >= 1) : "postcondition";
        return restrictedLevels;
    }

    @Override
    public Member getHierarchyDefaultMember(Hierarchy _hierarchy) {
        RolapCubeHierarchy hierarchy = (RolapCubeHierarchy)_hierarchy;
        assert (_hierarchy != null);
        if (this.role.getAccess(hierarchy) == Access.NONE) {
            return hierarchy.getDefaultMember();
        }
        return this.getMemberReader(hierarchy).getDefaultMember();
    }

    @Override
    public boolean isDrillable(Member member) {
        RolapLevel level = (RolapLevel)member.getLevel();
        if (level.isParentChild()) {
            return this.getMemberChildren(member).size() > 0;
        }
        RolapLevel childLevel = level.getChildLevel();
        return childLevel != null && this.role.getAccess(childLevel) != Access.NONE;
    }

    @Override
    public boolean isVisible(Member member) {
        return !member.isHidden() && this.role.canAccess(member);
    }

    @Override
    public Cube[] getCubes() {
        NamedList<RolapCube> cubes = this.schema.getCubeList();
        ArrayList<Cube> visibleCubes = new ArrayList<Cube>(cubes.size());
        for (Cube cube : cubes) {
            if (!this.role.canAccess(cube)) continue;
            visibleCubes.add(cube);
        }
        return visibleCubes.toArray(new Cube[visibleCubes.size()]);
    }

    @Override
    public List<Member> getCalculatedMembers(Hierarchy hierarchy) {
        return Collections.emptyList();
    }

    @Override
    public List<Member> getCalculatedMembers(Level level) {
        return Collections.emptyList();
    }

    @Override
    public List<Member> getCalculatedMembers() {
        return Collections.emptyList();
    }

    @Override
    public NativeEvaluator getNativeSetEvaluator(FunDef fun, Exp[] args, Evaluator evaluator, Calc calc) {
        RolapEvaluator revaluator = (RolapEvaluator)AbstractCalc.simplifyEvaluator(calc, evaluator);
        if (evaluator.nativeEnabled()) {
            return this.schema.getNativeRegistry().createEvaluator(revaluator, fun, args);
        }
        return null;
    }

    @Override
    public Parameter getParameter(String name) {
        for (RolapSchemaParameter parameter : this.schema.parameterList) {
            if (!Util.equalName(parameter.getName(), name)) continue;
            return parameter;
        }
        List propertyList = MondrianProperties.instance().getPropertyList();
        for (Property property : propertyList) {
            if (!property.getPath().equals(name)) continue;
            return new SystemPropertyParameter(name, false);
        }
        return null;
    }

    @Override
    public DataSource getDataSource() {
        return this.schema.getInternalConnection().getDataSource();
    }

    @Override
    public RolapSchema getSchema() {
        return this.schema;
    }

    @Override
    public SchemaReader withLocus() {
        return RolapUtil.locusSchemaReader(this.schema.getInternalConnection(), this);
    }

    private static class SystemPropertyParameter
    extends ParameterImpl {
        private final boolean system;
        private final Property propertyDefinition;

        public SystemPropertyParameter(String name, boolean system) {
            super(name, Literal.nullValue, "System property '" + name + "'", new StringType());
            this.system = system;
            this.propertyDefinition = system ? null : MondrianProperties.instance().getPropertyDefinition(name);
        }

        public Parameter.Scope getScope() {
            return Parameter.Scope.System;
        }

        public boolean isModifiable() {
            return false;
        }

        public Calc compile(ExpCompiler compiler) {
            return new GenericCalc(new DummyExp(this.getType())){

                public Calc[] getCalcs() {
                    return new Calc[0];
                }

                public Object evaluate(Evaluator evaluator) {
                    if (SystemPropertyParameter.this.system) {
                        String name = SystemPropertyParameter.this.getName();
                        return System.getProperty(name);
                    }
                    return SystemPropertyParameter.this.propertyDefinition.stringValue();
                }
            };
        }
    }
}

