/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Access;
import mondrian.olap.Cube;
import mondrian.olap.CubeBase;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Larder;
import mondrian.olap.Larders;
import mondrian.olap.Level;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MemberProperty;
import mondrian.olap.NameResolver;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Parameter;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.QueryPart;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.FunDefBase;
import mondrian.resource.MondrianResource;
import mondrian.rolap.BitKey;
import mondrian.rolap.CacheMemberReader;
import mondrian.rolap.MeasureMemberSource;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapGalaxy;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapSchemaLoader;
import mondrian.rolap.RolapSchemaReader;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.aggmatcher.ExplicitRules;
import mondrian.rolap.cache.SoftSmartCache;
import mondrian.server.Statement;
import org.apache.log4j.Logger;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.IdentifierSegment;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.NamedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapCube
extends CubeBase {
    private static final Logger LOGGER = Logger.getLogger(RolapCube.class);
    private final RolapSchema schema;
    private final Larder larder;
    private final RolapCubeHierarchy measuresHierarchy;
    private SchemaReader schemaReader;
    final List<Formula> calculatedMemberList = new ArrayList<Formula>();
    private final SoftSmartCache<Role, List<RolapMember>> roleToAccessibleCalculatedMembers = new SoftSmartCache();
    final List<Formula> namedSetList = new ArrayList<Formula>();
    private ExplicitRules.Group aggGroup;
    final List<RolapCubeHierarchy> hierarchyList = new ArrayList<RolapCubeHierarchy>();
    final NamedList<RolapCubeDimension> dimensionList = new NamedListImpl();
    private boolean loadInProgress = false;
    private Map<RolapLevel, RolapCubeLevel> virtualToBaseMap = new HashMap<RolapLevel, RolapCubeLevel>();
    private final List<RolapMeasureGroup> measureGroupList = new ArrayList<RolapMeasureGroup>();
    private BitKey closureColumnBitKey;
    public RolapGalaxy galaxy;
    RolapCubeHierarchy scenarioHierarchy;

    RolapCube(RolapSchemaLoader schemaLoader, String name, boolean visible, Larder larder, String measuresCaption) {
        super(name, visible);
        assert (larder != null);
        this.larder = larder;
        this.schema = schemaLoader.schema;
        RolapDimension measuresDimension = new RolapDimension(this.schema, "Measures", true, Dimension.Type.MEASURE, false, Larders.ofCaption("Measures", measuresCaption));
        RolapHierarchy measuresHierarchy = new RolapHierarchy(measuresDimension, measuresDimension.getName(), Util.quoteMdxIdentifier("Measures"), measuresDimension.isVisible(), false, null, null, measuresDimension.getLarder());
        measuresDimension.addHierarchy(measuresHierarchy);
        measuresHierarchy.initHierarchy(schemaLoader, null);
        ArrayList<RolapCubeHierarchy> cubeHierarchyList = new ArrayList<RolapCubeHierarchy>();
        RolapCubeDimension measuresCubeDimension = new RolapCubeDimension(this, measuresDimension, measuresDimension.getName(), 0, measuresDimension.getLarder());
        schemaLoader.initCubeDimension(measuresCubeDimension, null, cubeHierarchyList);
        this.dimensionList.add((Object)measuresCubeDimension);
        this.measuresHierarchy = (RolapCubeHierarchy)measuresCubeDimension.getHierarchyList().get(0);
        this.hierarchyList.add(this.measuresHierarchy);
    }

    @Override
    public Dimension[] getDimensions() {
        return (Dimension[])this.dimensionList.toArray((Object[])new Dimension[this.dimensionList.size()]);
    }

    public List<? extends RolapCubeDimension> getDimensionList() {
        return Util.cast(this.dimensionList);
    }

    @Override
    public RolapDimension lookupDimension(Id.Segment s) {
        if (!(s instanceof Id.NameSegment)) {
            return null;
        }
        Id.NameSegment nameSegment = (Id.NameSegment)s;
        for (RolapDimension dimension : this.dimensionList) {
            if (!Util.equalName(dimension.getName(), nameSegment.name)) continue;
            return dimension;
        }
        return null;
    }

    void setMeasuresHierarchyMemberReader(MemberReader memberReader) {
        this.measuresHierarchy.setMemberReader(memberReader);
        this.schemaReader = null;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public Larder getLarder() {
        return this.larder;
    }

    @Override
    public String getDescription() {
        return Larders.getDescription(this.larder);
    }

    public boolean hasAggGroup() {
        return this.aggGroup != null;
    }

    public ExplicitRules.Group getAggGroup() {
        return this.aggGroup;
    }

    void setAggGroup(ExplicitRules.Group aggGroup) {
        this.aggGroup = aggGroup;
    }

    void init(List<RolapMember> measureList) {
        this.setMeasuresHierarchyMemberReader(new CacheMemberReader(new MeasureMemberSource(this.measuresHierarchy, measureList)));
        this.closureColumnBitKey = !this.isVirtual() && this.measureGroupList.size() > 0 ? BitKey.Factory.makeBitKey(this.measureGroupList.get(0).getStar().getColumnCount()) : null;
    }

    void init2() {
        this.galaxy = new RolapGalaxy(this);
    }

    @Override
    public RolapSchema getSchema() {
        return this.schema;
    }

    @Override
    public NamedSet[] getNamedSets() {
        ArrayList<NamedSet> list = new ArrayList<NamedSet>();
        for (Formula namedSet : this.namedSetList) {
            list.add(namedSet.getNamedSet());
        }
        return list.toArray(new NamedSet[list.size()]);
    }

    public synchronized SchemaReader getSchemaReader() {
        if (this.schemaReader == null) {
            this.schemaReader = new RolapCubeSchemaReader(Util.createRootRole(this.schema));
        }
        return this.schemaReader;
    }

    @Override
    public SchemaReader getSchemaReader(Role role) {
        if (role == null) {
            return this.getSchemaReader();
        }
        return new RolapCubeSchemaReader(role);
    }

    public List<RolapStar> getStars() {
        ArrayList<RolapStar> starList = new ArrayList<RolapStar>();
        for (Member member : this.getMeasures()) {
            if (!(member instanceof RolapStoredMeasure)) continue;
            RolapStoredMeasure storedMeasure = (RolapStoredMeasure)member;
            RolapStar star = storedMeasure.getMeasureGroup().getStar();
            assert (star != null) : "measure " + member + " has no star";
            if (starList.contains(star)) continue;
            starList.add(star);
        }
        return starList;
    }

    public RolapStar getStar() {
        throw new UnsupportedOperationException();
    }

    public List<RolapHierarchy> getHierarchies() {
        return Util.cast(this.hierarchyList);
    }

    public List<RolapCubeHierarchy> getHierarchyList() {
        return Util.cast(this.hierarchyList);
    }

    public boolean isLoadInProgress() {
        return this.loadInProgress || this.getSchema().getSchemaLoadDate() == null;
    }

    public List<RolapMeasureGroup> getMeasureGroups() {
        return this.measureGroupList;
    }

    void addDimension(RolapCubeDimension dimension) {
        assert (this.dimensionList.get(dimension.getName()) == null);
        this.dimensionList.add((Object)dimension);
    }

    void addMeasureGroup(RolapMeasureGroup measureGroup) {
        this.measureGroupList.add(measureGroup);
    }

    @Override
    public Member[] getMembersForQuery(String query, List<Member> calcMembers) {
        throw new UnsupportedOperationException();
    }

    public RolapHierarchy getTimeHierarchy(String funName) {
        for (RolapHierarchy rolapHierarchy : this.hierarchyList) {
            if (rolapHierarchy.getDimension().getDimensionType() != Dimension.Type.TIME) continue;
            return rolapHierarchy;
        }
        throw MondrianResource.instance().NoTimeDimensionInCube.ex(funName);
    }

    List<Member> getMeasures() {
        Util.deprecated("remove either this or getMeasuresMembers?", false);
        RolapCubeLevel measuresLevel = ((RolapCubeHierarchy)((RolapCubeDimension)this.dimensionList.get(0)).getHierarchyList().get(0)).getLevelList().get(0);
        return this.getSchemaReader().getLevelMembers((Level)measuresLevel, true);
    }

    public boolean isVirtual() {
        return Util.deprecated(false, false);
    }

    RolapCubeHierarchy findBaseCubeHierarchy(RolapHierarchy hierarchy) {
        for (RolapCubeDimension dimension : this.dimensionList) {
            if (!dimension.getName().equals(hierarchy.getDimension().getName())) continue;
            for (RolapCubeHierarchy hier : dimension.getHierarchyList()) {
                if (!hier.getName().equals(hierarchy.getName())) continue;
                return hier;
            }
        }
        return null;
    }

    public RolapCubeLevel findBaseCubeLevel(RolapLevel level) {
        if (this.virtualToBaseMap.containsKey(level)) {
            return this.virtualToBaseMap.get(level);
        }
        String levelDimName = level.getDimension().getName();
        String levelHierName = level.getHierarchy().getName();
        boolean isClosure = false;
        String closDimName = null;
        String closHierName = null;
        if (levelDimName.endsWith("$Closure")) {
            isClosure = true;
            closDimName = levelDimName.substring(0, levelDimName.length() - 8);
            closHierName = levelHierName.substring(0, levelHierName.length() - 8);
        }
        for (RolapCubeDimension dimension : this.dimensionList) {
            String dimensionName = dimension.getName();
            if (!dimensionName.equals(levelDimName) && (!isClosure || !dimensionName.equals(closDimName))) continue;
            for (RolapCubeHierarchy hier : dimension.getHierarchyList()) {
                String hierarchyName = hier.getName();
                if (!hierarchyName.equals(levelHierName) && (!isClosure || !hierarchyName.equals(closHierName))) continue;
                if (isClosure) {
                    RolapCubeLevel baseLevel = hier.getLevelList().get(1).getClosedPeer();
                    this.virtualToBaseMap.put(level, baseLevel);
                    return baseLevel;
                }
                for (RolapCubeLevel lvl : hier.getLevelList()) {
                    if (!lvl.getName().equals(level.getName())) continue;
                    this.virtualToBaseMap.put(level, lvl);
                    return lvl;
                }
            }
        }
        return null;
    }

    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s) {
        return this.lookupChild(schemaReader, s, MatchType.EXACT);
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s, MatchType matchType) {
        if (!(s instanceof Id.NameSegment)) {
            return null;
        }
        Id.NameSegment nameSegment = (Id.NameSegment)s;
        if (matchType != MatchType.EXACT_SCHEMA) {
            matchType = MatchType.EXACT;
        }
        return super.lookupChild(schemaReader, s, matchType);
    }

    public RolapCubeHierarchy getMeasuresHierarchy() {
        return this.measuresHierarchy;
    }

    public List<RolapMember> getMeasuresMembers() {
        return this.measuresHierarchy.getMemberReader().getMembers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Member createCalculatedMember(String xml) {
        Member calculatedMember;
        try {
            this.loadInProgress = true;
            calculatedMember = new RolapSchemaLoader(this.schema).createCalculatedMember(this, xml);
        }
        finally {
            this.loadInProgress = false;
        }
        return calculatedMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RolapMember createCalculatedMember(RolapHierarchy hierarchy, String name, Calc calc) {
        ArrayList<Id.Segment> segmentList = new ArrayList<Id.Segment>();
        segmentList.addAll(Util.parseIdentifier(hierarchy.getUniqueName()));
        segmentList.add(new Id.NameSegment(name));
        Formula formula = new Formula(new Id(segmentList), RolapCube.createDummyExp(calc), new MemberProperty[0]);
        Statement statement = this.schema.getInternalConnection().getInternalStatement();
        try {
            Query query = new Query(statement, this, new Formula[]{formula}, new QueryAxis[0], null, new QueryPart[0], new Parameter[0], false);
            query.createValidator().validate(formula);
            this.calculatedMemberList.add(formula);
            RolapMember rolapMember = (RolapMember)formula.getMdxMember();
            return rolapMember;
        }
        finally {
            statement.close();
        }
    }

    static Exp createDummyExp(final Calc calc) {
        return new ResolvedFunCall(new FunDefBase("dummy", null, "fn"){

            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                return calc;
            }
        }, new Exp[0], calc.getType());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RolapCubeSchemaReader
    extends RolapSchemaReader
    implements NameResolver.Namespace {
        public RolapCubeSchemaReader(Role role) {
            super(role, RolapCube.this.schema);
            assert (role != null) : "precondition: role != null";
        }

        @Override
        public List<Member> getLevelMembers(Level level, boolean includeCalculated) {
            List<Member> members = super.getLevelMembers(level, false);
            if (includeCalculated) {
                members = Util.addLevelCalculatedMembers(this, level, members);
            }
            return members;
        }

        @Override
        public int getLevelCardinality(Level _level, boolean approximate, boolean materialize) {
            int levelCardinality = super.getLevelCardinality(_level, approximate, materialize);
            return levelCardinality += this.getCalculatedMembers(_level).size();
        }

        @Override
        public Member getCalculatedMember(List<Id.Segment> nameParts) {
            String uniqueName = Util.implode(nameParts);
            for (Formula formula : RolapCube.this.calculatedMemberList) {
                String formulaUniqueName = formula.getMdxMember().getUniqueName();
                if (!formulaUniqueName.equals(uniqueName) || !this.getRole().canAccess(formula.getMdxMember())) continue;
                return formula.getMdxMember();
            }
            return null;
        }

        @Override
        public NamedSet getNamedSet(List<Id.Segment> segments) {
            if (segments.size() == 1) {
                Id.Segment segment = segments.get(0);
                for (Formula namedSet : RolapCube.this.namedSetList) {
                    if (!segment.matches(namedSet.getName())) continue;
                    return namedSet.getNamedSet();
                }
            }
            return super.getNamedSet(segments);
        }

        @Override
        public List<Member> getCalculatedMembers(Hierarchy hierarchy) {
            ArrayList<Member> list = new ArrayList<Member>();
            if (this.getRole().getAccess(hierarchy) == Access.NONE) {
                return list;
            }
            for (Member member : this.getCalculatedMembers()) {
                if (!member.getHierarchy().equals(hierarchy)) continue;
                list.add(member);
            }
            return list;
        }

        protected List<RolapMember> getCalculatedMembers(RolapCubeLevel level) {
            ArrayList<RolapMember> list = new ArrayList<RolapMember>();
            if (this.getRole().getAccess(level) == Access.NONE) {
                return list;
            }
            for (RolapMember member : this._getCalculatedMembers()) {
                if (!member.getLevel().equals(level)) continue;
                list.add(member);
            }
            return list;
        }

        @Override
        public List<Member> getCalculatedMembers(Level level) {
            return Util.cast(this.getCalculatedMembers((RolapCubeLevel)level));
        }

        protected List<RolapMember> _getCalculatedMembers() {
            ArrayList<RolapMember> list = (ArrayList<RolapMember>)RolapCube.this.roleToAccessibleCalculatedMembers.get(this.getRole());
            if (list == null) {
                list = new ArrayList<RolapMember>();
                for (Formula formula : RolapCube.this.calculatedMemberList) {
                    RolapMember member = (RolapMember)formula.getMdxMember();
                    if (!this.getRole().canAccess(member)) continue;
                    list.add(member);
                }
                if (list.size() > 0) {
                    RolapCube.this.roleToAccessibleCalculatedMembers.put(this.getRole(), list);
                }
            }
            return list;
        }

        @Override
        public List<Member> getCalculatedMembers() {
            return Util.cast(this._getCalculatedMembers());
        }

        @Override
        public SchemaReader withoutAccessControl() {
            assert (this.getClass() == RolapCubeSchemaReader.class) : "Derived class " + this.getClass() + " must override method";
            return RolapCube.this.getSchemaReader();
        }

        @Override
        public Member getMemberByUniqueName(List<Id.Segment> uniqueNameParts, boolean failIfNotFound, MatchType matchType) {
            Member member = (Member)this.lookupCompound(RolapCube.this, uniqueNameParts, failIfNotFound, 6, matchType);
            if (member == null) {
                assert (!failIfNotFound);
                return null;
            }
            if (this.getRole().canAccess(member)) {
                return member;
            }
            if (!failIfNotFound) {
                throw Util.newElementNotFoundException(6, new IdentifierNode(Util.toOlap4j(uniqueNameParts)));
            }
            return null;
        }

        @Override
        public Cube getCube() {
            return RolapCube.this;
        }

        @Override
        public List<NameResolver.Namespace> getNamespaces() {
            ArrayList<NameResolver.Namespace> list = new ArrayList<NameResolver.Namespace>();
            list.add(this);
            list.addAll(this.schema.getSchemaReader().getNamespaces());
            return list;
        }

        @Override
        public OlapElement lookupChild(OlapElement parent, IdentifierSegment segment, MatchType matchType) {
            return this.lookupChild(parent, segment);
        }

        @Override
        public OlapElement lookupChild(OlapElement parent, IdentifierSegment segment) {
            for (Formula formula : RolapCube.this.calculatedMemberList) {
                if (!NameResolver.matches(formula, parent, segment)) continue;
                return formula.getMdxMember();
            }
            if (parent == RolapCube.this) {
                for (Formula formula : RolapCube.this.namedSetList) {
                    if (!Util.matches(segment, formula.getName())) continue;
                    return formula.getNamedSet();
                }
            }
            return null;
        }
    }
}

