/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Arrays;
import mondrian.olap.Id;
import mondrian.rolap.DefaultMemberChildrenConstraint;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapStarSet;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.sql.SqlQuery;

class ChildByNameConstraint
extends DefaultMemberChildrenConstraint {
    final String childName;
    private final Object cacheKey;

    public ChildByNameConstraint(Id.NameSegment childName) {
        this.childName = childName.name;
        this.cacheKey = Arrays.asList(ChildByNameConstraint.class, childName);
    }

    public int hashCode() {
        return this.getCacheKey().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ChildByNameConstraint && this.getCacheKey().equals(((ChildByNameConstraint)obj).getCacheKey());
    }

    public void addLevelConstraint(SqlQuery query, RolapStarSet starSet, RolapCubeLevel level) {
        super.addLevelConstraint(query, starSet, level);
        query.addWhere(SqlConstraintUtils.constrainLevel(level.attribute.getNameExp(), query.getDialect(), this.childName, true));
    }

    public String toString() {
        return "ChildByNameConstraint(" + this.childName + ")";
    }

    public Object getCacheKey() {
        return this.cacheKey;
    }
}

