/*
 * Decompiled with CFR 0.152.
 */
package mondrian.parser;

import mondrian.olap.Exp;
import mondrian.olap.FunTable;
import mondrian.olap.MondrianException;
import mondrian.olap.QueryPart;
import mondrian.olap.Util;
import mondrian.parser.MdxParserImpl;
import mondrian.parser.MdxParserValidator;
import mondrian.parser.ParseException;
import mondrian.parser.QueryPartFactoryImpl;
import mondrian.server.Statement;

public class JavaccParserValidatorImpl
implements MdxParserValidator {
    protected final MdxParserValidator.QueryPartFactory factory;

    public JavaccParserValidatorImpl() {
        this(new QueryPartFactoryImpl());
    }

    public JavaccParserValidatorImpl(MdxParserValidator.QueryPartFactory factory) {
        this.factory = factory;
    }

    public QueryPart parseInternal(Statement statement, String queryString, boolean debug, FunTable funTable, boolean strictValidation) {
        MdxParserImpl mdxParser = new MdxParserImpl(this.factory, statement, queryString, debug, funTable, strictValidation);
        try {
            return mdxParser.statementEof();
        }
        catch (ParseException e) {
            throw this.convertException(queryString, e);
        }
    }

    public Exp parseExpression(Statement statement, String queryString, boolean debug, FunTable funTable) {
        MdxParserImpl mdxParser = new MdxParserImpl(this.factory, statement, queryString, debug, funTable, false);
        try {
            return mdxParser.expressionEof();
        }
        catch (ParseException e) {
            throw this.convertException(queryString, e);
        }
    }

    private RuntimeException convertException(String queryString, ParseException pe) {
        Exception e = pe.getMessage().startsWith("Encountered ") ? new MondrianException("Syntax error at line " + pe.currentToken.next.beginLine + ", column " + pe.currentToken.next.beginColumn + ", token '" + pe.currentToken.next.image + "'") : pe;
        return Util.newError(e, "While parsing " + queryString);
    }
}

