/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.impl.AbstractHierarchyCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.Type;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;

class DimensionsNumericFunDef
extends FunDefBase {
    public static final FunDefBase INSTANCE = new DimensionsNumericFunDef();

    private DimensionsNumericFunDef() {
        super("Dimensions", "Returns the hierarchy whose zero-based position within the cube is specified by a numeric expression.", "fhn");
    }

    public Type getResultType(Validator validator, Exp[] args) {
        return HierarchyType.Unknown;
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final IntegerCalc integerCalc = compiler.compileInteger(call.getArg(0));
        return new AbstractHierarchyCalc(call, new Calc[]{integerCalc}){

            public Hierarchy evaluateHierarchy(Evaluator evaluator) {
                int n = integerCalc.evaluateInteger(evaluator);
                return DimensionsNumericFunDef.this.nthHierarchy(evaluator, n);
            }
        };
    }

    RolapHierarchy nthHierarchy(Evaluator evaluator, int n) {
        RolapCube cube = (RolapCube)evaluator.getCube();
        if (n >= cube.getHierarchyList().size() || n < 0) {
            throw DimensionsNumericFunDef.newEvalException(this, "Index '" + n + "' out of bounds");
        }
        return cube.getHierarchyList().get(n);
    }
}

