/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import mondrian.calc.IterCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleIterable;
import mondrian.calc.TupleList;
import mondrian.calc.impl.DelegatingTupleList;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractAggregateFunDef
extends FunDefBase {
    public AbstractAggregateFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    protected Exp validateArg(Validator validator, Exp[] args, int i, int category) {
        Exp arg;
        if (i == 0 && MondrianProperties.instance().EnableExpCache.get() && FunUtil.worthCaching(arg = args[0])) {
            UnresolvedFunCall cacheCall = new UnresolvedFunCall("Cache", Syntax.Function, new Exp[]{arg});
            return validator.validate(cacheCall, false);
        }
        return super.validateArg(validator, args, i, category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static TupleList evaluateCurrentList(ListCalc listCalc, Evaluator evaluator) {
        TupleList dims;
        TupleList tuples;
        int savepoint = evaluator.savepoint();
        try {
            evaluator.setNonEmpty(false);
            tuples = listCalc.evaluateList(evaluator);
        }
        finally {
            evaluator.restore(savepoint);
        }
        int currLen = tuples.size();
        try {
            dims = AbstractAggregateFunDef.processUnrelatedDimensions(tuples, evaluator);
        }
        finally {
            evaluator.restore(savepoint);
        }
        AbstractAggregateFunDef.crossProd(evaluator, currLen);
        return dims;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TupleIterable evaluateCurrentIterable(IterCalc iterCalc, Evaluator evaluator) {
        TupleIterable iterable;
        int savepoint = evaluator.savepoint();
        int currLen = 0;
        try {
            evaluator.setNonEmpty(false);
            iterable = iterCalc.evaluateIterable(evaluator);
        }
        finally {
            evaluator.restore(savepoint);
        }
        AbstractAggregateFunDef.crossProd(evaluator, currLen);
        return iterable;
    }

    private static void crossProd(Evaluator evaluator, int currLen) {
        long iterationLimit = MondrianProperties.instance().IterationLimit.get();
        int productLen = currLen * evaluator.getIterationLength();
        if (iterationLimit > 0L && (long)productLen > iterationLimit) {
            throw MondrianResource.instance().IterationLimitExceeded.ex(iterationLimit);
        }
        evaluator.setIterationLength(currLen);
    }

    public static TupleList processUnrelatedDimensions(TupleList tuplesForAggregation, Evaluator evaluator) {
        if (tuplesForAggregation.size() == 0) {
            return tuplesForAggregation;
        }
        RolapMember measure = AbstractAggregateFunDef.getRolapMeasureForUnrelatedDimCheck(evaluator, tuplesForAggregation);
        if (measure.isCalculated()) {
            return tuplesForAggregation;
        }
        List<RolapMeasureGroup> cubeMeasureGroups = ((RolapCube)evaluator.getCube()).getMeasureGroups();
        if (cubeMeasureGroups != null && cubeMeasureGroups.size() > 1) {
            RolapMeasureGroup measureGroup = ((RolapBaseCubeMeasure)measure).getMeasureGroup();
            if (measureGroup == null) {
                return tuplesForAggregation;
            }
            if (measureGroup.ignoreUnrelatedDimensions) {
                return AbstractAggregateFunDef.ignoreUnrelatedDimensions(tuplesForAggregation, measureGroup);
            }
            if (MondrianProperties.instance().IgnoreMeasureForNonJoiningDimension.get()) {
                return AbstractAggregateFunDef.ignoreMeasureForNonJoiningDimension(tuplesForAggregation, measureGroup);
            }
        }
        return tuplesForAggregation;
    }

    private static RolapMember getRolapMeasureForUnrelatedDimCheck(Evaluator evaluator, TupleList tuplesForAggregation) {
        RolapMember measure = (RolapMember)evaluator.getMembers()[0];
        if (tuplesForAggregation != null && tuplesForAggregation.size() > 0) {
            for (Member tupMember : (List)tuplesForAggregation.get(0)) {
                if (!tupMember.isMeasure()) continue;
                measure = (RolapMember)tupMember;
            }
        }
        return measure;
    }

    private static TupleList ignoreMeasureForNonJoiningDimension(TupleList tuplesForAggregation, RolapMeasureGroup measureGroup) {
        Iterable<RolapCubeDimension> nonJoiningDimensions = AbstractAggregateFunDef.nonJoiningDimensions(measureGroup, tuplesForAggregation);
        if (nonJoiningDimensions.iterator().hasNext()) {
            return TupleCollections.emptyList(tuplesForAggregation.getArity());
        }
        return tuplesForAggregation;
    }

    private static TupleList ignoreUnrelatedDimensions(TupleList tuplesForAggregation, RolapMeasureGroup measureGroup) {
        HashSet<RolapCubeDimension> nonJoiningDimensions = new HashSet<RolapCubeDimension>();
        for (RolapCubeDimension dimension : AbstractAggregateFunDef.nonJoiningDimensions(measureGroup, tuplesForAggregation)) {
            nonJoiningDimensions.add(dimension);
        }
        LinkedHashSet processedTuples = new LinkedHashSet(tuplesForAggregation.size());
        Iterator i$ = tuplesForAggregation.iterator();
        while (i$.hasNext()) {
            ArrayList<Member> tuple;
            ArrayList<Member> tupleCopy = tuple = (ArrayList<Member>)i$.next();
            for (int j = 0; j < tuple.size(); ++j) {
                RolapCubeHierarchy hierarchy;
                RolapMember member = (RolapMember)tuple.get(j);
                if (!nonJoiningDimensions.contains(member.getDimension())) continue;
                if (tupleCopy == tuple) {
                    tupleCopy = new ArrayList<Member>(tuple);
                }
                if ((hierarchy = member.getHierarchy()).hasAll()) {
                    tupleCopy.set(j, hierarchy.getAllMember());
                    continue;
                }
                tupleCopy.set(j, hierarchy.getDefaultMember());
            }
            processedTuples.add(tupleCopy);
        }
        return new DelegatingTupleList(tuplesForAggregation.getArity(), new ArrayList<List<Member>>(processedTuples));
    }

    private static Iterable<RolapCubeDimension> nonJoiningDimensions(RolapMeasureGroup measureGroup, TupleList tuplesForAggregation) {
        List tuple = (List)tuplesForAggregation.get(0);
        return measureGroup.nonJoiningDimensions(tuple);
    }
}

