/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.userdefinedjavaclass;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.BlockingRowSet;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleRowException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepListener;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.Stream;
import org.pentaho.di.trans.step.errorhandling.StreamIcon;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.userdefinedjavaclass.FieldHelper;
import org.pentaho.di.trans.steps.userdefinedjavaclass.InfoStepDefinition;
import org.pentaho.di.trans.steps.userdefinedjavaclass.TargetStepDefinition;
import org.pentaho.di.trans.steps.userdefinedjavaclass.UsageParameter;
import org.pentaho.di.trans.steps.userdefinedjavaclass.UserDefinedJavaClass;
import org.pentaho.di.trans.steps.userdefinedjavaclass.UserDefinedJavaClassData;
import org.pentaho.di.trans.steps.userdefinedjavaclass.UserDefinedJavaClassMeta;
import org.pentaho.di.www.SocketRepository;

public abstract class TransformClassBase {
    private static Class<?> PKG = UserDefinedJavaClassMeta.class;
    protected boolean first = true;
    protected boolean updateRowMeta = true;
    protected UserDefinedJavaClass parent;
    protected UserDefinedJavaClassMeta meta;
    protected UserDefinedJavaClassData data;
    private final Map<String, FieldHelper> inFieldHelpers = new HashMap<String, FieldHelper>();
    private final Map<String, FieldHelper> infoFieldHelpers = new HashMap<String, FieldHelper>();
    private final Map<String, FieldHelper> outFieldHelpers = new HashMap<String, FieldHelper>();

    public TransformClassBase(UserDefinedJavaClass parent, UserDefinedJavaClassMeta meta, UserDefinedJavaClassData data) throws KettleStepException {
        this.parent = parent;
        this.meta = meta;
        this.data = data;
        try {
            data.inputRowMeta = this.getTransMeta().getPrevStepFields(this.getStepMeta()).clone();
            data.outputRowMeta = this.getTransMeta().getThisStepFields(this.getStepMeta(), null, data.inputRowMeta.clone());
            data.parameterMap = new HashMap<String, String>();
            for (UsageParameter usageParameter : meta.getUsageParameters()) {
                if (usageParameter.tag == null || usageParameter.value == null) continue;
                data.parameterMap.put(usageParameter.tag, usageParameter.value);
            }
            data.infoMap = new HashMap<String, String>();
            for (InfoStepDefinition infoStepDefinition : meta.getInfoStepDefinitions()) {
                if (infoStepDefinition.tag == null || infoStepDefinition.stepMeta == null || infoStepDefinition.stepMeta.getName() == null) continue;
                data.infoMap.put(infoStepDefinition.tag, infoStepDefinition.stepMeta.getName());
            }
            data.targetMap = new HashMap<String, String>();
            for (TargetStepDefinition targetStepDefinition : meta.getTargetStepDefinitions()) {
                if (targetStepDefinition.tag == null || targetStepDefinition.stepMeta == null || targetStepDefinition.stepMeta.getName() == null) continue;
                data.targetMap.put(targetStepDefinition.tag, targetStepDefinition.stepMeta.getName());
            }
        }
        catch (KettleStepException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void addResultFile(ResultFile resultFile) {
        this.parent.addResultFileImpl(resultFile);
    }

    public void addRowListener(RowListener rowListener) {
        this.parent.addRowListenerImpl(rowListener);
    }

    public void addStepListener(StepListener stepListener) {
        this.parent.addStepListenerImpl(stepListener);
    }

    public boolean checkFeedback(long lines) {
        return this.parent.checkFeedbackImpl(lines);
    }

    public void cleanup() {
        this.parent.cleanupImpl();
    }

    public long decrementLinesRead() {
        return this.parent.decrementLinesReadImpl();
    }

    public long decrementLinesWritten() {
        return this.parent.decrementLinesWrittenImpl();
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.parent.disposeImpl(smi, sdi);
    }

    public RowSet findInputRowSet(String sourceStep) throws KettleStepException {
        return this.parent.findInputRowSetImpl(sourceStep);
    }

    public RowSet findInputRowSet(String from, int fromcopy, String to, int tocopy) {
        return this.parent.findInputRowSetImpl(from, fromcopy, to, tocopy);
    }

    public RowSet findOutputRowSet(String targetStep) throws KettleStepException {
        return this.parent.findOutputRowSetImpl(targetStep);
    }

    public RowSet findOutputRowSet(String from, int fromcopy, String to, int tocopy) {
        return this.parent.findOutputRowSetImpl(from, fromcopy, to, tocopy);
    }

    public int getClusterSize() {
        return this.parent.getClusterSizeImpl();
    }

    public int getCopy() {
        return this.parent.getCopyImpl();
    }

    public RowMetaInterface getErrorRowMeta() {
        return this.parent.getErrorRowMetaImpl();
    }

    public long getErrors() {
        return this.parent.getErrorsImpl();
    }

    public RowMetaInterface getInputRowMeta() {
        return this.parent.getInputRowMetaImpl();
    }

    public List<RowSet> getInputRowSets() {
        return this.parent.getInputRowSetsImpl();
    }

    public long getLinesInput() {
        return this.parent.getLinesInputImpl();
    }

    public long getLinesOutput() {
        return this.parent.getLinesOutputImpl();
    }

    public long getLinesRead() {
        return this.parent.getLinesReadImpl();
    }

    public long getLinesRejected() {
        return this.parent.getLinesRejectedImpl();
    }

    public long getLinesSkipped() {
        return this.parent.getLinesSkippedImpl();
    }

    public long getLinesUpdated() {
        return this.parent.getLinesUpdatedImpl();
    }

    public long getLinesWritten() {
        return this.parent.getLinesWrittenImpl();
    }

    public List<RowSet> getOutputRowSets() {
        return this.parent.getOutputRowSetsImpl();
    }

    public String getPartitionID() {
        return this.parent.getPartitionIDImpl();
    }

    public Map<String, BlockingRowSet> getPartitionTargets() {
        return this.parent.getPartitionTargetsImpl();
    }

    public long getProcessed() {
        return this.parent.getProcessedImpl();
    }

    public int getRepartitioning() {
        return this.parent.getRepartitioningImpl();
    }

    public Map<String, ResultFile> getResultFiles() {
        return this.parent.getResultFilesImpl();
    }

    public Object[] getRow() throws KettleException {
        Object[] row = this.parent.getRowImpl();
        if (this.updateRowMeta) {
            RowMetaInterface inputRowMeta;
            this.data.inputRowMeta = inputRowMeta = this.parent.getInputRowMeta();
            this.data.outputRowMeta = inputRowMeta == null ? null : this.getTransMeta().getThisStepFields(this.getStepMeta(), null, inputRowMeta.clone());
            this.updateRowMeta = false;
        }
        return row;
    }

    public Object[] getRowFrom(RowSet rowSet) throws KettleStepException {
        return this.parent.getRowFromImpl(rowSet);
    }

    public List<RowListener> getRowListeners() {
        return this.parent.getRowListenersImpl();
    }

    public long getRuntime() {
        return this.parent.getRuntimeImpl();
    }

    public int getSlaveNr() {
        return this.parent.getSlaveNrImpl();
    }

    public SocketRepository getSocketRepository() {
        return this.parent.getSocketRepositoryImpl();
    }

    public BaseStepData.StepExecutionStatus getStatus() {
        return this.parent.getStatusImpl();
    }

    public String getStatusDescription() {
        return this.parent.getStatusDescriptionImpl();
    }

    public StepDataInterface getStepDataInterface() {
        return this.parent.getStepDataInterfaceImpl();
    }

    public String getStepID() {
        return this.parent.getStepIDImpl();
    }

    public List<StepListener> getStepListeners() {
        return this.parent.getStepListenersImpl();
    }

    public StepMeta getStepMeta() {
        return this.parent.getStepMetaImpl();
    }

    public String getStepname() {
        return this.parent.getStepnameImpl();
    }

    public Trans getTrans() {
        return this.parent.getTransImpl();
    }

    public TransMeta getTransMeta() {
        return this.parent.getTransMetaImpl();
    }

    public String getTypeId() {
        return this.parent.getTypeIdImpl();
    }

    public int getUniqueStepCountAcrossSlaves() {
        return this.parent.getUniqueStepCountAcrossSlavesImpl();
    }

    public int getUniqueStepNrAcrossSlaves() {
        return this.parent.getUniqueStepNrAcrossSlavesImpl();
    }

    public String getVariable(String variableName) {
        return this.parent.getVariableImpl(variableName);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.parent.getVariableImpl(variableName, defaultValue);
    }

    public long incrementLinesInput() {
        return this.parent.incrementLinesInputImpl();
    }

    public long incrementLinesOutput() {
        return this.parent.incrementLinesOutputImpl();
    }

    public long incrementLinesRead() {
        return this.parent.incrementLinesReadImpl();
    }

    public long incrementLinesRejected() {
        return this.parent.incrementLinesRejectedImpl();
    }

    public long incrementLinesSkipped() {
        return this.parent.incrementLinesSkippedImpl();
    }

    public long incrementLinesUpdated() {
        return this.parent.incrementLinesUpdatedImpl();
    }

    public long incrementLinesWritten() {
        return this.parent.incrementLinesWrittenImpl();
    }

    public boolean init(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        return this.parent.initImpl(stepMetaInterface, stepDataInterface);
    }

    public void initBeforeStart() throws KettleStepException {
        this.parent.initBeforeStartImpl();
    }

    public boolean isDistributed() {
        return this.parent.isDistributedImpl();
    }

    public boolean isInitialising() {
        return this.parent.isInitialisingImpl();
    }

    public boolean isPartitioned() {
        return this.parent.isPartitionedImpl();
    }

    public boolean isSafeModeEnabled() {
        return this.parent.isSafeModeEnabledImpl();
    }

    public boolean isStopped() {
        return this.parent.isStoppedImpl();
    }

    public boolean isUsingThreadPriorityManagment() {
        return this.parent.isUsingThreadPriorityManagmentImpl();
    }

    public void logBasic(String s) {
        this.parent.logBasicImpl(s);
    }

    public void logDebug(String s) {
        this.parent.logDebugImpl(s);
    }

    public void logDetailed(String s) {
        this.parent.logDetailedImpl(s);
    }

    public void logError(String s) {
        this.parent.logErrorImpl(s);
    }

    public void logError(String s, Throwable e) {
        this.parent.logErrorImpl(s, e);
    }

    public void logMinimal(String s) {
        this.parent.logMinimalImpl(s);
    }

    public void logRowlevel(String s) {
        this.parent.logRowlevelImpl(s);
    }

    public void logSummary() {
        this.parent.logSummaryImpl();
    }

    public void markStart() {
        this.parent.markStartImpl();
    }

    public void markStop() {
        this.parent.markStopImpl();
    }

    public void openRemoteInputStepSocketsOnce() throws KettleStepException {
        this.parent.openRemoteInputStepSocketsOnceImpl();
    }

    public void openRemoteOutputStepSocketsOnce() throws KettleStepException {
        this.parent.openRemoteOutputStepSocketsOnceImpl();
    }

    public boolean outputIsDone() {
        return this.parent.outputIsDoneImpl();
    }

    public abstract boolean processRow(StepMetaInterface var1, StepDataInterface var2) throws KettleException;

    public void putError(RowMetaInterface rowMeta, Object[] row, long nrErrors, String errorDescriptions, String fieldNames, String errorCodes) throws KettleStepException {
        this.parent.putErrorImpl(rowMeta, row, nrErrors, errorDescriptions, fieldNames, errorCodes);
    }

    public void putRow(RowMetaInterface row, Object[] data) throws KettleStepException {
        this.parent.putRowImpl(row, data);
    }

    public void putRowTo(RowMetaInterface rowMeta, Object[] row, RowSet rowSet) throws KettleStepException {
        this.parent.putRowToImpl(rowMeta, row, rowSet);
    }

    public void removeRowListener(RowListener rowListener) {
        this.parent.removeRowListenerImpl(rowListener);
    }

    public int rowsetInputSize() {
        return this.parent.rowsetInputSizeImpl();
    }

    public int rowsetOutputSize() {
        return this.parent.rowsetOutputSizeImpl();
    }

    public void safeModeChecking(RowMetaInterface row) throws KettleRowException {
        this.parent.safeModeCheckingImpl(row);
    }

    public void setErrors(long errors) {
        this.parent.setErrorsImpl(errors);
    }

    public void setInputRowMeta(RowMetaInterface rowMeta) {
        this.parent.setInputRowMetaImpl(rowMeta);
    }

    public void setInputRowSets(List<RowSet> inputRowSets) {
        this.parent.setInputRowSetsImpl(inputRowSets);
    }

    public void setLinesInput(long newLinesInputValue) {
        this.parent.setLinesInputImpl(newLinesInputValue);
    }

    public void setLinesOutput(long newLinesOutputValue) {
        this.parent.setLinesOutputImpl(newLinesOutputValue);
    }

    public void setLinesRead(long newLinesReadValue) {
        this.parent.setLinesReadImpl(newLinesReadValue);
    }

    public void setLinesRejected(long linesRejected) {
        this.parent.setLinesRejectedImpl(linesRejected);
    }

    public void setLinesSkipped(long newLinesSkippedValue) {
        this.parent.setLinesSkippedImpl(newLinesSkippedValue);
    }

    public void setLinesUpdated(long newLinesUpdatedValue) {
        this.parent.setLinesUpdatedImpl(newLinesUpdatedValue);
    }

    public void setLinesWritten(long newLinesWrittenValue) {
        this.parent.setLinesWrittenImpl(newLinesWrittenValue);
    }

    public void setOutputDone() {
        this.parent.setOutputDoneImpl();
    }

    public void setOutputRowSets(List<RowSet> outputRowSets) {
        this.parent.setOutputRowSetsImpl(outputRowSets);
    }

    public void setStepListeners(List<StepListener> stepListeners) {
        this.parent.setStepListenersImpl(stepListeners);
    }

    public void setVariable(String variableName, String variableValue) {
        this.parent.setVariableImpl(variableName, variableValue);
    }

    public void stopAll() {
        this.parent.stopAllImpl();
    }

    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
        this.parent.stopRunningImpl(stepMetaInterface, stepDataInterface);
    }

    public String toString() {
        return this.parent.toStringImpl();
    }

    public static String[] getInfoSteps() {
        return null;
    }

    public static void getFields(boolean clearResultFields, RowMetaInterface row, String originStepname, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, List<?> fields) throws KettleStepException {
        if (clearResultFields) {
            row.clear();
        }
        for (UserDefinedJavaClassMeta.FieldInfo fi : fields) {
            try {
                ValueMetaInterface v = ValueMetaFactory.createValueMeta((String)fi.name, (int)fi.type);
                v.setLength(fi.length);
                v.setPrecision(fi.precision);
                v.setOrigin(originStepname);
                row.addValueMeta(v);
            }
            catch (Exception e) {
                throw new KettleStepException((Throwable)e);
            }
        }
    }

    public static StepIOMetaInterface getStepIOMeta(UserDefinedJavaClassMeta meta) {
        StepIOMeta ioMeta = new StepIOMeta(true, true, true, false, true, true);
        for (InfoStepDefinition infoStepDefinition : meta.getInfoStepDefinitions()) {
            ioMeta.addStream(new Stream(StreamInterface.StreamType.INFO, infoStepDefinition.stepMeta, infoStepDefinition.description, StreamIcon.INFO, null));
        }
        for (TargetStepDefinition targetStepDefinition : meta.getTargetStepDefinitions()) {
            ioMeta.addStream(new Stream(StreamInterface.StreamType.TARGET, targetStepDefinition.stepMeta, targetStepDefinition.description, StreamIcon.TARGET, null));
        }
        return ioMeta;
    }

    public String getParameter(String tag) {
        if (tag == null) {
            return null;
        }
        return this.parent.environmentSubstitute(this.data.parameterMap.get(tag));
    }

    public RowSet findInfoRowSet(String tag) throws KettleException {
        if (tag == null) {
            return null;
        }
        String stepname = this.data.infoMap.get(tag);
        if (Utils.isEmpty((CharSequence)stepname)) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TransformClassBase.Exception.UnableToFindInfoStepNameForTag", (String[])new String[]{tag}));
        }
        RowSet rowSet = this.findInputRowSet(stepname);
        if (rowSet == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TransformClassBase.Exception.UnableToFindInfoRowSetForStep", (String[])new String[]{stepname}));
        }
        return rowSet;
    }

    public RowSet findTargetRowSet(String tag) throws KettleException {
        if (tag == null) {
            return null;
        }
        String stepname = this.data.targetMap.get(tag);
        if (Utils.isEmpty((CharSequence)stepname)) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TransformClassBase.Exception.UnableToFindTargetStepNameForTag", (String[])new String[]{tag}));
        }
        RowSet rowSet = this.findOutputRowSet(stepname);
        if (rowSet == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TransformClassBase.Exception.UnableToFindTargetRowSetForStep", (String[])new String[]{stepname}));
        }
        return rowSet;
    }

    public FieldHelper get(Fields type, String name) throws KettleStepException {
        FieldHelper fh;
        switch (type) {
            case In: {
                fh = this.inFieldHelpers.get(name);
                if (fh != null) break;
                try {
                    fh = new FieldHelper(this.data.inputRowMeta, name);
                }
                catch (IllegalArgumentException e) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"TransformClassBase.Exception.UnableToFindFieldHelper", (String[])new String[]{type.name(), name}));
                }
                this.inFieldHelpers.put(name, fh);
                break;
            }
            case Out: {
                fh = this.outFieldHelpers.get(name);
                if (fh != null) break;
                try {
                    fh = new FieldHelper(this.data.outputRowMeta, name);
                }
                catch (IllegalArgumentException e) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"TransformClassBase.Exception.UnableToFindFieldHelper", (String[])new String[]{type.name(), name}));
                }
                this.outFieldHelpers.put(name, fh);
                break;
            }
            case Info: {
                fh = this.infoFieldHelpers.get(name);
                if (fh != null) break;
                RowMetaInterface rmi = this.getTransMeta().getPrevInfoFields(this.getStepname());
                try {
                    fh = new FieldHelper(rmi, name);
                }
                catch (IllegalArgumentException e) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"TransformClassBase.Exception.UnableToFindFieldHelper", (String[])new String[]{type.name(), name}));
                }
                this.infoFieldHelpers.put(name, fh);
                break;
            }
            default: {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"TransformClassBase.Exception.InvalidFieldsType", (String[])new String[]{type.name(), name}));
            }
        }
        return fh;
    }

    public Object[] createOutputRow(Object[] inputRow, int outputRowSize) {
        if (this.meta.isClearingResultFields()) {
            return RowDataUtil.allocateRowData((int)outputRowSize);
        }
        return RowDataUtil.createResizedCopy((Object[])inputRow, (int)outputRowSize);
    }

    public static enum Fields {
        In,
        Out,
        Info;

    }
}

