/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.textfileoutput;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.WriterOutputStream;
import org.pentaho.di.core.compress.CompressionOutputStream;
import org.pentaho.di.core.compress.CompressionProvider;
import org.pentaho.di.core.compress.CompressionProviderFactory;
import org.pentaho.di.core.compress.zip.ZIPCompressionProvider;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.fileinput.CharsetToolkit;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.textfileoutput.TextFileField;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputData;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMeta;

public class TextFileOutput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = TextFileOutputMeta.class;
    private static final String FILE_COMPRESSION_TYPE_NONE = TextFileOutputMeta.fileCompressionTypeCodes[0];
    private static final boolean COMPATIBILITY_APPEND_NO_HEADER = "Y".equals(Const.NVL((String)System.getProperty("KETTLE_COMPATIBILITY_TEXT_FILE_OUTPUT_APPEND_NO_HEADER"), (String)"N"));
    public TextFileOutputMeta meta;
    public TextFileOutputData data;

    public TextFileOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private void initFieldNumbers(RowMetaInterface outputRowMeta, TextFileField[] outputFields) throws KettleException {
        this.data.fieldnrs = new int[outputFields.length];
        for (int i = 0; i < outputFields.length; ++i) {
            this.data.fieldnrs[i] = outputRowMeta.indexOfValue(outputFields[i].getName());
            if (this.data.fieldnrs[i] >= 0) continue;
            throw new KettleStepException("Field [" + outputFields[i].getName() + "] couldn't be found in the input stream!");
        }
    }

    public boolean isFileExists(String filename) throws KettleException {
        try {
            return this.getFileObject(filename, this.getTransMeta()).exists();
        }
        catch (Exception e) {
            throw new KettleException("Error opening new file : " + e.toString());
        }
    }

    private CompressionProvider getCompressionProvider() throws KettleException {
        CompressionProvider compressionProvider;
        String compressionType = this.meta.getFileCompression();
        if (Utils.isEmpty((CharSequence)compressionType)) {
            compressionType = FILE_COMPRESSION_TYPE_NONE;
        }
        if ((compressionProvider = CompressionProviderFactory.getInstance().getCompressionProviderByName(compressionType)) == null) {
            throw new KettleException("No compression provider found with name = " + compressionType);
        }
        if (!compressionProvider.supportsOutput()) {
            throw new KettleException("Compression provider " + compressionType + " does not support output streams!");
        }
        return compressionProvider;
    }

    private void initServletStreamWriter() throws KettleException {
        this.data.writer = null;
        try {
            PrintWriter writer = this.getTrans().getServletPrintWriter();
            this.data.writer = Utils.isEmpty((CharSequence)this.meta.getEncoding()) ? new WriterOutputStream((Writer)writer) : new WriterOutputStream((Writer)writer, this.meta.getEncoding());
        }
        catch (Exception e) {
            throw new KettleException("Error opening new file : " + e.toString());
        }
    }

    public void initFileStreamWriter(String filename) throws KettleException {
        this.data.writer = null;
        try {
            TextFileOutputData.FileStream fileStreams = null;
            try {
                boolean writingToFileForFirstTime;
                if (this.data.splitEvery > 0) {
                    if (filename.equals(this.data.getFileStreamsCollection().getLastFileName())) {
                        fileStreams = this.data.getFileStreamsCollection().getLastStream();
                    }
                } else {
                    fileStreams = this.data.getFileStreamsCollection().getStream(filename);
                }
                boolean bl = writingToFileForFirstTime = fileStreams == null;
                if (writingToFileForFirstTime) {
                    if (this.meta.isAddToResultFiles()) {
                        ResultFile resultFile = new ResultFile(0, this.getFileObject(filename, this.getTransMeta()), this.getTransMeta().getName(), this.getStepname());
                        resultFile.setComment(BaseMessages.getString(PKG, (String)"TextFileOutput.AddResultFile", (String[])new String[0]));
                        this.addResultFile(resultFile);
                    }
                    CompressionProvider compressionProvider = this.getCompressionProvider();
                    boolean isZipFile = compressionProvider instanceof ZIPCompressionProvider;
                    boolean createParentDirIfNotExists = this.meta.isCreateParentFolder();
                    boolean appendToExistingFile = this.meta.isFileAppended();
                    if (appendToExistingFile && isZipFile && this.isFileExists(filename)) {
                        throw new KettleException("Can not append to an existing zip file : " + filename);
                    }
                    int maxOpenFiles = this.getMaxOpenFiles();
                    if (maxOpenFiles > 0 && this.data.getFileStreamsCollection().getNumOpenFiles() >= maxOpenFiles) {
                        this.data.getFileStreamsCollection().closeOldestOpenFile(isZipFile);
                    }
                    if (createParentDirIfNotExists && (this.data.getFileStreamsCollection().size() == 0 || this.meta.isFileNameInField())) {
                        this.createParentFolder(filename);
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed("Opening output stream using provider: " + compressionProvider.getName());
                    }
                    OutputStream fileOutputStream = this.getOutputStream(filename, this.getTransMeta(), !isZipFile && appendToExistingFile);
                    CompressionOutputStream compressionOutputStream = compressionProvider.createOutputStream(fileOutputStream);
                    compressionOutputStream.addEntry(filename, this.environmentSubstitute(this.meta.getExtension()));
                    if (this.log.isDetailed()) {
                        if (!Utils.isEmpty((CharSequence)this.meta.getEncoding())) {
                            this.logDetailed("Opening output stream in encoding: " + this.meta.getEncoding());
                        } else {
                            this.logDetailed("Opening output stream in default encoding");
                        }
                    }
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(compressionOutputStream, 5000);
                    TextFileOutputData textFileOutputData = this.data;
                    textFileOutputData.getClass();
                    fileStreams = textFileOutputData.new TextFileOutputData.FileStream(fileOutputStream, compressionOutputStream, bufferedOutputStream);
                    this.data.getFileStreamsCollection().add(filename, fileStreams);
                    if (this.log.isDetailed()) {
                        this.logDetailed("Opened new file with name [" + KettleVFS.getFriendlyURI((String)filename) + "]");
                    }
                } else if (fileStreams.getBufferedOutputStream() == null) {
                    int maxOpenFiles = this.getMaxOpenFiles();
                    if (maxOpenFiles > 0 && this.data.getFileStreamsCollection().getNumOpenFiles() >= maxOpenFiles) {
                        this.data.getFileStreamsCollection().closeOldestOpenFile(false);
                    }
                    OutputStream fileOutputStream = this.getOutputStream(filename, this.getTransMeta(), true);
                    CompressionProvider compressionProvider = this.getCompressionProvider();
                    CompressionOutputStream compressionOutputStream = compressionProvider.createOutputStream(fileOutputStream);
                    compressionOutputStream.addEntry(filename, this.environmentSubstitute(this.meta.getExtension()));
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(compressionOutputStream, 5000);
                    fileStreams.setFileOutputStream(fileOutputStream);
                    fileStreams.setCompressedOutputStream(compressionOutputStream);
                    fileStreams.setBufferedOutputStream(bufferedOutputStream);
                }
            }
            catch (Exception e) {
                if (!(e instanceof KettleException)) {
                    throw new KettleException("Error opening new file : " + e.toString());
                }
                throw (KettleException)((Object)e);
            }
            fileStreams.setDirty(true);
            this.data.fos = fileStreams.getFileOutputStream();
            this.data.out = fileStreams.getCompressedOutputStream();
            this.data.writer = fileStreams.getBufferedOutputStream();
        }
        catch (KettleException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new KettleException("Error opening new file : " + e.toString());
        }
    }

    public String getOutputFileName(Object[] row) throws KettleException {
        String filename = null;
        if (row == null) {
            if (this.data.writer != null) {
                filename = this.data.getFileStreamsCollection().getLastFileName();
            } else {
                filename = this.meta.getFileName();
                if (filename == null) {
                    throw new KettleFileException(BaseMessages.getString(PKG, (String)"TextFileOutput.Exception.FileNameNotSet", (String[])new String[0]));
                }
                filename = this.buildFilename(this.environmentSubstitute(filename), true);
            }
        } else {
            this.data.fileNameFieldIndex = this.getInputRowMeta().indexOfValue(this.meta.getFileNameField());
            if (this.data.fileNameFieldIndex < 0) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"TextFileOutput.Exception.FileNameFieldNotFound", (String[])new String[]{this.meta.getFileNameField()}));
            }
            this.data.fileNameMeta = this.getInputRowMeta().getValueMeta(this.data.fileNameFieldIndex);
            this.data.fileName = this.data.fileNameMeta.getString(row[this.data.fileNameFieldIndex]);
            if (this.data.fileName == null) {
                throw new KettleFileException(BaseMessages.getString(PKG, (String)"TextFileOutput.Exception.FileNameNotSet", (String[])new String[0]));
            }
            filename = this.buildFilename(this.environmentSubstitute(this.data.fileName), true);
        }
        return filename;
    }

    public int getFlushInterval() {
        String var = this.getTransMeta().getVariable("KETTLE_FILE_OUTPUT_MAX_STREAM_LIFE");
        int flushInterval = 0;
        if (var != null) {
            try {
                flushInterval = Integer.parseInt(var);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return flushInterval;
    }

    public int getMaxOpenFiles() {
        String var = this.getTransMeta().getVariable("KETTLE_FILE_OUTPUT_MAX_STREAM_COUNT");
        int maxStreamCount = 0;
        if (var != null) {
            try {
                maxStreamCount = Integer.parseInt(var);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return maxStreamCount;
    }

    private boolean writeRowToServlet(Object[] row) throws KettleException {
        if (row != null) {
            if (this.data.writer == null) {
                this.initServletStreamWriter();
            }
            this.first = false;
            this.writeRow(this.data.outputRowMeta, row);
            this.putRow(this.data.outputRowMeta, row);
            if (this.checkFeedback(this.getLinesOutput())) {
                this.logBasic("linenr " + this.getLinesOutput());
            }
            return true;
        }
        if (this.data.writer == null && !Utils.isEmpty((CharSequence)this.environmentSubstitute(this.meta.getEndedLine()))) {
            this.initServletStreamWriter();
            this.initBinaryDataFields();
        }
        this.writeEndedLine();
        this.setOutputDone();
        return false;
    }

    public boolean isWriteHeader(String filename) throws KettleException {
        boolean writingToFileForFirstTime = this.first;
        boolean isWriteHeader = this.meta.isHeaderEnabled();
        if (isWriteHeader) {
            writingToFileForFirstTime = this.data.splitEvery > 0 ? (writingToFileForFirstTime |= !filename.equals(this.data.getFileStreamsCollection().getLastFileName())) : (writingToFileForFirstTime |= this.data.getFileStreamsCollection().getStream(filename) == null);
        }
        return isWriteHeader &= writingToFileForFirstTime && (!this.meta.isFileAppended() || !COMPATIBILITY_APPEND_NO_HEADER && !this.isFileExists(filename));
    }

    private boolean writeRowToFile(Object[] row) throws KettleException {
        if (row != null) {
            int flushInterval;
            String filename = this.getOutputFileName((Object[])(this.meta.isFileNameInField() ? row : null));
            boolean isWriteHeader = this.isWriteHeader(filename);
            if (this.data.writer == null || this.meta.isFileNameInField()) {
                this.initFileStreamWriter(filename);
            }
            this.first = false;
            if (isWriteHeader) {
                this.writeHeader();
            }
            if (!this.meta.isFileNameInField() && this.getLinesOutput() > 0L && this.data.splitEvery > 0 && (this.getLinesOutput() + (long)this.meta.getFooterShift()) % (long)this.data.splitEvery == 0L) {
                if (this.meta.isFooterEnabled()) {
                    this.writeHeader();
                }
                this.closeFile(filename);
                ++this.data.splitnr;
                this.data.fos = null;
                this.data.out = null;
                this.data.writer = null;
                filename = this.getOutputFileName(null);
                isWriteHeader = this.isWriteHeader(filename);
                this.initFileStreamWriter(filename);
                if (isWriteHeader) {
                    this.writeHeader();
                }
            }
            this.writeRow(this.data.outputRowMeta, row);
            this.putRow(this.data.outputRowMeta, row);
            if (this.checkFeedback(this.getLinesOutput())) {
                this.logBasic("linenr " + this.getLinesOutput());
            }
            if ((flushInterval = this.getFlushInterval()) > 0) {
                long currentTime = new Date().getTime();
                if (this.data.lastFileFlushTime == 0L) {
                    this.data.lastFileFlushTime = currentTime;
                } else if (this.data.lastFileFlushTime - currentTime > (long)flushInterval) {
                    try {
                        this.data.getFileStreamsCollection().flushOpenFiles(false);
                    }
                    catch (IOException e) {
                        throw new KettleException("Unable to flush open files", (Throwable)e);
                    }
                    this.data.lastFileFlushTime = new Date().getTime();
                }
            }
            return true;
        }
        if (this.data.writer != null) {
            if (this.data.outputRowMeta != null && this.meta.isFooterEnabled()) {
                this.writeHeader();
            }
        } else if (!Utils.isEmpty((CharSequence)this.environmentSubstitute(this.meta.getEndedLine())) && !this.meta.isFileNameInField()) {
            String filename = this.getOutputFileName(null);
            this.initFileStreamWriter(filename);
            this.initBinaryDataFields();
        }
        if (this.data.writer != null) {
            this.writeEndedLine();
        }
        try {
            this.flushOpenFiles(true);
        }
        catch (IOException e) {
            throw new KettleException("Unable to flush open files", (Throwable)e);
        }
        this.setOutputDone();
        return false;
    }

    public void flushOpenFiles(boolean closeAfterFlush) throws IOException {
        this.data.getFileStreamsCollection().flushOpenFiles(true);
    }

    @Override
    public synchronized boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] row;
        this.meta = (TextFileOutputMeta)smi;
        this.data = (TextFileOutputData)sdi;
        if (this.meta.getEncoding() == null || this.meta.getEncoding().isEmpty()) {
            this.meta.setEncoding(CharsetToolkit.getDefaultSystemCharset().name());
        }
        if ((row = this.getRow()) != null && this.first) {
            this.data.inputRowMeta = this.getInputRowMeta();
            this.data.outputRowMeta = this.data.inputRowMeta.clone();
        }
        if (this.first) {
            this.initBinaryDataFields();
            if (this.data.outputRowMeta != null) {
                this.initFieldNumbers(this.data.outputRowMeta, this.meta.getOutputFields());
                if (row != null) {
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                }
            }
        }
        return this.writeRowTo(row);
    }

    protected boolean writeRowTo(Object[] row) throws KettleException {
        if (this.meta.isServletOutput()) {
            return this.writeRowToServlet(row);
        }
        return this.writeRowToFile(row);
    }

    public void writeRow(RowMetaInterface rowMeta, Object[] r) throws KettleStepException {
        try {
            if (this.meta.getOutputFields() == null || this.meta.getOutputFields().length == 0) {
                for (int i = 0; i < rowMeta.size(); ++i) {
                    if (i > 0 && this.data.binarySeparator.length > 0) {
                        this.data.writer.write(this.data.binarySeparator);
                    }
                    ValueMetaInterface v = rowMeta.getValueMeta(i);
                    Object valueData = r[i];
                    this.writeField(v, valueData, null);
                }
                this.data.writer.write(this.data.binaryNewline);
            } else {
                for (int i = 0; i < this.meta.getOutputFields().length; ++i) {
                    if (i > 0 && this.data.binarySeparator.length > 0) {
                        this.data.writer.write(this.data.binarySeparator);
                    }
                    ValueMetaInterface v = rowMeta.getValueMeta(this.data.fieldnrs[i]);
                    Object valueData = r[this.data.fieldnrs[i]];
                    this.writeField(v, valueData, this.data.binaryNullValue[i]);
                }
                this.data.writer.write(this.data.binaryNewline);
            }
            this.incrementLinesOutput();
        }
        catch (Exception e) {
            throw new KettleStepException("Error writing line", (Throwable)e);
        }
    }

    private byte[] formatField(ValueMetaInterface v, Object valueData) throws KettleValueException {
        if (v.isString()) {
            if (v.isStorageBinaryString() && v.getTrimType() == 0 && v.getLength() < 0 && Utils.isEmpty((CharSequence)v.getStringEncoding())) {
                return (byte[])valueData;
            }
            String svalue = valueData instanceof String ? (String)valueData : v.getString(valueData);
            return this.convertStringToBinaryString(v, Const.trimToType((String)svalue, (int)v.getTrimType()));
        }
        return v.getBinaryString(valueData);
    }

    private byte[] convertStringToBinaryString(ValueMetaInterface v, String string) throws KettleValueException {
        byte[] text;
        int length = v.getLength();
        if (string == null) {
            return new byte[0];
        }
        if (length > -1 && length < string.length()) {
            String tmp = string.substring(0, length);
            if (Utils.isEmpty((CharSequence)v.getStringEncoding())) {
                return tmp.getBytes();
            }
            try {
                return tmp.getBytes(v.getStringEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new KettleValueException("Unable to convert String to Binary with specified string encoding [" + v.getStringEncoding() + "]", (Throwable)e);
            }
        }
        if (Utils.isEmpty((CharSequence)this.meta.getEncoding())) {
            text = string.getBytes();
        } else {
            try {
                text = string.getBytes(this.meta.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new KettleValueException("Unable to convert String to Binary with specified string encoding [" + v.getStringEncoding() + "]", (Throwable)e);
            }
        }
        if (length > string.length()) {
            int size = 0;
            byte[] filler = null;
            try {
                filler = !Utils.isEmpty((CharSequence)this.meta.getEncoding()) ? " ".getBytes(this.meta.getEncoding()) : " ".getBytes();
                size = text.length + filler.length * (length - string.length());
            }
            catch (UnsupportedEncodingException uee) {
                throw new KettleValueException((Throwable)uee);
            }
            byte[] bytes = new byte[size];
            System.arraycopy(text, 0, bytes, 0, text.length);
            if (filler.length == 1) {
                Arrays.fill(bytes, text.length, size, filler[0]);
            } else {
                int currIndex = text.length;
                for (int i = 0; i < length - string.length(); ++i) {
                    for (int j = 0; j < filler.length; ++j) {
                        bytes[currIndex++] = filler[j];
                    }
                }
            }
            return bytes;
        }
        return text;
    }

    private byte[] getBinaryString(String string) throws KettleStepException {
        try {
            if (this.data.hasEncoding) {
                return string.getBytes(this.meta.getEncoding());
            }
            return string.getBytes();
        }
        catch (Exception e) {
            throw new KettleStepException((Throwable)e);
        }
    }

    private void writeField(ValueMetaInterface v, Object valueData, byte[] nullString) throws KettleStepException {
        try {
            byte[] str = nullString != null && v.isNull(valueData) ? nullString : (this.meta.isFastDump() ? (valueData instanceof byte[] ? (byte[])valueData : this.getBinaryString(valueData == null ? "" : valueData.toString())) : this.formatField(v, valueData));
            if (str != null && str.length > 0) {
                List<Integer> enclosures = null;
                boolean writeEnclosures = false;
                if (v.isString()) {
                    if (this.meta.isEnclosureForced() && !this.meta.isPadded()) {
                        writeEnclosures = true;
                    } else if (!this.meta.isEnclosureFixDisabled() && this.containsSeparatorOrEnclosure(str, this.data.binarySeparator, this.data.binaryEnclosure)) {
                        writeEnclosures = true;
                    }
                }
                if (writeEnclosures) {
                    this.data.writer.write(this.data.binaryEnclosure);
                    enclosures = this.getEnclosurePositions(str);
                }
                if (enclosures == null) {
                    this.data.writer.write(str);
                } else {
                    int from = 0;
                    for (int i = 0; i < enclosures.size(); ++i) {
                        int position = enclosures.get(i);
                        this.data.writer.write(str, from, position + this.data.binaryEnclosure.length - from);
                        this.data.writer.write(this.data.binaryEnclosure);
                        from = position + this.data.binaryEnclosure.length;
                    }
                    if (from < str.length) {
                        this.data.writer.write(str, from, str.length - from);
                    }
                }
                if (writeEnclosures) {
                    this.data.writer.write(this.data.binaryEnclosure);
                }
            }
        }
        catch (Exception e) {
            throw new KettleStepException("Error writing field content to file", (Throwable)e);
        }
    }

    private List<Integer> getEnclosurePositions(byte[] str) {
        ArrayList<Integer> positions = null;
        if (this.data.binaryEnclosure != null && this.data.binaryEnclosure.length > 0) {
            int len = str.length - this.data.binaryEnclosure.length + 1;
            for (int i = 0; i < len; ++i) {
                boolean found = true;
                for (int x = 0; found && x < this.data.binaryEnclosure.length; ++x) {
                    if (str[i + x] == this.data.binaryEnclosure[x]) continue;
                    found = false;
                }
                if (!found) continue;
                if (positions == null) {
                    positions = new ArrayList<Integer>();
                }
                positions.add(i);
            }
        }
        return positions;
    }

    protected boolean writeEndedLine() {
        boolean retval = false;
        try {
            String sLine = this.environmentSubstitute(this.meta.getEndedLine());
            if (sLine != null && sLine.trim().length() > 0) {
                this.data.writer.write(this.getBinaryString(sLine));
                this.incrementLinesOutput();
            }
        }
        catch (Exception e) {
            this.logError("Error writing ended tag line: " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
            retval = true;
        }
        return retval;
    }

    protected boolean writeHeader() {
        boolean retval = false;
        RowMetaInterface r = this.data.outputRowMeta;
        try {
            if (this.meta.getOutputFields() != null && this.meta.getOutputFields().length > 0) {
                for (int i = 0; i < this.meta.getOutputFields().length; ++i) {
                    boolean writeEnclosure;
                    String fieldName = this.meta.getOutputFields()[i].getName();
                    ValueMetaInterface v = r.searchValueMeta(fieldName);
                    if (i > 0 && this.data.binarySeparator.length > 0) {
                        this.data.writer.write(this.data.binarySeparator);
                    }
                    boolean bl = writeEnclosure = this.meta.isEnclosureForced() && this.data.binaryEnclosure.length > 0 && v != null && v.isString() || !this.meta.isEnclosureFixDisabled() && this.containsSeparatorOrEnclosure(fieldName.getBytes(), this.data.binarySeparator, this.data.binaryEnclosure);
                    if (writeEnclosure) {
                        this.data.writer.write(this.data.binaryEnclosure);
                    }
                    this.data.writer.write(this.getBinaryString(fieldName));
                    if (!writeEnclosure) continue;
                    this.data.writer.write(this.data.binaryEnclosure);
                }
                this.data.writer.write(this.data.binaryNewline);
            } else if (r != null) {
                if (this.data.inputRowMeta != null) {
                    r = this.data.inputRowMeta;
                }
                for (int i = 0; i < r.size(); ++i) {
                    boolean writeEnclosure;
                    if (i > 0 && this.data.binarySeparator.length > 0) {
                        this.data.writer.write(this.data.binarySeparator);
                    }
                    ValueMetaInterface v = r.getValueMeta(i);
                    boolean bl = writeEnclosure = this.meta.isEnclosureForced() && this.data.binaryEnclosure.length > 0 && v != null && v.isString() || !this.meta.isEnclosureFixDisabled() && this.containsSeparatorOrEnclosure(v.getName().getBytes(), this.data.binarySeparator, this.data.binaryEnclosure);
                    if (writeEnclosure) {
                        this.data.writer.write(this.data.binaryEnclosure);
                    }
                    this.data.writer.write(this.getBinaryString(v.getName()));
                    if (!writeEnclosure) continue;
                    this.data.writer.write(this.data.binaryEnclosure);
                }
                this.data.writer.write(this.data.binaryNewline);
            } else {
                this.data.writer.write(this.getBinaryString("no rows selected" + Const.CR));
            }
        }
        catch (Exception e) {
            this.logError("Error writing header line: " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
            retval = true;
        }
        this.incrementLinesOutput();
        return retval;
    }

    public String buildFilename(String filename, boolean ziparchive) {
        return this.meta.buildFilename(filename, this.meta.getExtension(), this, this.getCopy(), this.getPartitionID(), this.data.splitnr, ziparchive, this.meta);
    }

    protected boolean closeFile(String filename) {
        try {
            this.data.getFileStreamsCollection().closeFile(filename);
        }
        catch (Exception e) {
            this.logError("Exception trying to close file: " + e.toString());
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    protected boolean closeFile() {
        boolean retval;
        try {
            if (this.data.writer != null) {
                this.data.getFileStreamsCollection().closeStream(this.data.writer);
            }
            this.data.writer = null;
            this.data.out = null;
            this.data.fos = null;
            if (this.log.isDebug()) {
                this.logDebug("Closing normal file ...");
            }
            retval = true;
        }
        catch (Exception e) {
            this.logError("Exception trying to close file: " + e.toString());
            this.setErrors(1L);
            this.data.writer = null;
            this.data.out = null;
            this.data.fos = null;
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TextFileOutputMeta)smi;
        this.data = (TextFileOutputData)sdi;
        if (this.getTransMeta().getNamedClusterEmbedManager() != null) {
            this.getTransMeta().getNamedClusterEmbedManager().passEmbeddedMetastoreKey(this.getTransMeta(), this.getTransMeta().getEmbeddedMetastoreProviderKey());
        }
        if (super.init(smi, sdi)) {
            this.data.splitnr = 0;
            if (!this.meta.isDoNotOpenNewFileInit() && !this.meta.isFileNameInField()) {
                try {
                    this.initOutput();
                }
                catch (Exception e) {
                    this.logError("Couldn't open file " + KettleVFS.getFriendlyURI((String)this.getParentVariableSpace().environmentSubstitute(this.meta.getFileName())) + "." + this.getParentVariableSpace().environmentSubstitute(this.meta.getExtension()), e);
                    this.setErrors(1L);
                    this.stopAll();
                }
            }
            try {
                this.initBinaryDataFields();
            }
            catch (Exception e) {
                this.logError("Couldn't initialize binary data fields", e);
                this.setErrors(1L);
                this.stopAll();
            }
            return true;
        }
        return false;
    }

    protected void initOutput() throws KettleException {
        if (this.meta.isServletOutput()) {
            this.initServletStreamWriter();
        } else {
            String filename = this.getOutputFileName(null);
            this.initFileStreamWriter(filename);
        }
    }

    protected void initBinaryDataFields() throws KettleException {
        try {
            this.data.hasEncoding = !Utils.isEmpty((CharSequence)this.meta.getEncoding());
            this.data.binarySeparator = new byte[0];
            this.data.binaryEnclosure = new byte[0];
            this.data.binaryNewline = new byte[0];
            if (this.data.hasEncoding) {
                if (!Utils.isEmpty((CharSequence)this.meta.getSeparator())) {
                    this.data.binarySeparator = this.environmentSubstitute(this.meta.getSeparator()).getBytes(this.meta.getEncoding());
                }
                if (!Utils.isEmpty((CharSequence)this.meta.getEnclosure())) {
                    this.data.binaryEnclosure = this.environmentSubstitute(this.meta.getEnclosure()).getBytes(this.meta.getEncoding());
                }
                if (!Utils.isEmpty((CharSequence)this.meta.getNewline())) {
                    this.data.binaryNewline = this.meta.getNewline().getBytes(this.meta.getEncoding());
                }
            } else {
                if (!Utils.isEmpty((CharSequence)this.meta.getSeparator())) {
                    this.data.binarySeparator = this.environmentSubstitute(this.meta.getSeparator()).getBytes();
                }
                if (!Utils.isEmpty((CharSequence)this.meta.getEnclosure())) {
                    this.data.binaryEnclosure = this.environmentSubstitute(this.meta.getEnclosure()).getBytes();
                }
                if (!Utils.isEmpty((CharSequence)this.meta.getNewline())) {
                    this.data.binaryNewline = this.environmentSubstitute(this.meta.getNewline()).getBytes();
                }
            }
            this.data.binaryNullValue = new byte[this.meta.getOutputFields().length][];
            for (int i = 0; i < this.meta.getOutputFields().length; ++i) {
                this.data.binaryNullValue[i] = null;
                String nullString = this.meta.getOutputFields()[i].getNullString();
                if (Utils.isEmpty((CharSequence)nullString)) continue;
                this.data.binaryNullValue[i] = this.data.hasEncoding ? nullString.getBytes(this.meta.getEncoding()) : nullString.getBytes();
            }
            this.data.splitEvery = this.meta.getSplitEvery(this.variables);
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error while encoding binary fields", (Throwable)e);
        }
    }

    protected void close() throws IOException {
        if (!this.meta.isServletOutput()) {
            this.data.getFileStreamsCollection().flushOpenFiles(true);
        }
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TextFileOutputMeta)smi;
        this.data = (TextFileOutputData)sdi;
        try {
            this.close();
        }
        catch (Exception e) {
            this.logError("Unexpected error closing file", e);
            this.setErrors(1L);
        }
        this.data.writer = null;
        this.data.out = null;
        this.data.fos = null;
        super.dispose(smi, sdi);
    }

    public boolean containsSeparatorOrEnclosure(byte[] source, byte[] separator, byte[] enclosure) {
        boolean separatorExists;
        boolean result = false;
        boolean enclosureExists = enclosure != null && enclosure.length > 0;
        boolean bl = separatorExists = separator != null && separator.length > 0;
        if (separatorExists || enclosureExists) {
            block0: for (int index = 0; !result && index < source.length; ++index) {
                int i;
                if (enclosureExists && source[index] == enclosure[0]) {
                    if (index + enclosure.length > source.length) continue;
                    result = true;
                    for (i = 1; i < enclosure.length; ++i) {
                        if (source[index + i] == enclosure[i]) continue;
                        result = false;
                        continue block0;
                    }
                    continue;
                }
                if (!separatorExists || source[index] != separator[0] || index + separator.length > source.length) continue;
                result = true;
                for (i = 1; i < separator.length; ++i) {
                    if (source[index + i] == separator[i]) continue;
                    result = false;
                    continue block0;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createParentFolder(String filename) throws Exception {
        block13: {
            FileObject parentfolder = null;
            try {
                parentfolder = this.getFileObject(filename, this.getTransMeta()).getParent();
                if (parentfolder.exists()) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"TextFileOutput.Log.ParentFolderExist", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)parentfolder)}));
                    }
                    break block13;
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"TextFileOutput.Log.ParentFolderNotExist", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)parentfolder)}));
                }
                if (this.meta.isCreateParentFolder()) {
                    parentfolder.createFolder();
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"TextFileOutput.Log.ParentFolderCreated", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)parentfolder)}));
                    }
                    break block13;
                }
                throw new KettleException(BaseMessages.getString(PKG, (String)"TextFileOutput.Log.ParentFolderNotExistCreateIt", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)parentfolder), KettleVFS.getFriendlyURI((String)filename)}));
            }
            finally {
                if (parentfolder != null) {
                    try {
                        parentfolder.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    protected FileObject getFileObject(String vfsFilename) throws KettleFileException {
        return KettleVFS.getFileObject((String)vfsFilename);
    }

    protected FileObject getFileObject(String vfsFilename, VariableSpace space) throws KettleFileException {
        return KettleVFS.getFileObject((String)vfsFilename, (VariableSpace)space);
    }

    protected OutputStream getOutputStream(String vfsFilename, VariableSpace space, boolean append) throws KettleFileException {
        return KettleVFS.getOutputStream((String)vfsFilename, (VariableSpace)space, (boolean)append);
    }
}

