/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.gui.AreaOwner;
import org.pentaho.di.core.gui.BasePainter;
import org.pentaho.di.core.gui.GCInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.gui.PrimitiveGCInterface;
import org.pentaho.di.core.gui.Rectangle;
import org.pentaho.di.core.gui.ScrollBarInterface;
import org.pentaho.di.core.injection.bean.BeanInjectionInfo;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPainterExtension;
import org.pentaho.di.trans.TransPainterFlyoutExtension;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.trans.step.StepStatus;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;

public class TransPainter
extends BasePainter<TransHopMeta, StepMeta> {
    private static Class<?> PKG = TransPainter.class;
    public static final String STRING_PARTITIONING_CURRENT_STEP = "PartitioningCurrentStep";
    public static final String STRING_REMOTE_INPUT_STEPS = "RemoteInputSteps";
    public static final String STRING_REMOTE_OUTPUT_STEPS = "RemoteOutputSteps";
    public static final String STRING_STEP_ERROR_LOG = "StepErrorLog";
    public static final String STRING_HOP_TYPE_COPY = "HopTypeCopy";
    public static final String STRING_ROW_DISTRIBUTION = "RowDistribution";
    private TransMeta transMeta;
    private Map<StepMeta, String> stepLogMap;
    private List<StepMeta> mouseOverSteps;
    private StepMeta startHopStep;
    private Point endHopLocation;
    private StepMeta endHopStep;
    private StepMeta noInputStep;
    private StreamInterface.StreamType candidateHopType;
    private boolean startErrorHopStep;
    private StepMeta showTargetStreamsStep;
    private Trans trans;
    private boolean slowStepIndicatorEnabled;
    public static final String[] magnificationDescriptions = new String[]{"  200% ", "  150% ", "  100% ", "  75% ", "  50% ", "  25% "};

    public TransPainter(GCInterface gc, TransMeta transMeta, Point area, ScrollBarInterface hori, ScrollBarInterface vert, TransHopMeta candidate, Point drop_candidate, Rectangle selrect, List<AreaOwner> areaOwners, List<StepMeta> mouseOverSteps, int iconsize, int linewidth, int gridsize, int shadowSize, boolean antiAliasing, String noteFontName, int noteFontHeight, Trans trans, boolean slowStepIndicatorEnabled) {
        super(gc, transMeta, area, hori, vert, drop_candidate, selrect, areaOwners, iconsize, linewidth, gridsize, shadowSize, antiAliasing, noteFontName, noteFontHeight);
        this.transMeta = transMeta;
        this.candidate = candidate;
        this.mouseOverSteps = mouseOverSteps;
        this.trans = trans;
        this.slowStepIndicatorEnabled = slowStepIndicatorEnabled;
        this.stepLogMap = null;
    }

    public TransPainter(GCInterface gc, TransMeta transMeta, Point area, ScrollBarInterface hori, ScrollBarInterface vert, TransHopMeta candidate, Point drop_candidate, Rectangle selrect, List<AreaOwner> areaOwners, List<StepMeta> mouseOverSteps, int iconsize, int linewidth, int gridsize, int shadowSize, boolean antiAliasing, String noteFontName, int noteFontHeight) {
        this(gc, transMeta, area, hori, vert, candidate, drop_candidate, selrect, areaOwners, mouseOverSteps, iconsize, linewidth, gridsize, shadowSize, antiAliasing, noteFontName, noteFontHeight, new Trans(transMeta), false);
    }

    private static String[] getPeekTitles() {
        String[] titles = new String[]{BaseMessages.getString(PKG, (String)"PeekMetric.Column.Copynr", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Read", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Written", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Input", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Output", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Updated", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Rejected", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Errors", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Active", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Time", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.Speed", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PeekMetric.Column.PriorityBufferSizes", (String[])new String[0])};
        return titles;
    }

    public void buildTransformationImage() {
        Point max = this.transMeta.getMaximum();
        Point thumb = this.getThumb(this.area, max);
        this.offset = this.getOffset(thumb, this.area);
        this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
        this.gc.fillRectangle(0, 0, this.area.x, this.area.y);
        if (this.shadowSize > 0) {
            this.shadow = true;
            this.gc.setTransform(this.translationX, this.translationY, this.shadowSize, this.magnification);
            this.gc.setAlpha(20);
            this.drawTrans(thumb);
        }
        this.shadow = false;
        this.gc.setTransform(this.translationX, this.translationY, 0, this.magnification);
        this.gc.setAlpha(255);
        this.drawTrans(thumb);
        this.gc.dispose();
    }

    private void drawTrans(Point thumb) {
        StepMeta stepMeta;
        int i;
        Point end;
        Point start;
        Point to;
        Point fr;
        int i2;
        if (!this.shadow && this.gridSize > 1) {
            this.drawGrid();
        }
        if (this.hori != null && this.vert != null) {
            this.hori.setThumb(thumb.x);
            this.vert.setThumb(thumb.y);
        }
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.TransPainterStart.id, (Object)this);
        }
        catch (KettleException e) {
            LogChannel.GENERAL.logError("Error in TransPainterStart extension point", (Throwable)e);
        }
        this.gc.setFont(PrimitiveGCInterface.EFont.NOTE);
        for (i2 = 0; i2 < this.transMeta.nrNotes(); ++i2) {
            NotePadMeta ni = this.transMeta.getNote(i2);
            this.drawNote(ni);
        }
        this.gc.setFont(PrimitiveGCInterface.EFont.GRAPH);
        this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
        for (i2 = 0; i2 < this.transMeta.nrTransHops(); ++i2) {
            TransHopMeta hi = this.transMeta.getTransHop(i2);
            this.drawHop(hi);
        }
        if (this.candidate != null) {
            this.drawHop((TransHopMeta)this.candidate, true);
        } else if (this.startHopStep != null && this.endHopLocation != null) {
            PrimitiveGCInterface.EImage arrow;
            fr = this.startHopStep.getLocation();
            to = this.endHopLocation;
            if (this.endHopStep == null) {
                this.gc.setForeground(PrimitiveGCInterface.EColor.GRAY);
                arrow = PrimitiveGCInterface.EImage.ARROW_DISABLED;
            } else {
                this.gc.setForeground(PrimitiveGCInterface.EColor.BLUE);
                arrow = PrimitiveGCInterface.EImage.ARROW_DEFAULT;
            }
            start = this.real2screen(fr.x + this.iconsize / 2, fr.y + this.iconsize / 2);
            end = this.real2screen(to.x, to.y);
            this.drawArrow(arrow, start.x, start.y, end.x, end.y, this.theta, this.calcArrowLength(), 1.2, (TransHopMeta)null, (Object)this.startHopStep, this.endHopStep == null ? this.endHopLocation : this.endHopStep);
        } else if (this.endHopStep != null && this.endHopLocation != null) {
            PrimitiveGCInterface.EImage arrow;
            fr = this.endHopLocation;
            to = this.endHopStep.getLocation();
            if (this.startHopStep == null) {
                this.gc.setForeground(PrimitiveGCInterface.EColor.GRAY);
                arrow = PrimitiveGCInterface.EImage.ARROW_DISABLED;
            } else {
                this.gc.setForeground(PrimitiveGCInterface.EColor.BLUE);
                arrow = PrimitiveGCInterface.EImage.ARROW_DEFAULT;
            }
            start = this.real2screen(fr.x, fr.y);
            end = this.real2screen(to.x + this.iconsize / 2, to.y + this.iconsize / 2);
            this.drawArrow(arrow, start.x, start.y, end.x, end.y, this.theta, this.calcArrowLength(), 1.2, (TransHopMeta)null, this.startHopStep == null ? this.endHopLocation : this.startHopStep, (Object)this.endHopStep);
        }
        for (i = 0; i < this.transMeta.nrSteps(); ++i) {
            stepMeta = this.transMeta.getStep(i);
            if (!stepMeta.isDrawn()) continue;
            this.drawStep(stepMeta);
        }
        if (this.slowStepIndicatorEnabled) {
            for (i = 0; i < this.transMeta.nrSteps(); ++i) {
                stepMeta = this.transMeta.getStep(i);
                if (!stepMeta.isDrawn()) continue;
                this.checkDrawSlowStepIndicator(stepMeta);
            }
        }
        for (i = 0; i < this.transMeta.nrSteps(); ++i) {
            stepMeta = this.transMeta.getStep(i);
            if (!stepMeta.isDrawn()) continue;
            this.drawStepStatusIndicator(stepMeta);
        }
        for (i = 0; i < this.transMeta.nrSteps(); ++i) {
            stepMeta = this.transMeta.getStep(i);
            if (!stepMeta.isDrawn()) continue;
            this.drawStepPerformanceTable(stepMeta);
        }
        int selectedStepsCount = 0;
        for (int i3 = this.transMeta.nrSteps() - 1; i3 >= 0; --i3) {
            StepMeta stepMeta2 = this.transMeta.getStep(i3);
            if (!stepMeta2.isSelected()) continue;
            ++selectedStepsCount;
        }
        TransPainterFlyoutExtension extension = null;
        for (int i4 = this.transMeta.nrSteps() - 1; i4 >= 0; --i4) {
            StepMeta stepMeta3 = this.transMeta.getStep(i4);
            if (!stepMeta3.isSelected() || !stepMeta3.isDrawn() || selectedStepsCount != 1) continue;
            extension = new TransPainterFlyoutExtension(this.gc, this.areaOwners, this.transMeta, stepMeta3, this.translationX, this.translationY, this.magnification, this.area, this.offset);
            break;
        }
        if (extension == null) {
            extension = new TransPainterFlyoutExtension(this.gc, this.areaOwners, this.transMeta, null, this.translationX, this.translationY, this.magnification, this.area, this.offset);
        }
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.TransPainterFlyout.id, extension);
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error calling extension point(s) for the transformation painter step", (Throwable)e);
        }
        if (this.noInputStep != null) {
            this.gc.setLineWidth(2);
            this.gc.setForeground(PrimitiveGCInterface.EColor.RED);
            Point n = this.noInputStep.getLocation();
            this.gc.drawLine(n.x - 5, n.y - 5, n.x + this.iconsize + 10, n.y + this.iconsize + 10);
            this.gc.drawLine(n.x - 5, n.y + this.iconsize + 5, n.x + this.iconsize + 5, n.y - 5);
        }
        if (this.drop_candidate != null) {
            this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.SOLID);
            this.gc.setForeground(PrimitiveGCInterface.EColor.BLACK);
            Point screen = this.real2screen(this.drop_candidate.x, this.drop_candidate.y);
            this.gc.drawRectangle(screen.x, screen.y, this.iconsize, this.iconsize);
        }
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.TransPainterEnd.id, (Object)this);
        }
        catch (KettleException e) {
            LogChannel.GENERAL.logError("Error in TransPainterEnd extension point", (Throwable)e);
        }
        if (!this.shadow) {
            this.drawRect(this.selrect);
        }
    }

    private void checkDrawSlowStepIndicator(StepMeta stepMeta) {
        if (stepMeta == null) {
            return;
        }
        if (this.trans != null) {
            Point pt = stepMeta.getLocation();
            if (pt == null) {
                pt = new Point(50, 50);
            }
            Point screen = this.real2screen(pt.x, pt.y);
            int x = screen.x;
            int y = screen.y;
            List<StepInterface> steps = this.trans.findBaseSteps(stepMeta.getName());
            for (StepInterface step : steps) {
                if (step.isRunning()) {
                    int outputRows;
                    boolean isSlow;
                    int inputRows = step.rowsetInputSize();
                    boolean bl = isSlow = (double)inputRows * 0.85 > (double)(outputRows = step.rowsetOutputSize());
                    if (isSlow) {
                        this.gc.setLineWidth(this.linewidth + 1);
                        if (System.currentTimeMillis() % 2000L > 1000L) {
                            this.gc.setForeground(PrimitiveGCInterface.EColor.BACKGROUND);
                            this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.SOLID);
                            this.gc.drawRectangle(x + 1, y + 1, this.iconsize - 2, this.iconsize - 2);
                            this.gc.setForeground(PrimitiveGCInterface.EColor.DARKGRAY);
                            this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.DOT);
                            this.gc.drawRectangle(x + 1, y + 1, this.iconsize - 2, this.iconsize - 2);
                        } else {
                            this.gc.setForeground(PrimitiveGCInterface.EColor.DARKGRAY);
                            this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.SOLID);
                            this.gc.drawRectangle(x + 1, y + 1, this.iconsize - 2, this.iconsize - 2);
                            this.gc.setForeground(PrimitiveGCInterface.EColor.BACKGROUND);
                            this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.DOT);
                            this.gc.drawRectangle(x + 1, y + 1, this.iconsize - 2, this.iconsize - 2);
                        }
                    }
                }
                this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.SOLID);
            }
        }
    }

    private void drawStepPerformanceTable(StepMeta stepMeta) {
        if (stepMeta == null) {
            return;
        }
        if (this.trans != null) {
            Point pt = stepMeta.getLocation();
            if (pt == null) {
                pt = new Point(50, 50);
            }
            Point screen = this.real2screen(pt.x, pt.y);
            int x = screen.x;
            int y = screen.y;
            List<StepInterface> steps = this.trans.findBaseSteps(stepMeta.getName());
            if (this.trans.isRunning() && stepMeta.isSelected()) {
                String[] titles;
                int popupX = x;
                int popupY = y;
                int popupWidth = 0;
                int popupHeight = 1;
                this.gc.setFont(PrimitiveGCInterface.EFont.SMALL);
                Point p = this.gc.textExtent("0000000000");
                int colWidth = p.x + 5;
                int rowHeight = p.y + 5;
                int titleWidth = 0;
                for (String title : titles = TransPainter.getPeekTitles()) {
                    Point titleExtent = this.gc.textExtent(title);
                    titleWidth = Math.max(titleExtent.x + 5, titleWidth);
                    popupHeight += titleExtent.y + 5;
                }
                popupWidth = titleWidth + 10;
                popupY = popupY - popupHeight - 5;
                this.gc.setForeground(PrimitiveGCInterface.EColor.DARKGRAY);
                this.gc.setBackground(PrimitiveGCInterface.EColor.LIGHTGRAY);
                this.gc.setLineWidth(1);
                this.gc.fillRoundRectangle(popupX += (this.iconsize - (popupWidth += steps.size() * colWidth)) / 2, popupY, popupWidth, popupHeight, 7, 7);
                this.gc.setBackground(PrimitiveGCInterface.EColor.LIGHTGRAY);
                this.gc.drawRoundRectangle(popupX, popupY, popupWidth, popupHeight, 7, 7);
                int barY = popupY;
                for (int i = 0; i < titles.length; ++i) {
                    if (i % 2 == 1) {
                        this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
                    } else {
                        this.gc.setBackground(PrimitiveGCInterface.EColor.LIGHTGRAY);
                    }
                    this.gc.fillRoundRectangle(popupX + 1, barY + 1, popupWidth - 2, rowHeight, 7, 7);
                    barY += rowHeight;
                }
                int rowY = popupY + 5;
                int rowX = popupX + 5;
                this.gc.setForeground(PrimitiveGCInterface.EColor.BLACK);
                this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
                for (int i = 0; i < titles.length; ++i) {
                    if (i % 2 == 1) {
                        this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
                    } else {
                        this.gc.setBackground(PrimitiveGCInterface.EColor.LIGHTGRAY);
                    }
                    this.gc.drawText(titles[i], rowX, rowY);
                    rowY += rowHeight;
                }
                this.gc.setBackground(PrimitiveGCInterface.EColor.LIGHTGRAY);
                rowX += titleWidth;
                for (StepInterface step : steps) {
                    rowX += colWidth;
                    rowY = popupY + 5;
                    StepStatus stepStatus = new StepStatus(step);
                    String[] fields = stepStatus.getPeekFields();
                    for (int i = 0; i < fields.length; ++i) {
                        if (i % 2 == 1) {
                            this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
                        } else {
                            this.gc.setBackground(PrimitiveGCInterface.EColor.LIGHTGRAY);
                        }
                        this.drawTextRightAligned(fields[i], rowX, rowY);
                        rowY += rowHeight;
                    }
                }
            }
        }
    }

    private void drawStepStatusIndicator(StepMeta stepMeta) {
        if (stepMeta == null) {
            return;
        }
        if (this.trans != null) {
            Point pt = stepMeta.getLocation();
            if (pt == null) {
                pt = new Point(50, 50);
            }
            Point screen = this.real2screen(pt.x, pt.y);
            int x = screen.x;
            int y = screen.y;
            List<StepInterface> steps = this.trans.findBaseSteps(stepMeta.getName());
            for (StepInterface step : steps) {
                if (!step.getStatus().equals((Object)BaseStepData.StepExecutionStatus.STATUS_FINISHED)) continue;
                this.gc.drawImage(PrimitiveGCInterface.EImage.TRUE, x + this.iconsize - 8 + 4, y - 8 - 1, this.magnification);
            }
        }
    }

    private void drawTextRightAligned(String txt, int x, int y) {
        int off = this.gc.textExtent((String)txt).x;
        this.gc.drawText(txt, x -= off, y);
    }

    private void drawHop(TransHopMeta hi) {
        this.drawHop(hi, false);
    }

    private void drawHop(TransHopMeta hi, boolean isCandidate) {
        StepMeta fs = hi.getFromStep();
        StepMeta ts = hi.getToStep();
        if (fs != null && ts != null) {
            this.drawLine(fs, ts, hi, isCandidate);
        }
    }

    private void drawStep(StepMeta stepMeta) {
        Point point;
        Point textExtent;
        String log;
        if (stepMeta == null) {
            return;
        }
        boolean isDeprecated = stepMeta.isDeprecated();
        int alpha = this.gc.getAlpha();
        StepIOMetaInterface ioMeta = stepMeta.getStepMetaInterface().getStepIOMeta();
        Point pt = stepMeta.getLocation();
        if (pt == null) {
            pt = new Point(50, 50);
        }
        Point screen = this.real2screen(pt.x, pt.y);
        int x = screen.x;
        int y = screen.y;
        boolean stepError = false;
        if (this.stepLogMap != null && !this.stepLogMap.isEmpty() && !Utils.isEmpty((CharSequence)(log = this.stepLogMap.get(stepMeta)))) {
            stepError = true;
        }
        if (!stepMeta.getRemoteInputSteps().isEmpty()) {
            this.gc.setLineWidth(1);
            this.gc.setForeground(PrimitiveGCInterface.EColor.GRAY);
            this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
            this.gc.setFont(PrimitiveGCInterface.EFont.GRAPH);
            String nrInput = Integer.toString(stepMeta.getRemoteInputSteps().size());
            textExtent = this.gc.textExtent(nrInput);
            textExtent.x += 2;
            textExtent.y += 2;
            point = new Point(x - this.iconsize - this.iconsize / 2, y - this.iconsize);
            this.gc.drawRectangle(point.x, point.y, textExtent.x, textExtent.y);
            this.gc.drawText(nrInput, point.x + 1, point.y + 1);
            this.gc.drawLine(point.x + textExtent.x, point.y + textExtent.y / 2, x - this.iconsize / 2, point.y + textExtent.y / 2);
            this.drawArrow(PrimitiveGCInterface.EImage.ARROW_DISABLED, x - this.iconsize / 2, point.y + textExtent.y / 2, x + this.iconsize / 3, y, Math.toRadians(15.0), 15, 1.8, (TransHopMeta)null, (Object)null, (Object)null);
            if (!this.shadow) {
                this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.REMOTE_INPUT_STEP, point.x, point.y, textExtent.x, textExtent.y, this.offset, (Object)stepMeta, (Object)STRING_REMOTE_INPUT_STEPS));
            }
        }
        if (!stepMeta.getRemoteOutputSteps().isEmpty()) {
            this.gc.setLineWidth(1);
            this.gc.setForeground(PrimitiveGCInterface.EColor.GRAY);
            this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
            this.gc.setFont(PrimitiveGCInterface.EFont.GRAPH);
            String nrOutput = Integer.toString(stepMeta.getRemoteOutputSteps().size());
            textExtent = this.gc.textExtent(nrOutput);
            textExtent.x += 2;
            textExtent.y += 2;
            point = new Point(x + 2 * this.iconsize + this.iconsize / 2 - textExtent.x, y - this.iconsize);
            this.gc.drawRectangle(point.x, point.y, textExtent.x, textExtent.y);
            this.gc.drawText(nrOutput, point.x + 1, point.y + 1);
            this.gc.drawLine(point.x, point.y + textExtent.y / 2, x + this.iconsize + this.iconsize / 2, point.y + textExtent.y / 2);
            this.drawArrow(PrimitiveGCInterface.EImage.ARROW_DISABLED, x + 2 * this.iconsize / 3, y, x + this.iconsize + this.iconsize / 2, point.y + textExtent.y / 2, Math.toRadians(15.0), 15, 1.8, (TransHopMeta)null, (Object)null, (Object)null);
            if (!this.shadow) {
                this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.REMOTE_OUTPUT_STEP, point.x, point.y, textExtent.x, textExtent.y, this.offset, (Object)stepMeta, (Object)STRING_REMOTE_OUTPUT_STEPS));
            }
        }
        if (stepMeta.isPartitioned()) {
            this.gc.setLineWidth(1);
            this.gc.setForeground(PrimitiveGCInterface.EColor.RED);
            this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
            this.gc.setFont(PrimitiveGCInterface.EFont.GRAPH);
            PartitionSchema partitionSchema = stepMeta.getStepPartitioningMeta().getPartitionSchema();
            if (partitionSchema != null) {
                String nrInput = partitionSchema.isDynamicallyDefined() ? "Dx" + partitionSchema.getNumberOfPartitionsPerSlave() : "Px" + Integer.toString(partitionSchema.getPartitionIDs().size());
                Point textExtent2 = this.gc.textExtent(nrInput);
                textExtent2.x += 2;
                textExtent2.y += 2;
                Point point2 = new Point(x - this.iconsize - this.iconsize / 2, y - this.iconsize - this.iconsize);
                this.gc.drawRectangle(point2.x, point2.y, textExtent2.x, textExtent2.y);
                this.gc.drawText(nrInput, point2.x + 1, point2.y + 1);
                this.gc.drawLine(point2.x + textExtent2.x, point2.y + textExtent2.y / 2, x - this.iconsize / 2, point2.y + textExtent2.y / 2);
                this.gc.drawLine(x - this.iconsize / 2, point2.y + textExtent2.y / 2, x + this.iconsize / 3, y);
                this.gc.setForeground(PrimitiveGCInterface.EColor.GRAY);
                this.gc.drawText(Const.NVL((String)partitionSchema.getName(), (String)"<no partition name>"), point2.x, point2.y + textExtent2.y + 3, true);
                if (!this.shadow) {
                    this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_PARTITIONING, point2.x, point2.y, textExtent2.x, textExtent2.y, this.offset, (Object)stepMeta, (Object)STRING_PARTITIONING_CURRENT_STEP));
                }
            }
        }
        String name = stepMeta.getName();
        if (stepMeta.isSelected()) {
            this.gc.setLineWidth(this.linewidth + 2);
        } else {
            this.gc.setLineWidth(this.linewidth);
        }
        if (!this.shadow) {
            this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_ICON, x, y, this.iconsize, this.iconsize, this.offset, (Object)this.transMeta, (Object)stepMeta));
        }
        this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
        this.gc.fillRoundRectangle(x - 1, y - 1, this.iconsize + 1, this.iconsize + 1, 8, 8);
        this.gc.drawStepIcon(x, y, stepMeta, this.magnification);
        if (stepError || stepMeta.isMissing()) {
            this.gc.setForeground(PrimitiveGCInterface.EColor.RED);
        } else if (isDeprecated) {
            this.gc.setForeground(PrimitiveGCInterface.EColor.DEPRECATED);
        } else {
            this.gc.setForeground(PrimitiveGCInterface.EColor.CRYSTAL);
        }
        if (stepMeta.isSelected()) {
            if (isDeprecated) {
                this.gc.setForeground(PrimitiveGCInterface.EColor.DEPRECATED);
            } else {
                this.gc.setForeground(0, 93, 166);
            }
        }
        this.gc.drawRoundRectangle(x - 1, y - 1, this.iconsize + 1, this.iconsize + 1, 8, 8);
        Point namePosition = this.getNamePosition(name, screen, this.iconsize);
        if (stepMeta.isSelected()) {
            int tmpAlpha = this.gc.getAlpha();
            this.gc.setAlpha(192);
            this.gc.setBackground(216, 230, 241);
            this.gc.fillRoundRectangle(namePosition.x - 8, namePosition.y - 2, this.gc.textExtent((String)name).x + 15, 25, 25, 25);
            this.gc.setAlpha(tmpAlpha);
        }
        this.gc.setForeground(PrimitiveGCInterface.EColor.BLACK);
        this.gc.setFont(PrimitiveGCInterface.EFont.GRAPH);
        this.gc.drawText(name, namePosition.x, namePosition.y + 2, true);
        boolean partitioned = false;
        StepPartitioningMeta meta = stepMeta.getStepPartitioningMeta();
        if (stepMeta.isPartitioned() && meta != null) {
            partitioned = true;
        }
        String clusterMessage = "";
        if (stepMeta.getClusterSchema() != null) {
            clusterMessage = "C";
            clusterMessage = stepMeta.getClusterSchema().isDynamic() ? clusterMessage + "xN" : clusterMessage + "x" + stepMeta.getClusterSchema().findNrSlaves();
            Point textExtent3 = this.gc.textExtent(clusterMessage);
            this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
            this.gc.setForeground(PrimitiveGCInterface.EColor.BLACK);
            this.gc.drawText(clusterMessage, x - textExtent3.x + 1, y - textExtent3.y + 1);
        }
        if (!stepMeta.getCopiesString().equals("1") && !partitioned) {
            this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
            this.gc.setForeground(PrimitiveGCInterface.EColor.BLACK);
            String copies = "x" + stepMeta.getCopiesString();
            Point textExtent4 = this.gc.textExtent(copies);
            if (stepMeta.getClusterSchema() != null) {
                Point clusterTextExtent = this.gc.textExtent(clusterMessage);
                this.gc.drawText(copies, x - textExtent4.x + 1, y - textExtent4.y - clusterTextExtent.y + 1, false);
                this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_COPIES_TEXT, x - textExtent4.x + 1, y - textExtent4.y - clusterTextExtent.y + 1, textExtent4.x, textExtent4.y, this.offset, (Object)this.transMeta, (Object)stepMeta));
            } else {
                this.gc.drawText(copies, x - textExtent4.x + 1, y - textExtent4.y + 1, false);
                this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_COPIES_TEXT, x - textExtent4.x + 1, y - textExtent4.y + 1, textExtent4.x, textExtent4.y, this.offset, (Object)this.transMeta, (Object)stepMeta));
            }
        }
        if (stepError) {
            String log2 = this.stepLogMap.get(stepMeta);
            int xError = x + this.iconsize - 8 + 4;
            int yError = y - 8 - 1;
            Point ib = this.gc.getImageBounds(PrimitiveGCInterface.EImage.STEP_ERROR_RED);
            this.gc.drawImage(PrimitiveGCInterface.EImage.STEP_ERROR_RED, xError, yError, this.magnification);
            if (!this.shadow) {
                this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_ERROR_RED_ICON, pt.x + this.iconsize - 3, pt.y - 8, ib.x, ib.y, this.offset, (Object)log2, (Object)STRING_STEP_ERROR_LOG));
            }
        }
        if (this.mouseOverSteps.contains(stepMeta) && !stepMeta.isDeprecated()) {
            this.gc.setTransform(this.translationX, this.translationY, 0, 1.0f);
            StepMetaInterface stepMetaInterface = stepMeta.getStepMetaInterface();
            boolean mdiSupport = stepMetaInterface.getStepMetaInjectionInterface() != null || BeanInjectionInfo.isInjectionSupported(stepMetaInterface.getClass());
            PrimitiveGCInterface.EImage[] miniIcons = mdiSupport ? new PrimitiveGCInterface.EImage[]{PrimitiveGCInterface.EImage.INPUT, PrimitiveGCInterface.EImage.EDIT, PrimitiveGCInterface.EImage.CONTEXT_MENU, PrimitiveGCInterface.EImage.OUTPUT, PrimitiveGCInterface.EImage.INJECT} : new PrimitiveGCInterface.EImage[]{PrimitiveGCInterface.EImage.INPUT, PrimitiveGCInterface.EImage.EDIT, PrimitiveGCInterface.EImage.CONTEXT_MENU, PrimitiveGCInterface.EImage.OUTPUT};
            int totalHeight = 0;
            int totalIconsWidth = 0;
            int totalWidth = 10;
            for (PrimitiveGCInterface.EImage miniIcon : miniIcons) {
                Point bounds = this.gc.getImageBounds(miniIcon);
                totalWidth += bounds.x + 5;
                totalIconsWidth += bounds.x + 5;
                if (bounds.y <= totalHeight) continue;
                totalHeight = bounds.y;
            }
            totalHeight += 10;
            this.gc.setFont(PrimitiveGCInterface.EFont.SMALL);
            String trimmedName = stepMeta.getName().length() < 30 ? stepMeta.getName() : stepMeta.getName().substring(0, 30);
            Point nameExtent = this.gc.textExtent(trimmedName);
            nameExtent.y += 10;
            nameExtent.x += 15;
            totalHeight += nameExtent.y;
            if (nameExtent.x > totalWidth) {
                totalWidth = nameExtent.x;
            }
            int areaX = this.translateToCurrentScale(x) + this.translateToCurrentScale(this.iconsize) / 2 - totalWidth / 2 + 0;
            int areaY = this.translateToCurrentScale(y) + this.translateToCurrentScale(this.iconsize) + 4 + 4;
            this.gc.setForeground(PrimitiveGCInterface.EColor.CRYSTAL);
            this.gc.setBackground(PrimitiveGCInterface.EColor.CRYSTAL);
            this.gc.setLineWidth(1);
            this.gc.fillRoundRectangle(areaX, areaY, totalWidth, totalHeight, 10, 10);
            this.gc.setBackground(PrimitiveGCInterface.EColor.WHITE);
            this.gc.fillRoundRectangle(areaX, areaY + nameExtent.y, totalWidth, totalHeight - nameExtent.y, 10, 10);
            this.gc.fillRectangle(areaX, areaY + nameExtent.y, totalWidth, (totalHeight - nameExtent.y) / 2);
            this.gc.drawRoundRectangle(areaX, areaY, totalWidth, totalHeight, 10, 10);
            this.gc.setForeground(PrimitiveGCInterface.EColor.WHITE);
            this.gc.drawText(trimmedName, areaX + (totalWidth - nameExtent.x) / 2 + 5, areaY + 5, true);
            this.gc.setForeground(PrimitiveGCInterface.EColor.CRYSTAL);
            this.gc.setBackground(PrimitiveGCInterface.EColor.CRYSTAL);
            this.gc.setFont(PrimitiveGCInterface.EFont.GRAPH);
            this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.MINI_ICONS_BALLOON, this.translateTo1To1(areaX), this.translateTo1To1(areaY), this.translateTo1To1(totalWidth), this.translateTo1To1(totalHeight), this.offset, (Object)stepMeta, (Object)ioMeta));
            this.gc.fillPolygon(new int[]{areaX + totalWidth / 2 - 10 + 1, areaY + 2, areaX + totalWidth / 2 + 10, areaY + 2, areaX + totalWidth / 2 - 0, areaY - 4 - 3});
            this.gc.setBackground(PrimitiveGCInterface.EColor.WHITE);
            int xIcon = areaX + (totalWidth - totalIconsWidth) / 2 + 5;
            int yIcon = areaY + 5 + nameExtent.y;
            for (int i = 0; i < miniIcons.length; ++i) {
                PrimitiveGCInterface.EImage miniIcon = miniIcons[i];
                Point bounds = this.gc.getImageBounds(miniIcon);
                boolean enabled = false;
                switch (i) {
                    case 0: {
                        enabled = ioMeta.isInputAcceptor() || ioMeta.isInputDynamic();
                        this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_INPUT_HOP_ICON, this.translateTo1To1(xIcon), this.translateTo1To1(yIcon), this.translateTo1To1(bounds.x), this.translateTo1To1(bounds.y), this.offset, (Object)stepMeta, (Object)ioMeta));
                        break;
                    }
                    case 1: {
                        enabled = true;
                        this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_EDIT_ICON, this.translateTo1To1(xIcon), this.translateTo1To1(yIcon), this.translateTo1To1(bounds.x), this.translateTo1To1(bounds.y), this.offset, (Object)stepMeta, (Object)ioMeta));
                        break;
                    }
                    case 2: {
                        enabled = true;
                        this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_MENU_ICON, this.translateTo1To1(xIcon), this.translateTo1To1(yIcon), this.translateTo1To1(bounds.x), this.translateTo1To1(bounds.y), this.offset, (Object)stepMeta, (Object)ioMeta));
                        break;
                    }
                    case 3: {
                        enabled = ioMeta.isOutputProducer() || ioMeta.isOutputDynamic();
                        this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_OUTPUT_HOP_ICON, this.translateTo1To1(xIcon), this.translateTo1To1(yIcon), this.translateTo1To1(bounds.x), this.translateTo1To1(bounds.y), this.offset, (Object)stepMeta, (Object)ioMeta));
                        break;
                    }
                    case 4: {
                        enabled = mdiSupport;
                        StepMetaInterface mdiObject = mdiSupport ? stepMetaInterface : null;
                        this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_INJECT_ICON, this.translateTo1To1(xIcon), this.translateTo1To1(yIcon), this.translateTo1To1(bounds.x), this.translateTo1To1(bounds.y), this.offset, (Object)stepMeta, (Object)mdiObject));
                        break;
                    }
                }
                if (enabled) {
                    this.gc.setAlpha(255);
                } else {
                    this.gc.setAlpha(100);
                }
                this.gc.drawImage(miniIcon, xIcon, yIcon, 1.0f);
                xIcon += bounds.x + 5;
            }
            if (this.showTargetStreamsStep != null) {
                ioMeta = this.showTargetStreamsStep.getStepMetaInterface().getStepIOMeta();
                List<StreamInterface> targetStreams = ioMeta.getTargetStreams();
                int targetsWidth = 0;
                int targetsHeight = 0;
                for (int i = 0; i < targetStreams.size(); ++i) {
                    String description = targetStreams.get(i).getDescription();
                    Point extent = this.gc.textExtent(description);
                    if (extent.x > targetsWidth) {
                        targetsWidth = extent.x;
                    }
                    targetsHeight += extent.y + 5;
                }
                this.gc.setBackground(PrimitiveGCInterface.EColor.LIGHTGRAY);
                this.gc.fillRoundRectangle(areaX, areaY + totalHeight + 2, targetsWidth += 5, targetsHeight, 7, 7);
                this.gc.drawRoundRectangle(areaX, areaY + totalHeight + 2, targetsWidth, targetsHeight, 7, 7);
                int targetY = areaY + totalHeight + 5;
                for (int i = 0; i < targetStreams.size(); ++i) {
                    String description = targetStreams.get(i).getDescription();
                    Point extent = this.gc.textExtent(description);
                    this.gc.drawText(description, areaX + 5, targetY, true);
                    if (i < targetStreams.size() - 1) {
                        this.gc.drawLine(areaX + 2, targetY + extent.y + 3, areaX + targetsWidth - 2, targetY + extent.y + 2);
                    }
                    this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_TARGET_HOP_ICON_OPTION, areaX, targetY, targetsWidth, extent.y + 5, this.offset, (Object)stepMeta, (Object)targetStreams.get(i)));
                    targetY += extent.y + 5;
                }
                this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
            }
            this.gc.setTransform(this.translationX, this.translationY, 0, this.magnification);
        }
        TransPainterExtension extension = new TransPainterExtension(this.gc, this.shadow, this.areaOwners, this.transMeta, stepMeta, null, x, y, 0, 0, 0, 0, this.offset, this.iconsize);
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.TransPainterStep.id, (Object)extension);
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error calling extension point(s) for the transformation painter step", (Throwable)e);
        }
        this.gc.setAlpha(alpha);
    }

    public Point getNamePosition(String string, Point screen, int iconsize) {
        Point textsize = this.gc.textExtent(string);
        int xpos = screen.x + iconsize / 2 - textsize.x / 2;
        int ypos = screen.y + iconsize + 5;
        return new Point(xpos, ypos);
    }

    private void drawLine(StepMeta fs, StepMeta ts, TransHopMeta hi, boolean is_candidate) {
        StepIOMetaInterface ioMeta;
        List<StreamInterface> infoStreams;
        PrimitiveGCInterface.EImage arrow;
        PrimitiveGCInterface.EColor col;
        int[] line = this.getLine(fs, ts);
        PrimitiveGCInterface.ELineStyle linestyle = PrimitiveGCInterface.ELineStyle.SOLID;
        int activeLinewidth = this.linewidth;
        if (is_candidate) {
            col = PrimitiveGCInterface.EColor.BLUE;
            arrow = PrimitiveGCInterface.EImage.ARROW_CANDIDATE;
        } else if (hi.isEnabled()) {
            if (fs.isSendingErrorRowsToStep(ts)) {
                col = PrimitiveGCInterface.EColor.RED;
                linestyle = PrimitiveGCInterface.ELineStyle.DASH;
                activeLinewidth = this.linewidth + 1;
                arrow = PrimitiveGCInterface.EImage.ARROW_ERROR;
            } else {
                col = PrimitiveGCInterface.EColor.HOP_DEFAULT;
                arrow = PrimitiveGCInterface.EImage.ARROW_DEFAULT;
            }
        } else {
            col = PrimitiveGCInterface.EColor.GRAY;
            arrow = PrimitiveGCInterface.EImage.ARROW_DISABLED;
        }
        if (hi.split) {
            activeLinewidth = this.linewidth + 2;
        }
        if (!(infoStreams = (ioMeta = ts.getStepMetaInterface().getStepIOMeta()).getInfoStreams()).isEmpty()) {
            for (StreamInterface stream : infoStreams) {
                if (!fs.getName().equalsIgnoreCase(stream.getStepname()) || fs.getCopies() <= 1) continue;
                col = PrimitiveGCInterface.EColor.RED;
                arrow = PrimitiveGCInterface.EImage.ARROW_ERROR;
            }
        }
        this.gc.setForeground(col);
        this.gc.setLineStyle(linestyle);
        this.gc.setLineWidth(activeLinewidth);
        this.drawArrow(arrow, line, hi, fs, ts);
        if (hi.split) {
            this.gc.setLineWidth(this.linewidth);
        }
        this.gc.setForeground(PrimitiveGCInterface.EColor.BLACK);
        this.gc.setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
        this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.SOLID);
    }

    @Override
    protected void drawArrow(PrimitiveGCInterface.EImage arrow, int x1, int y1, int x2, int y2, double theta, int size, double factor, TransHopMeta transHop, Object startObject, Object endObject) {
        boolean q4;
        this.gc.drawLine(x1, y1, x2, y2);
        int mx = x1 + (x2 - x1) / 2;
        int my = y1 + (y2 - y1) / 2;
        int a = Math.abs(x2 - x1);
        int b = Math.abs(y2 - y1);
        int dist = (int)Math.sqrt(a * a + b * b);
        if (factor < 0.0) {
            factor = dist >= 2 * this.iconsize ? 1.3 : 1.2;
        }
        mx = (int)((double)x1 + factor * (double)(x2 - x1) / 2.0);
        my = (int)((double)y1 + factor * (double)(y2 - y1) / 2.0);
        double angle = Math.atan2(y2 - y1, x2 - x1) + 1.5707963267948966;
        boolean q1 = Math.toDegrees(angle) >= 0.0 && Math.toDegrees(angle) <= 90.0;
        boolean q2 = Math.toDegrees(angle) > 90.0 && Math.toDegrees(angle) <= 180.0;
        boolean q3 = Math.toDegrees(angle) > 180.0 && Math.toDegrees(angle) <= 270.0;
        boolean bl = q4 = Math.toDegrees(angle) > 270.0 || Math.toDegrees(angle) < 0.0;
        if (q1 || q3) {
            this.gc.drawImage(arrow, mx + 1, my, this.magnification, angle);
        } else if (q2 || q4) {
            this.gc.drawImage(arrow, mx, my, this.magnification, angle);
        }
        if (startObject instanceof StepMeta && endObject instanceof StepMeta) {
            Point bounds;
            StepIOMetaInterface ioMeta;
            boolean targetHop;
            factor = 0.8;
            StepMeta fs = (StepMeta)startObject;
            StepMeta ts = (StepMeta)endObject;
            mx = (int)((double)x1 + factor * (double)(x2 - x1) / 2.0) - 8;
            my = (int)((double)y1 + factor * (double)(y2 - y1) / 2.0) - 8;
            boolean errorHop = fs.isSendingErrorRowsToStep(ts) || this.startErrorHopStep && fs.equals(this.startHopStep);
            boolean bl2 = targetHop = Const.indexOfString((String)ts.getName(), (String[])fs.getStepMetaInterface().getStepIOMeta().getTargetStepnames()) >= 0;
            if (targetHop) {
                ioMeta = fs.getStepMetaInterface().getStepIOMeta();
                StreamInterface targetStream = ioMeta.findTargetStream(ts);
                if (targetStream != null) {
                    PrimitiveGCInterface.EImage hopsIcon = BasePainter.getStreamIconImage(targetStream.getStreamIcon());
                    Point bounds2 = this.gc.getImageBounds(hopsIcon);
                    this.gc.drawImage(hopsIcon, mx, my, this.magnification);
                    if (!this.shadow) {
                        this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.STEP_TARGET_HOP_ICON, mx, my, bounds2.x, bounds2.y, this.offset, (Object)fs, (Object)targetStream));
                    }
                }
            } else if (fs.isDistributes() && fs.getRowDistribution() != null && !ts.getStepPartitioningMeta().isMethodMirror() && !errorHop) {
                PrimitiveGCInterface.EImage eImage = fs.getRowDistribution().getDistributionImage();
                if (eImage != null) {
                    Point bounds3 = this.gc.getImageBounds(eImage);
                    this.gc.drawImage(eImage, mx, my, this.magnification);
                    if (!this.shadow) {
                        this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.ROW_DISTRIBUTION_ICON, mx, my, bounds3.x, bounds3.y, this.offset, (Object)fs, (Object)STRING_ROW_DISTRIBUTION));
                    }
                    mx += 16;
                }
            } else if (!(fs.isDistributes() || ts.getStepPartitioningMeta().isMethodMirror() || errorHop)) {
                bounds = this.gc.getImageBounds(PrimitiveGCInterface.EImage.COPY_ROWS);
                this.gc.drawImage(PrimitiveGCInterface.EImage.COPY_ROWS, mx, my, this.magnification);
                if (!this.shadow) {
                    this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.HOP_COPY_ICON, mx, my, bounds.x, bounds.y, this.offset, (Object)fs, (Object)STRING_HOP_TYPE_COPY));
                }
                mx += 16;
            }
            if (errorHop) {
                bounds = this.gc.getImageBounds(PrimitiveGCInterface.EImage.COPY_ROWS);
                this.gc.drawImage(PrimitiveGCInterface.EImage.FALSE, mx, my, this.magnification);
                if (!this.shadow) {
                    this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.HOP_ERROR_ICON, mx, my, bounds.x, bounds.y, this.offset, (Object)fs, (Object)ts));
                }
                mx += 16;
            }
            ioMeta = ts.getStepMetaInterface().getStepIOMeta();
            CharSequence[] infoStepnames = ioMeta.getInfoStepnames();
            if (this.candidateHopType == StreamInterface.StreamType.INFO && ts.equals(this.endHopStep) && fs.equals(this.startHopStep) || Const.indexOfString((String)fs.getName(), (String[])infoStepnames) >= 0) {
                Point bounds4 = this.gc.getImageBounds(PrimitiveGCInterface.EImage.INFO);
                this.gc.drawImage(PrimitiveGCInterface.EImage.INFO, mx, my, this.magnification);
                if (!this.shadow) {
                    this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.HOP_INFO_ICON, mx, my, bounds4.x, bounds4.y, this.offset, (Object)fs, (Object)ts));
                }
                mx += 16;
            }
            if (!Utils.isEmpty((CharSequence[])infoStepnames)) {
                for (CharSequence infoStep : infoStepnames) {
                    if (!fs.getName().equalsIgnoreCase((String)infoStep) || fs.getCopies() <= 1) continue;
                    this.gc.drawImage(PrimitiveGCInterface.EImage.ERROR, mx, my, this.magnification);
                    if (!this.shadow) {
                        this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.HOP_INFO_STEP_COPIES_ERROR, mx, my, 16, 16, this.offset, (Object)fs, (Object)ts));
                    }
                    mx += 16;
                }
            }
        }
        TransPainterExtension extension = new TransPainterExtension(this.gc, this.shadow, this.areaOwners, this.transMeta, null, transHop, x1, y1, x2, y2, mx, my, this.offset, this.iconsize);
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.TransPainterArrow.id, (Object)extension);
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error calling extension point(s) for the transformation painter arrow", (Throwable)e);
        }
    }

    public Map<StepMeta, String> getStepLogMap() {
        return this.stepLogMap;
    }

    public void setStepLogMap(Map<StepMeta, String> stepLogMap) {
        this.stepLogMap = stepLogMap;
    }

    public void setStartHopStep(StepMeta startHopStep) {
        this.startHopStep = startHopStep;
    }

    public void setEndHopLocation(Point endHopLocation) {
        this.endHopLocation = endHopLocation;
    }

    public void setNoInputStep(StepMeta noInputStep) {
        this.noInputStep = noInputStep;
    }

    public void setEndHopStep(StepMeta endHopStep) {
        this.endHopStep = endHopStep;
    }

    public void setCandidateHopType(StreamInterface.StreamType candidateHopType) {
        this.candidateHopType = candidateHopType;
    }

    public void setStartErrorHopStep(boolean startErrorHopStep) {
        this.startErrorHopStep = startErrorHopStep;
    }

    public StepMeta getShowTargetStreamsStep() {
        return this.showTargetStreamsStep;
    }

    public void setShowTargetStreamsStep(StepMeta showTargetStreamsStep) {
        this.showTargetStreamsStep = showTargetStreamsStep;
    }

    public TransMeta getTransMeta() {
        return this.transMeta;
    }

    public void setTransMeta(TransMeta transMeta) {
        this.transMeta = transMeta;
    }

    public List<StepMeta> getMouseOverSteps() {
        return this.mouseOverSteps;
    }

    public void setMouseOverSteps(List<StepMeta> mouseOverSteps) {
        this.mouseOverSteps = mouseOverSteps;
    }

    public Trans getTrans() {
        return this.trans;
    }

    public void setTrans(Trans trans) {
        this.trans = trans;
    }

    public boolean isSlowStepIndicatorEnabled() {
        return this.slowStepIndicatorEnabled;
    }

    public void setSlowStepIndicatorEnabled(boolean slowStepIndicatorEnabled) {
        this.slowStepIndicatorEnabled = slowStepIndicatorEnabled;
    }

    public StepMeta getStartHopStep() {
        return this.startHopStep;
    }

    public Point getEndHopLocation() {
        return this.endHopLocation;
    }

    public StepMeta getEndHopStep() {
        return this.endHopStep;
    }

    public StepMeta getNoInputStep() {
        return this.noInputStep;
    }

    public StreamInterface.StreamType getCandidateHopType() {
        return this.candidateHopType;
    }

    public boolean isStartErrorHopStep() {
        return this.startErrorHopStep;
    }
}

