/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.msgboxinfo;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.gui.GUIFactory;
import org.pentaho.di.core.gui.ThreadDialogs;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryMsgBoxInfo
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String bodymessage = null;
    private String titremessage = null;

    public JobEntryMsgBoxInfo(String n, String scr) {
        super(n, "");
    }

    public JobEntryMsgBoxInfo() {
        this("", "");
    }

    @Override
    public Object clone() {
        JobEntryMsgBoxInfo je = (JobEntryMsgBoxInfo)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"bodymessage", (String)this.bodymessage));
        retval.append("      ").append(XMLHandler.addTagValue((String)"titremessage", (String)this.titremessage));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.bodymessage = XMLHandler.getTagValue((Node)entrynode, (String)"bodymessage");
            this.titremessage = XMLHandler.getTagValue((Node)entrynode, (String)"titremessage");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load job entry of type 'Msgbox Info' from XML node", (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.bodymessage = rep.getJobEntryAttributeString(id_jobentry, "bodymessage");
            this.titremessage = rep.getJobEntryAttributeString(id_jobentry, "titremessage");
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'Msgbox Info' from the repository with id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "bodymessage", this.bodymessage);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "titremessage", this.titremessage);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'Msgbox Info' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public boolean evaluate(Result result) {
        try {
            boolean response = true;
            ThreadDialogs dialogs = GUIFactory.getThreadDialogs();
            if (dialogs != null) {
                response = dialogs.threadMessageBox(this.getRealBodyMessage() + Const.CR, this.getRealTitleMessage(), true, 3);
            }
            return response;
        }
        catch (Exception e) {
            result.setNrErrors(1L);
            this.logError("Couldn't display message box: " + e.toString());
            return false;
        }
    }

    @Override
    public Result execute(Result prev_result, int nr) {
        prev_result.setResult(this.evaluate(prev_result));
        return prev_result;
    }

    @Override
    public boolean resetErrorsBeforeExecution() {
        return false;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return false;
    }

    public String getRealTitleMessage() {
        return this.environmentSubstitute(this.getTitleMessage());
    }

    public String getRealBodyMessage() {
        return this.environmentSubstitute(this.getBodyMessage());
    }

    public String getTitleMessage() {
        if (this.titremessage == null) {
            this.titremessage = "";
        }
        return this.titremessage;
    }

    public String getBodyMessage() {
        if (this.bodymessage == null) {
            this.bodymessage = "";
        }
        return this.bodymessage;
    }

    public void setBodyMessage(String s) {
        this.bodymessage = s;
    }

    public void setTitleMessage(String s) {
        this.titremessage = s;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.addOkRemark(this, "bodyMessage", remarks);
        JobEntryValidatorUtils.addOkRemark(this, "titleMessage", remarks);
    }
}

