/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import org.apache.http.HttpConnection;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.ExecutionContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class HttpCoreContext
implements HttpContext,
ExecutionContext {
    private final HttpContext context;

    public static HttpCoreContext create() {
        return new HttpCoreContext(new BasicHttpContext());
    }

    public static HttpCoreContext adapt(HttpContext context) {
        Args.notNull(context, "HTTP context");
        if (context instanceof HttpCoreContext) {
            return (HttpCoreContext)context;
        }
        return new HttpCoreContext(context);
    }

    public HttpCoreContext(HttpContext context) {
        this.context = context;
    }

    public HttpCoreContext() {
        this.context = new BasicHttpContext();
    }

    @Override
    public Object getAttribute(String id) {
        return this.context.getAttribute(id);
    }

    @Override
    public void setAttribute(String id, Object obj) {
        this.context.setAttribute(id, obj);
    }

    @Override
    public Object removeAttribute(String id) {
        return this.context.removeAttribute(id);
    }

    protected <T> T getAttribute(String attribname, Class<T> clazz) {
        Args.notNull(clazz, "Attribute class");
        Object obj = this.getAttribute(attribname);
        if (obj == null) {
            return null;
        }
        return clazz.cast(obj);
    }

    public <T extends HttpConnection> T getConnection(Class<T> clazz) {
        return (T)((HttpConnection)this.getAttribute("http.connection", clazz));
    }

    public HttpConnection getConnection() {
        return this.getAttribute("http.connection", HttpConnection.class);
    }

    public HttpRequest getRequest() {
        return this.getAttribute("http.request", HttpRequest.class);
    }

    public boolean isRequestSent() {
        Boolean b = this.getAttribute("http.request_sent", Boolean.class);
        return b != null ? b : false;
    }

    public HttpResponse getResponse() {
        return this.getAttribute("http.response", HttpResponse.class);
    }

    public void setTargetHost(HttpHost host) {
        this.setAttribute("http.target_host", host);
    }

    public HttpHost getTargetHost() {
        return this.getAttribute("http.target_host", HttpHost.class);
    }
}

