/*
 * Decompiled with CFR 0.152.
 */
package com.his.jackson.module.jaxb.ser;

import com.his.jackson.core.JsonGenerator;
import com.his.jackson.core.JsonProcessingException;
import com.his.jackson.databind.JavaType;
import com.his.jackson.databind.JsonMappingException;
import com.his.jackson.databind.JsonNode;
import com.his.jackson.databind.SerializerProvider;
import com.his.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.his.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.his.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.his.jackson.databind.node.ObjectNode;
import com.his.jackson.databind.ser.std.StdSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import javax.activation.DataHandler;

public class DataHandlerJsonSerializer
extends StdSerializer<DataHandler> {
    private static final long serialVersionUID = 1L;

    public DataHandlerJsonSerializer() {
        super(DataHandler.class);
    }

    public void serialize(DataHandler value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        InputStream in = value.getInputStream();
        int len = in.read(buffer);
        while (len > 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        in.close();
        jgen.writeBinary(out.toByteArray());
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2;
        if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
            v2.itemsFormat(JsonFormatTypes.STRING);
        }
    }

    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("array", true);
        ObjectNode itemSchema = this.createSchemaNode("string");
        o.set("items", (JsonNode)itemSchema);
        return o;
    }
}

