/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom.wrappers;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Location;
import org.eigenbase.xom.wrappers.W3CDOMWrapper;

public class Annotator {
    private final List locInfoList = new ArrayList();
    private int[] lineStartPositions;
    private final String xml;
    private final Map wrapperLocMap = new HashMap();
    private final Map nodeLocMap = new HashMap();
    private int seq;
    private static final int STATE_NORMAL = 0;
    private static final int STATE_TAG = 1;
    private static final int STATE_ENDTAG = 2;
    private static final int STATE_QUOT = 3;
    private static final int STATE_APOS = 4;
    private static final int STATE_COMMENT = 5;
    private static final int STATE_CDATA = 6;
    private static final int TYPE_ELEMENT = 1;
    private static final int TYPE_PROCESSING_INSTRUCTION = 7;
    private static final int TYPE_COMMENT = 8;
    private static final int TYPE_CDATA_SECTION = 4;
    private static final int TYPE_TEXT = 3;
    static final /* synthetic */ boolean $assertionsDisabled;

    Annotator(String string, DOMWrapper dOMWrapper) {
        this.xml = string;
        this.parse(string);
        if (dOMWrapper != null) {
            this.seq = 0;
            this.populateMap(dOMWrapper);
            if (!$assertionsDisabled && this.nodeLocMap.size() != this.wrapperLocMap.size()) {
                throw new AssertionError();
            }
        }
    }

    public Location getLocation(DOMWrapper dOMWrapper) {
        LocInfo locInfo = (LocInfo)this.wrapperLocMap.get(dOMWrapper);
        if (locInfo == null && (locInfo = (LocInfo)this.nodeLocMap.get(((W3CDOMWrapper)dOMWrapper).node)) == null) {
            return null;
        }
        final LocInfo locInfo2 = locInfo;
        return new Location(){

            public int getStartLine() {
                return Annotator.this.getLine(this.getStartPos()) + 1;
            }

            public int getStartColumn() {
                return Annotator.this.getCol(this.getStartPos()) + 1;
            }

            public int getStartPos() {
                return locInfo2.startTagStartPos;
            }

            public int getEndLine() {
                return Annotator.this.getLine(this.getEndPos()) + 1;
            }

            public int getEndColumn() {
                return Annotator.this.getCol(this.getEndPos()) + 1;
            }

            public int getEndPos() {
                return locInfo2.endTagEndPos >= 0 ? locInfo2.endTagEndPos : locInfo2.startTagEndPos;
            }

            public String getText(boolean bl) {
                return locInfo2.getText(bl);
            }

            public String toString() {
                return locInfo2.toString(Annotator.this);
            }
        };
    }

    List getLocInfoList() {
        return this.locInfoList;
    }

    void parse(String string) {
        int n;
        ArrayStack arrayStack = new ArrayStack();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        arrayList.add(new Integer(n4));
        arrayStack.push(null);
        LocInfo locInfo = null;
        block45: while (n4 < n3) {
            n = string.charAt(n4);
            block1 : switch (n) {
                case 60: {
                    switch (n2) {
                        case 0: {
                            if (n4 > n5) {
                                LocInfo locInfo2 = new LocInfo(this.locInfoList.size(), 3, n5);
                                locInfo2.endTagEndPos = n4;
                                this.locInfoList.add(locInfo2);
                            }
                            if (n4 + 1 < n3) {
                                char c = string.charAt(n4 + 1);
                                switch (c) {
                                    case '/': {
                                        n2 = 2;
                                        if (!$assertionsDisabled && locInfo == null) {
                                            throw new AssertionError();
                                        }
                                        break block1;
                                    }
                                    case '?': {
                                        locInfo = new LocInfo(this.locInfoList.size(), 7, n4);
                                        this.locInfoList.add(locInfo);
                                        n2 = 1;
                                        n4 += "<?".length();
                                        continue block45;
                                    }
                                    case '!': {
                                        if (string.startsWith("--", n4 + 2)) {
                                            locInfo = new LocInfo(this.locInfoList.size(), 8, n4);
                                            this.locInfoList.add(locInfo);
                                            n2 = 5;
                                            n4 += "<!--".length();
                                            continue block45;
                                        }
                                        if (!string.startsWith("[CDATA[", n4 + 2)) break;
                                        locInfo = new LocInfo(this.locInfoList.size(), 4, n4);
                                        this.locInfoList.add(locInfo);
                                        n2 = 6;
                                        n4 += "<![CDATA[".length();
                                        continue block45;
                                    }
                                }
                            }
                            n2 = 1;
                            locInfo = new LocInfo(this.locInfoList.size(), 1, n4);
                            this.locInfoList.add(locInfo);
                            ++n4;
                            continue block45;
                        }
                    }
                    break;
                }
                case 62: {
                    switch (n2) {
                        case 1: {
                            ++n4;
                            if (!$assertionsDisabled && locInfo == null) {
                                throw new AssertionError();
                            }
                            switch (locInfo.type) {
                                case 4: 
                                case 7: 
                                case 8: {
                                    locInfo.endTagEndPos = n4;
                                    locInfo = (LocInfo)arrayStack.peek();
                                    break;
                                }
                                default: {
                                    locInfo.startTagEndPos = n4;
                                    arrayStack.push(locInfo);
                                }
                            }
                            n5 = n4;
                            n2 = 0;
                            continue block45;
                        }
                        case 2: {
                            ++n4;
                            if (!$assertionsDisabled && locInfo == null) {
                                throw new AssertionError();
                            }
                            locInfo.endTagEndPos = n4;
                            try {
                                locInfo = (LocInfo)arrayStack.pop();
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                throw new RuntimeException("i=" + n4 + ", xml=" + this.xml.substring(n4) + ", nodeList=" + this.locInfoList, indexOutOfBoundsException);
                            }
                            n5 = n4;
                            n2 = 0;
                            continue block45;
                        }
                    }
                    break;
                }
                case 47: {
                    switch (n2) {
                        case 1: {
                            if (++n4 >= n3 || string.charAt(n4) != '>') continue block45;
                            locInfo.endTagEndPos = ++n4;
                            locInfo = (LocInfo)arrayStack.peek();
                            n5 = n4;
                            n2 = 0;
                            continue block45;
                        }
                    }
                    break;
                }
                case 93: {
                    switch (n2) {
                        case 6: {
                            if (!string.startsWith("]>", n4 + 1)) break;
                            n2 = 0;
                            locInfo.endTagEndPos = n4 += "]]>".length();
                            locInfo = (LocInfo)arrayStack.peek();
                            n5 = n4;
                            continue block45;
                        }
                    }
                    break;
                }
                case 45: {
                    switch (n2) {
                        case 5: {
                            if (!string.startsWith("->", n4 + 1)) break;
                            locInfo.endTagEndPos = n4 += "-->".length();
                            n5 = n4;
                            locInfo = (LocInfo)arrayStack.peek();
                            n2 = 0;
                            continue block45;
                        }
                    }
                    break;
                }
                case 13: {
                    if (++n4 < n3 && string.charAt(n4) == '\n') {
                        ++n4;
                    }
                    arrayList.add(new Integer(n4));
                    continue block45;
                }
                case 10: {
                    arrayList.add(new Integer(++n4));
                    continue block45;
                }
                case 39: {
                    switch (n2) {
                        case 4: {
                            n2 = 1;
                            break block1;
                        }
                        case 1: {
                            n2 = 4;
                            break block1;
                        }
                    }
                    break;
                }
                case 34: {
                    switch (n2) {
                        case 3: {
                            n2 = 1;
                            break block1;
                        }
                        case 1: {
                            n2 = 3;
                            break block1;
                        }
                    }
                }
            }
            ++n4;
        }
        this.lineStartPositions = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            this.lineStartPositions[n] = (Integer)arrayList.get(n);
        }
    }

    private void populateMap(DOMWrapper dOMWrapper) {
        LocInfo locInfo;
        block2: {
            int n = dOMWrapper.getType();
            do {
                locInfo = (LocInfo)this.locInfoList.get(this.seq++);
                if (n == 2 && locInfo.type == 1 || n == 4 && locInfo.type == 3) break block2;
            } while (this.seq < this.locInfoList.size());
            return;
        }
        this.wrapperLocMap.put(dOMWrapper, locInfo);
        this.nodeLocMap.put(((W3CDOMWrapper)dOMWrapper).node, locInfo);
        DOMWrapper[] dOMWrapperArray = dOMWrapper.getElementChildren();
        for (int i = 0; i < dOMWrapperArray.length; ++i) {
            DOMWrapper dOMWrapper2 = dOMWrapperArray[i];
            this.populateMap(dOMWrapper2);
        }
    }

    int getLine(int n) {
        int n2 = Arrays.binarySearch(this.lineStartPositions, n);
        if (n2 >= 0) {
            return n2;
        }
        return -2 - n2;
    }

    int getCol(int n) {
        int n2 = Arrays.binarySearch(this.lineStartPositions, n);
        if (n2 >= 0) {
            return 0;
        }
        n2 = -2 - n2;
        return n - this.lineStartPositions[n2];
    }

    void list(PrintWriter printWriter) {
        for (int i = 0; i < this.locInfoList.size(); ++i) {
            LocInfo locInfo = (LocInfo)this.locInfoList.get(i);
            printWriter.println(locInfo.seq + ": " + locInfo.toString(this) + " [" + locInfo.getText(this.xml) + "]");
        }
        printWriter.flush();
    }

    static {
        $assertionsDisabled = !Annotator.class.desiredAssertionStatus();
    }

    private static class ArrayStack
    extends ArrayList {
        private ArrayStack() {
        }

        public final void push(Object object) {
            this.add(object);
        }

        public final Object peek() {
            return this.get(this.size() - 1);
        }

        public final Object pop() {
            int n = this.size() - 1;
            Object e = this.remove(n);
            return this.get(n - 1);
        }
    }

    class LocInfo {
        final int seq;
        final int startTagStartPos;
        final int type;
        int startTagEndPos = -1;
        int endTagEndPos = -1;

        LocInfo(int n, int n2, int n3) {
            this.seq = n;
            this.type = n2;
            this.startTagStartPos = n3;
        }

        public String toString(Annotator annotator) {
            return "line " + annotator.getLine(this.startTagStartPos) + ", column " + annotator.getCol(this.startTagStartPos);
        }

        public String getText(String string) {
            return string.substring(this.startTagStartPos, this.endTagEndPos >= 0 ? this.endTagEndPos : string.length());
        }

        public String getHeadText(String string) {
            return string.substring(this.startTagStartPos, this.startTagEndPos >= 0 ? this.startTagEndPos : (this.endTagEndPos >= 0 ? this.endTagEndPos : string.length()));
        }

        public String toString() {
            return this.getHeadText(Annotator.this.xml);
        }

        public String getText(boolean bl) {
            return Annotator.this.xml.substring(this.startTagStartPos, bl && this.startTagEndPos >= 0 ? this.startTagEndPos : (this.endTagEndPos >= 0 ? this.endTagEndPos : Annotator.this.xml.length()));
        }
    }
}

