/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.taglib.DbBaseInputTag;

public class DbFileTag
extends DbBaseInputTag
implements TryCatchFinally {
    private static Log logCat = LogFactory.getLog((String)DbFileTag.class.getName());
    private String accept;

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public String getAccept() {
        return this.accept;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    @Override
    public int doEndTag() throws JspException {
        try {
            StringBuffer tagBuf = new StringBuffer();
            if (this.hasReadOnlySet() || this.getParentForm().hasReadOnlySet()) {
                tagBuf.append("<input type=\"text\"");
            } else {
                tagBuf.append("<input type=\"file\"");
            }
            tagBuf.append(this.prepareName());
            if (this.accept != null) {
                tagBuf.append(" accept=\"");
                tagBuf.append(this.accept);
                tagBuf.append("\"");
            }
            tagBuf.append(this.prepareSize());
            tagBuf.append(this.prepareKeys());
            tagBuf.append(this.prepareStyles());
            tagBuf.append(this.prepareEventHandlers());
            tagBuf.append("/>");
            this.pageContext.getOut().write(tagBuf.toString());
        }
        catch (IOException ioe) {
            throw new JspException("IO Error: " + ioe.getMessage());
        }
        return 6;
    }

    @Override
    public void doFinally() {
        this.accept = null;
        super.doFinally();
    }

    @Override
    public int doStartTag() throws JspException {
        super.doStartTag();
        if (!this.getParentForm().hasMultipartSet()) {
            logCat.warn((Object)"DbFileTag is used but DbFormTag.multipart is not set (FALSE)");
            throw new JspException("DbFileTag is used but DbFormTag.multipart is not set (it is set to \"FALSE\"). you must set it to \"TRUE\" to enable file uploads!");
        }
        return 0;
    }
}

