/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event.datalist.dao;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbFormsConfigRegistry;
import org.dbforms.config.Field;
import org.dbforms.config.FieldValue;
import org.dbforms.config.FieldValues;
import org.dbforms.dom.DOMFactory;
import org.dbforms.event.datalist.dao.DataSource;
import org.dbforms.event.datalist.dao.XMLDataResult;
import org.dbforms.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataSourceXML
extends DataSource {
    private Hashtable keys;
    private Log logCat = LogFactory.getLog((String)this.getClass().getName());
    private String sqlFilter;
    private XMLDataResult data;
    private Object[][] dataObject = null;
    private FieldValue[] filterConstraint;
    private FieldValue[] orderConstraint;
    private FieldValue[] sqlFilterParams;

    @Override
    public void setSelect(FieldValue[] filterConstraint, FieldValue[] orderConstraint, String sqlFilter, FieldValue[] sqlFilterParams) {
        this.filterConstraint = filterConstraint;
        this.orderConstraint = orderConstraint;
        this.sqlFilter = sqlFilter;
        this.sqlFilterParams = sqlFilterParams;
    }

    public void doUpdate(Connection con, FieldValues fieldValues, String keyValuesStr) throws SQLException {
        Integer row = (Integer)this.keys.get(keyValuesStr);
        if (row != null) {
            int r = row;
            Iterator iter = fieldValues.elements();
            while (iter.hasNext()) {
                FieldValue fv = (FieldValue)iter.next();
                Field f = fv.getField();
                this.data.setItemValue(r, Util.isNull(f.getExpression()) ? f.getName() : f.getExpression(), f.getType(), fv.getFieldValueAsObject());
            }
            this.dataObject[r] = null;
        }
    }

    @Override
    protected final Object[] getRow(int currRow) throws SQLException {
        if (currRow < 0 || currRow >= this.size()) {
            return null;
        }
        if (this.dataObject[currRow] == null) {
            Vector fields = this.getTable().getFields();
            Object[] objectRow = new Object[fields.size()];
            String[] stringRow = new String[fields.size()];
            for (int i = 0; i < fields.size(); ++i) {
                Field f = (Field)fields.elementAt(i);
                objectRow[i] = this.data.getItemValue(currRow, Util.isNull(f.getExpression()) ? f.getName() : f.getExpression(), f.getType());
                stringRow[i] = objectRow[i] != null ? objectRow[i].toString() : null;
            }
            String key = this.getTable().getKeyPositionString(stringRow);
            this.keys.put(key, new Integer(currRow));
            this.dataObject[currRow] = objectRow;
        }
        return this.dataObject[currRow];
    }

    @Override
    protected final void close() {
        if (this.data != null && this.data.hasChanged()) {
            try {
                String url = this.getFilePath() + this.getQuery();
                this.write(url, this.data.getRoot());
            }
            catch (Exception e) {
                this.logCat.error((Object)e);
            }
        }
        if (this.keys != null) {
            this.keys.clear();
        }
        this.dataObject = null;
    }

    @Override
    protected final int findStartRow(String startRow) throws SQLException {
        Integer res = null;
        if (!Util.isNull(startRow)) {
            res = (Integer)this.keys.get(startRow);
        }
        return res != null ? res : 0;
    }

    @Override
    protected final void open() throws SQLException {
        if (this.dataObject == null) {
            try {
                String qry = this.getQuery();
                String url = this.getFilePath() + qry;
                try {
                    URL u = new URL(url);
                    qry = u.getQuery();
                }
                catch (Exception e) {
                    this.logCat.info((Object)"open", (Throwable)e);
                }
                Document doc = this.read(url);
                if (doc != null) {
                    Element elem = doc.getDocumentElement();
                    this.data = new XMLDataResult(elem, qry);
                }
            }
            catch (Exception e) {
                this.logCat.error((Object)"open", (Throwable)e);
                throw new SQLException(e.getMessage());
            }
            this.keys = new Hashtable();
            this.dataObject = new Object[this.size()][];
        }
    }

    @Override
    protected final int size() throws SQLException {
        return this.data != null ? this.data.size() : 0;
    }

    @Override
    protected boolean hasMore(int i) throws SQLException {
        return i < this.size();
    }

    protected Document read(String url) throws Exception {
        return DOMFactory.instance().read(url);
    }

    protected void write(String url, Element root) throws Exception {
        DOMFactory.instance().write(url, root);
    }

    private String getFilePath() throws Exception {
        return Util.replaceRealPath(this.getTable().getAlias(), DbFormsConfigRegistry.instance().lookup().getRealPath());
    }

    private String getQuery() throws SQLException {
        StringBuffer buf = new StringBuffer();
        String filter = this.getWhereClause();
        String psqlFilter = this.getSQLFilter();
        if (!Util.isNull(filter) || !Util.isNull(this.sqlFilter)) {
            buf.append("[");
            buf.append(filter);
            if (!Util.isNull(psqlFilter)) {
                if (!Util.isNull(filter)) {
                    buf.append(" and ");
                }
                buf.append(this.sqlFilter);
            }
            buf.append("]");
        }
        return buf.toString();
    }

    private String getSQLFilter() {
        int p1 = 0;
        int p2 = this.sqlFilter.indexOf(63, p1);
        StringBuffer buf = new StringBuffer();
        int cnt = 0;
        while (p2 > -1) {
            buf.append(this.sqlFilter.substring(p1, p2));
            if (cnt >= this.sqlFilterParams.length) {
                this.logCat.error((Object)("reference to a missing filterValue in " + this.sqlFilter));
                return null;
            }
            String value = this.sqlFilterParams[cnt].getFieldValue();
            if (!Util.isNull(value)) {
                buf.append("\"");
                buf.append(value);
                buf.append("\"");
            }
            p1 = p2 + 1;
            p2 = this.sqlFilter.indexOf(63, p1);
            ++cnt;
        }
        buf.append(this.sqlFilter.substring(p1));
        return buf.toString();
    }

    private String getWhereClause() throws SQLException {
        StringBuffer buf = new StringBuffer();
        if (!FieldValue.isNull(this.filterConstraint)) {
            for (int i = 0; i < this.filterConstraint.length; ++i) {
                Field f;
                if (i != 0) {
                    if (this.filterConstraint[i].getLogicalOR()) {
                        buf.append(" or ");
                    } else {
                        buf.append(" and ");
                    }
                }
                buf.append(Util.isNull((f = this.filterConstraint[i].getField()).getExpression()) ? f.getName() : f.getExpression());
                switch (this.filterConstraint[i].getOperator()) {
                    case 0: {
                        buf.append("=");
                        break;
                    }
                    case 6: {
                        buf.append("!=");
                        break;
                    }
                    case 1: {
                        buf.append("&gt;");
                        break;
                    }
                    case 2: {
                        buf.append("&lt;");
                        break;
                    }
                    case 3: {
                        buf.append("&gt;=");
                        break;
                    }
                    case 4: {
                        buf.append("&lt;=");
                    }
                }
                buf.append("\"");
                buf.append(this.filterConstraint[i].getFieldValueAsObject().toString());
                buf.append("\"");
            }
        }
        return buf.toString();
    }
}

