/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorResources;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.DbFormsErrors;
import org.dbforms.config.FieldValues;
import org.dbforms.config.MultipleValidationException;
import org.dbforms.event.DatabaseEvent;
import org.dbforms.util.MessageResources;

public abstract class ValidationEvent
extends DatabaseEvent {
    private static Log logCat = LogFactory.getLog((String)ValidationEvent.class.getName());

    public ValidationEvent(int tableId, String keyId, HttpServletRequest request, DbFormsConfig config) {
        super(tableId, keyId, request, config);
    }

    @Override
    public void doValidation(String formValidatorName, ServletContext context) throws MultipleValidationException {
        FieldValues fieldValues = this.getFieldValues();
        if (fieldValues.size() == 0) {
            return;
        }
        ValidatorResources vr = (ValidatorResources)context.getAttribute("Validator");
        if (vr == null) {
            return;
        }
        Validator validator = new Validator(vr, formValidatorName.trim());
        Vector errors = new Vector();
        DbFormsErrors dbFormErrors = (DbFormsErrors)context.getAttribute("dbformsErrors");
        Locale locale = MessageResources.getLocale(this.getRequest());
        validator.addResource(Validator.BEAN_KEY, (Object)fieldValues);
        validator.addResource("java.util.Vector", errors);
        validator.addResource(Validator.LOCALE_KEY, (Object)locale);
        validator.addResource("org.dbforms.config.DbFormsErrors", (Object)dbFormErrors);
        try {
            validator.validate();
        }
        catch (Exception ex) {
            logCat.error((Object)("\n!!! doValidation error for : " + formValidatorName + "  !!!\n" + ex));
        }
        if (errors.size() > 0) {
            throw new MultipleValidationException(errors);
        }
    }
}

