/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.devgui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.dbforms.devgui.BrowserTool;
import org.dbforms.devgui.DevGui;
import org.dbforms.devgui.EditorPanel;
import org.dbforms.devgui.FileNameTool;
import org.dbforms.devgui.FileUtility;
import org.dbforms.devgui.ProjectData;
import org.dbforms.devgui.PropertyPanel;
import org.dbforms.devgui.XSLTransformer;
import org.dbforms.xmldb.FileSplitter;

public class XSLTransformPanel
extends PropertyPanel
implements ActionListener,
ListSelectionListener {
    private DevGui parent;
    private EditorPanel panel_editor;
    private JButton b_browse;
    private JButton b_openInBrowser;
    private JButton b_refresh;
    private JButton b_refreshJSPs;
    private JButton b_start;
    private JCheckBox cb_useJsCalendar;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList list_results;
    private JList list_xslStylesheets;
    private JPanel jPanel2;
    private JTextField tf_stylesheetDir;
    private JTextField tf_xsltEncoding;
    private File[] JSPs;
    private File[] availableStylesheets;

    public XSLTransformPanel(DevGui parent) {
        super(parent.getProjectData());
        this.parent = parent;
        this.initComponents();
        this.initComponents2();
        this.refreshAvailableStylesheets();
        this.refreshJSPs();
        this.doLayout();
    }

    @Override
    public void setNewProjectData(ProjectData projectData) {
        this.projectData = projectData;
        this.cb_useJsCalendar.setSelected("true".equalsIgnoreCase(projectData.getProperty("useJavaScriptCalendar")));
        this.tf_stylesheetDir.setText(projectData.getProperty("stylesheetDir"));
        this.tf_xsltEncoding.setText(projectData.getProperty("xsltEncoding"));
        this.refreshAvailableStylesheets();
        this.refreshJSPs();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.b_openInBrowser) {
            int selIndex = this.list_results.getSelectedIndex();
            if (selIndex != -1) {
                String selFileName = ((File)this.list_results.getModel().getElementAt(selIndex)).getName();
                String webAppURLStr = this.projectData.getProperty("webAppURL").trim();
                StringBuffer webAppURL = new StringBuffer(webAppURLStr);
                if (!webAppURLStr.endsWith("/")) {
                    webAppURL.append("/");
                }
                webAppURL.append(selFileName);
                try {
                    BrowserTool.openURL(webAppURL.toString());
                }
                catch (Exception ioe) {
                    this.showExceptionDialog(ioe);
                }
            }
        } else if (ev.getSource() == this.b_refresh) {
            this.refreshAvailableStylesheets();
        } else if (ev.getSource() == this.b_start) {
            this.performXSLTransformation();
        } else if (ev.getSource() == this.b_refreshJSPs) {
            this.refreshJSPs();
        } else if (ev.getSource() == this.b_browse) {
            File dlgFile;
            String stylesheetDir = this.projectData.getProperty("stylesheetDir");
            System.out.println("styleSheetDir=" + stylesheetDir + "!");
            System.out.println("ps2");
            if (!"".equals(stylesheetDir)) {
                System.out.println("ps3");
                dlgFile = new File(stylesheetDir);
                System.out.println("ps4");
            } else {
                System.out.println("ps5");
                dlgFile = null;
            }
            JFileChooser dlg_fileChooser = new JFileChooser(dlgFile);
            dlg_fileChooser.setFileSelectionMode(1);
            dlg_fileChooser.setVisible(true);
            int returnVal = dlg_fileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                String dirname = dlg_fileChooser.getSelectedFile().getAbsolutePath();
                this.tf_stylesheetDir.setText(dirname);
                this.projectData.setProperty("stylesheetDir", dirname);
                this.refreshAvailableStylesheets();
                this.tf_stylesheetDir.grabFocus();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.list_xslStylesheets) {
            int selIndex = this.list_xslStylesheets.getSelectedIndex();
            if (selIndex >= 0) {
                File f = (File)this.list_xslStylesheets.getModel().getElementAt(selIndex);
                this.panel_editor.setFile(f);
                this.b_start.setEnabled(true);
            } else {
                this.b_start.setEnabled(false);
            }
        } else if (e.getSource() == this.list_results) {
            int selIndex = this.list_results.getSelectedIndex();
            if (selIndex >= 0) {
                File f = (File)this.list_results.getModel().getElementAt(selIndex);
                this.panel_editor.setFile(f);
                this.b_openInBrowser.setEnabled(true);
            } else {
                this.b_openInBrowser.setEnabled(false);
            }
        }
    }

    private void initComponents() {
        this.b_browse = new JButton();
        this.jLabel1 = new JLabel();
        this.tf_stylesheetDir = new JTextField();
        this.tf_stylesheetDir.setText(this.projectData.getProperty("stylesheetDir"));
        this.jLabel2 = new JLabel();
        this.tf_xsltEncoding = new JTextField();
        this.tf_xsltEncoding.setText(this.projectData.getProperty("xsltEncoding"));
        this.setLayout(new GridBagLayout());
        JPanel panel_top = new JPanel();
        panel_top.setLayout(new GridLayout(1, 2));
        JPanel panel_top_left = new JPanel();
        panel_top_left.setLayout(new BorderLayout());
        panel_top_left.add("North", new JLabel("XSL stylesheets"));
        this.list_xslStylesheets = new JList();
        this.list_xslStylesheets.setSelectionMode(0);
        this.list_xslStylesheets.addListSelectionListener(this);
        panel_top_left.add("Center", new JScrollPane(this.list_xslStylesheets));
        JPanel panel_buttons1 = new JPanel();
        this.b_start = new JButton("start transformation!");
        panel_buttons1.add(this.b_start);
        this.b_start.addActionListener(this);
        this.b_start.setToolTipText("generate JSPs by applying selected XSL file to the dbforms config XML file.");
        this.b_refresh = new JButton("refresh list");
        panel_buttons1.add(this.b_refresh);
        this.b_refresh.addActionListener(this);
        this.b_refresh.setToolTipText("refresh XSL stylesheet repository in " + this.parent.getDbFormsHome().getAbsolutePath() + this.parent.getFileSeparator() + "xsl-stylesheets");
        panel_top_left.add("South", panel_buttons1);
        JPanel panel_top_right = new JPanel();
        panel_top_right.setLayout(new BorderLayout());
        panel_top_right.add("North", new JLabel("(Generated) JSP files in WebApp-Root"));
        this.list_results = new JList();
        this.list_results.setSelectionMode(0);
        this.list_results.addListSelectionListener(this);
        panel_top_right.add("Center", new JScrollPane(this.list_results));
        JPanel panel_buttons2 = new JPanel();
        this.b_openInBrowser = new JButton("Open in browser");
        this.b_openInBrowser.setToolTipText("Test a selected result file. Web server  must be running!");
        this.b_openInBrowser.addActionListener(this);
        this.b_refreshJSPs = new JButton("Refresh JSP list");
        this.b_refreshJSPs.addActionListener(this);
        this.b_refreshJSPs.setToolTipText("refresh listing of JSP files in your Web application");
        panel_buttons2.add(this.b_openInBrowser);
        panel_buttons2.add(this.b_refreshJSPs);
        panel_top_right.add("South", panel_buttons2);
        panel_top.add(panel_top_left);
        panel_top.add(panel_top_right);
        this.cb_useJsCalendar = new JCheckBox("Use JavaScript Calendar in generated pages for editing date fields");
        this.jPanel2 = new JPanel();
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText("Stylesheet Directory:   ");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints2);
        this.tf_stylesheetDir.setMinimumSize(new Dimension(50, 24));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        this.jPanel2.add((Component)this.tf_stylesheetDir, gridBagConstraints2);
        this.b_browse.setText("browse...");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        this.jPanel2.add((Component)this.b_browse, gridBagConstraints2);
        this.jLabel2.setText("XSLT Encoding:   ");
        this.jLabel2.setHorizontalTextPosition(4);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints3);
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.weightx = 1.0;
        this.tf_xsltEncoding.setMinimumSize(new Dimension(50, 24));
        this.jPanel2.add((Component)this.tf_xsltEncoding, gridBagConstraints3);
        this.cb_useJsCalendar.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                XSLTransformPanel.this.projectData.setProperty("useJavaScriptCalendar", XSLTransformPanel.this.cb_useJsCalendar.isSelected() ? "true" : "false");
            }
        });
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.jPanel2, gridBagConstraints1);
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.cb_useJsCalendar, gridBagConstraints1);
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 0.5;
        gridBagConstraints1.weighty = 0.5;
        this.add((Component)panel_top, gridBagConstraints1);
        this.panel_editor = new EditorPanel();
        gridBagConstraints1.gridy = 3;
        this.add((Component)this.panel_editor, gridBagConstraints1);
        this.list_xslStylesheets.clearSelection();
        this.b_start.setEnabled(false);
        this.list_results.clearSelection();
        this.b_openInBrowser.setEnabled(false);
    }

    private void initComponents2() {
        this.b_browse.addActionListener(this);
        this.addAFocusListener(this.tf_stylesheetDir, "stylesheetDir");
        this.b_browse.setToolTipText("default: DBFORMS_HOME" + this.parent.getFileSeparator() + "xsl-stylesheets" + this.parent.getFileSeparator() + "\nDefault location for Stylesheets");
        this.addAFocusListener(this.tf_xsltEncoding, "xsltEncoding");
    }

    private void performXSLTransformation() {
        System.out.println(this.projectData.toString());
        boolean useJsCalendar = "true".equalsIgnoreCase(this.projectData.getProperty("useJavaScriptCalendar"));
        String webAppRoot = this.projectData.getProperty("webAppRoot");
        System.out.println("webAppRoot=" + webAppRoot + "!");
        if ("".equals(webAppRoot)) {
            JOptionPane.showMessageDialog(this, "Please provide web application root", "missing data", 0);
            return;
        }
        String sourcePath = this.projectData.getProperty("configFile");
        File sourceFile = new File(sourcePath);
        System.out.println("sourcePath=" + sourcePath);
        if (!sourceFile.exists() || !sourceFile.canRead()) {
            JOptionPane.showMessageDialog(this, "Please provide correct XML config file, " + sourcePath + " is wrong", "wrong data", 0);
            return;
        }
        File transformFile = (File)this.list_xslStylesheets.getModel().getElementAt(this.list_xslStylesheets.getSelectedIndex());
        if (!transformFile.exists() || !transformFile.canRead()) {
            JOptionPane.showMessageDialog(this, "Please provide correct XSL stylesheet", "wrong data", 0);
            return;
        }
        String destPath = FileNameTool.normalize(this.parent.getDbFormsHome().getAbsolutePath()) + "temp" + this.parent.getFileSeparator() + "temp_result.xhtml";
        File destFile = new File(destPath);
        try {
            String xsltEncoding = this.projectData.getProperty("xsltEncoding");
            if (xsltEncoding != null) {
                xsltEncoding = xsltEncoding.trim();
            }
            XSLTransformer.transform(sourceFile, transformFile, destFile, useJsCalendar, xsltEncoding);
            FileSplitter fs = new FileSplitter(destFile, new File(webAppRoot));
            fs.splitFile();
            this.refreshJSPs();
            JOptionPane.showMessageDialog(this, "XSL Transformation done.\nCheck new JSPs in your WebApp root", "XSL result", -1);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error during transform:" + e.toString(), "XSL transform error", 0);
        }
    }

    private void refreshAvailableStylesheets() {
        String xslDirStr = FileNameTool.normalize(this.parent.getProjectData().getProperty("stylesheetDir"));
        File xslDir = new File(xslDirStr);
        if (xslDir.isDirectory() && xslDir.canRead()) {
            try {
                this.availableStylesheets = FileUtility.getFilesInDirectory(xslDir, null);
                this.list_xslStylesheets.setListData(this.availableStylesheets);
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                this.showExceptionDialog(ioe);
            }
        }
    }

    private void refreshJSPs() {
        String jspDirStr = this.projectData.getProperty("webAppRoot");
        File jspDir = new File(jspDirStr);
        if (jspDir.isDirectory() && jspDir.canRead()) {
            try {
                String[] postFixList = new String[]{".jsp"};
                this.JSPs = FileUtility.getFilesInDirectory(jspDir, postFixList);
                this.list_results.setListData(this.JSPs);
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                this.showExceptionDialog(ioe);
            }
        }
    }
}

